# .NET Core 3.1.0 Preview 3

.NET Core 3.1.0 Preview 3 comprises:

* .NET Core Runtime 3.1.0-preview3.19553.2
* ASP.NET Core 3.1.0-preview3.19555.2
* .NET Core 3.1.100-preview3-014645

See the [Release Notes](3.1.0-preview3) for details about what is included in this update.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using Snap

Because of the isolated environment, using Snap is the preferred way to install and try .NET Core Previews on [Linux distributions that support Snap](https://docs.snapcraft.io/installing-snapd/6735).

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel=3.1/beta --classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distributions require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [Linux Setup](https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md) for a possible resolution.

### Install using deb/rpm packages

Preview release installers are not available from the Microsoft package repositories but you can download them and install manually or, set up a local package repository. Setting up a local package repository will result in a typical package manager installation experience. Consult your distribution's documentation to understand this option.

A manual installation requires the use of your distribution's package installer to install each of the files *in the order presented below.* If you attempt to install them out of order, dependency checks will not succeed and the installation will fail. Download the correct System Dependencies Installer along with the `host, hostfxr, runtime, aspnetcore-runtime` and `sdk` installers.

Please see the [3.1 Supported OS](https://github.com/dotnet/core/blob/master/release-notes/3.1/3.1-supported-os.md) document for specific distribution version support status.

| **System Dependencies Installer** |
| :-- |
| [CentOS 7+][dotnet-runtime-deps-centos.7-x64.rpm] |
| [Fedora][dotnet-runtime-deps-fedora.27-x64.rpm] |
| [OpenSUSE][dotnet-runtime-deps-opensuse.42-x64.rpm] |
| [Oracle Linux 7+][dotnet-runtime-deps-oraclelinux.7-x64.rpm] |
| [RHEL 7+][dotnet-runtime-deps-rhel.7-x64.rpm] |
| [SLES 12][dotnet-runtime-deps-sles.12-x64.rpm] |
| [Debian 9+][dotnet-runtime-deps-x64.deb] |

| **Component** | **Package Type** |
| :--- | :---: |
| dotnet-host | [deb][dotnet-host-x64.deb] \| [rpm][dotnet-host-x64.rpm] |
| dotnet-hostfxr | [deb][dotnet-hostfxr-x64.deb] \| [rpm][dotnet-hostfxr-x64.rpm] |
| dotnet-runtime | [deb][dotnet-runtime-x64.deb] \| [rpm][dotnet-runtime-x64.rpm] |
| aspnetcore-runtime | [deb][aspnetcore-runtime-x64.deb] \| [rpm][aspnetcore-runtime-x64.rpm] |
| dotnet-targeting-pack | [deb][dotnet-targeting-pack-x64.deb] \| [rpm][dotnet-targeting-pack-x64.rpm] |
| dotnet-apphost-targeting-pack | [deb][dotnet-apphost-pack-x64.deb] \| [rpm][dotnet-apphost-pack-x64.rpm] |
| aspnetcore-targeting-pack | [deb][aspnetcore-targeting-pack.deb] \| [rpm][aspnetcore-targeting-pack.rpm] |
| dotnet-sdk | [deb][dotnet-sdk-x64.deb] \| [rpm][dotnet-sdk-x64.rpm] |

After downloading the files, run your package utility to install the files in the following order.

1. dotnet-runtime-deps (System Dependencies Installer)
2. dotnet-host
3. dotnet-hostfxr
4. dotnet-runtime
5. aspnetcore-runtime
7. dotnet-apphost-targeting-pack
8. aspnetcore-targeting-pack
9. dotnet-sdk

**CentOS, Fedora, OpenSUSE, Oracle Linux, RHEL and SLES**
`sudo rpm -ivh [package name]`

**Debian and Ubuntu**
`sudo dpkg -i [package name]`

Here is a simple example script for Fedora to download and install the packages as described above.

``` bash
cd $HOME/Downloads
mkdir 3.1preview.3
cd 3.1preview.3

wget -c https://download.visualstudio.microsoft.com/download/pr/5115e89e-c2c7-4c18-8b71-65b6bf47ddc8/cfa419e6c6677169c91c5f0b35d16413/dotnet-host-3.1.0-preview3.19553.2-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/3a6c6841-af2f-4ae1-aea7-197f1bd4d82d/208e16d99330eec975c3e3ec43bfbf9c/dotnet-hostfxr-3.1.0-preview3.19553.2-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/c8152532-19f5-4c9c-b3f5-5db00bcdc183/5746bf3fe020e8c3cbd283379407bd45/dotnet-runtime-3.1.0-preview3.19553.2-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/337dbf45-0bd2-4654-95ce-55ee3338a0d1/0f9fa774c1e2575927817218ff4a119b/dotnet-runtime-deps-3.1.0-preview3.19553.2-fedora.27-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/20d5199b-c04a-4233-a787-25af8e5f4a23/9ecf5ddb4e4bc80404293aa3653c9bab/aspnetcore-runtime-3.1.0-preview3.19555.2-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/b095aa96-b0f0-465a-ab59-097de76e50fe/2a3f0c0ec43d6cf5ccff91278f076f56/dotnet-sdk-3.1.100-preview3-014645-x64.rpm

wget -c https://download.visualstudio.microsoft.com/download/pr/04fc64aa-a5e7-4673-a3f1-bbad9bd118c6/7e35af867155fd3c540853482f5001b0/dotnet-apphost-pack-3.1.0-preview3.19553.2-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/d21a8ca7-c6dc-48f2-9729-878d1d100345/fa7822110d4c91731b1e1630470af357/dotnet-targeting-pack-3.1.0-preview3.19553.2-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/7ff0dcd3-76c9-413d-ab68-edc768ccd5e7/3d00e8fbc5cd530204765925c6fe3f5c/aspnetcore-targeting-pack-3.1.0-preview3.19555.2.rpm

sudo rpm -ivh dotnet-runtime-deps-3.1.0-preview3.19553.2-fedora.27-x64.rpm
sudo rpm -ivh dotnet-host-3.1.0-preview3.19553.2-x64.rpm
sudo rpm -ivh dotnet-hostfxr-3.1.0-preview3.19553.2-x64.rpm
sudo rpm -ivh dotnet-runtime-3.1.0-preview3.19553.2-x64.rpm
sudo rpm -ivh aspnetcore-runtime-3.1.0-preview3.19555.2-x64.rpm
sudo rpm -ivh dotnet-apphost-pack-3.1.0-preview3.19553.2-x64.rpm
sudo rpm -ivh dotnet-targeting-pack-3.1.0-preview3.19553.2-x64.rpm
sudo rpm -ivh aspnetcore-targeting-pack-3.1.0-preview3.19555.2.rpm
sudo rpm -ivh dotnet-sdk-3.1.100-preview3-014645-x64.rpm
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-3.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-3.1` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-3.1.0-preview3.19555.2-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/3.1/preview/3.1.0-preview3.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.0-preview3-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.0-preview3-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-core-3-1-preview-3/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-core-3-1-preview-3/

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.1.0-preview3+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.1.0-preview3+label%3ADone+label%3Aenhancement
[coreclr_bugs]: https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A3.1+label%3Abug+
[coreclr_features]: https://github.com/dotnet/coreclr/issues?q=is%3Aissue+milestone%3A3.1+label%3Aenhancement
[corefx_bugs]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.1+label%3Abug
[corefx_features]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.1+label%3Aenhancement


[//]: # ( Runtime 3.1.0-preview3.19553.2)
[dotnet-apphost-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/076aa090-ddbc-445e-b509-1a8b9bc0755b/9bbf57be915dca66f80aa61313089ee5/dotnet-apphost-pack-3.1.0-preview3.19553.2-x64.deb
[dotnet-apphost-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/04fc64aa-a5e7-4673-a3f1-bbad9bd118c6/7e35af867155fd3c540853482f5001b0/dotnet-apphost-pack-3.1.0-preview3.19553.2-x64.rpm
[dotnet-host-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/3c464dc7-800d-4d95-b9e6-5ed4655e2623/a638e35e5686fe14f9d1b3899e0c12de/dotnet-host-3.1.0-preview3.19553.2-x64.deb
[dotnet-host-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/5115e89e-c2c7-4c18-8b71-65b6bf47ddc8/cfa419e6c6677169c91c5f0b35d16413/dotnet-host-3.1.0-preview3.19553.2-x64.rpm
[dotnet-hostfxr-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/4a0e1191-b65a-4c4a-9a45-ddbbf1205731/b86658a1b8ba4c1a6db1042e3d0fa54b/dotnet-hostfxr-3.1.0-preview3.19553.2-x64.deb
[dotnet-hostfxr-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/3a6c6841-af2f-4ae1-aea7-197f1bd4d82d/208e16d99330eec975c3e3ec43bfbf9c/dotnet-hostfxr-3.1.0-preview3.19553.2-x64.rpm
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9baad76-ef4b-4783-b52f-50616b180826/3fb390a260b8103909a4d725743c22c3/dotnet-runtime-3.1.0-preview3.19553.2-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e20b886c-a4c4-4349-bb51-8d7ec7538b92/f1c54869255c2c29587c5aa85f0a9c99/dotnet-runtime-3.1.0-preview3.19553.2-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7abc799e-1280-4e9c-8a35-770c67e8d676/056d1b58d878d318ff70b941542a6f56/dotnet-runtime-3.1.0-preview3.19553.2-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0eeb025f-c1d0-4a97-81a6-704092b8beb5/ee19cff2f6ac552749b88f848680dab1/dotnet-runtime-3.1.0-preview3.19553.2-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/00df5471-eaaf-4e0b-9c67-1e2b0975629e/b45c781b030d3acaf582ed9ebe537292/dotnet-runtime-3.1.0-preview3.19553.2-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/feaa11a2-1c4d-4e0e-aa0e-3767ac01ef6c/0e2cfba32c94e0395677e2d6e071b23e/dotnet-runtime-3.1.0-preview3.19553.2-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0d904df6-de76-45fa-aaa2-5cd515184f5b/54cdbf4e6916cf6a3f134d9a98bebf64/dotnet-runtime-3.1.0-preview3.19553.2-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/4fff618a-38e4-4005-91f9-9c32559e9c25/0e377e2b51ab196a8bd690b493d022c9/dotnet-runtime-3.1.0-preview3.19553.2-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f89f183f-10ab-4304-9b4d-5280f05020b0/7cd7e81a916c83e30818e7557ee3f550/dotnet-runtime-3.1.0-preview3.19553.2-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4f52ee18-ded8-4b9a-9888-5fd44da8a752/65af712da9ebe8138b2d892b18fdbe05/dotnet-runtime-3.1.0-preview3.19553.2-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8872aa70-0661-477a-9230-595442df69ba/c0cec714545ee74ba9dc88712a54afd1/dotnet-runtime-3.1.0-preview3.19553.2-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ed8d63fa-18ed-46e2-8919-79286b437d5b/1b29b54a7cbedac5b04450b18435513e/dotnet-runtime-3.1.0-preview3.19553.2-win-x86.zip
[dotnet-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/96f75bef-ef1e-4433-91fe-22a632d9412c/7313406b2d714548b7f36680007b113b/dotnet-runtime-3.1.0-preview3.19553.2-x64.deb
[dotnet-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/c8152532-19f5-4c9c-b3f5-5db00bcdc183/5746bf3fe020e8c3cbd283379407bd45/dotnet-runtime-3.1.0-preview3.19553.2-x64.rpm
[dotnet-runtime-deps-centos.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/7b891ae0-23c5-414b-8855-ed3af713647a/9c76af37806a7e8e19df47549456c201/dotnet-runtime-deps-3.1.0-preview3.19553.2-centos.7-x64.rpm
[dotnet-runtime-deps-fedora.27-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/337dbf45-0bd2-4654-95ce-55ee3338a0d1/0f9fa774c1e2575927817218ff4a119b/dotnet-runtime-deps-3.1.0-preview3.19553.2-fedora.27-x64.rpm
[dotnet-runtime-deps-opensuse.42-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/3e0d95ab-1628-4864-bbfa-507e553d4fbd/9630c78dc2d7a7f84e7afc9166290b6b/dotnet-runtime-deps-3.1.0-preview3.19553.2-opensuse.42-x64.rpm
[dotnet-runtime-deps-oraclelinux.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/50b333b9-70d3-4303-aed0-c8b758288c21/8b11343f577ccd6aac65f951d36ea807/dotnet-runtime-deps-3.1.0-preview3.19553.2-oraclelinux.7-x64.rpm
[dotnet-runtime-deps-rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/954f6b39-9d97-4287-ba9f-1ddbd418fec3/ceaea33e097c2bbd632542638554b9a0/dotnet-runtime-deps-3.1.0-preview3.19553.2-rhel.7-x64.rpm
[dotnet-runtime-deps-sles.12-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/1d1c7bc4-78d9-4316-a787-0f90e7ca55af/29173b43611992497a8de0e361a0dc2e/dotnet-runtime-deps-3.1.0-preview3.19553.2-sles.12-x64.rpm
[dotnet-runtime-deps-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/a2f02b45-6736-48da-80da-b5db00f50c24/fb40ff1fe70a3ea3dfacacbc204c1d0a/dotnet-runtime-deps-3.1.0-preview3.19553.2-x64.deb
[dotnet-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/81343755-93d5-458e-b397-241ded4052c4/44c9b1bcaefb4c64a9bf9edd52edf81e/dotnet-targeting-pack-3.1.0-preview3.19553.2-x64.deb
[dotnet-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/d21a8ca7-c6dc-48f2-9729-878d1d100345/fa7822110d4c91731b1e1630470af357/dotnet-targeting-pack-3.1.0-preview3.19553.2-x64.rpm

[//]: # ( ASP 3.1.0-preview3.19555.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb197db9-6158-4fe0-b5da-83fd9a39ec0e/01c6d1df4c14bf73cb17aed40962ccf1/aspnetcore-runtime-3.1.0-preview3.19555.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4b4ab5c1-d503-48fd-b607-7e967efc0b3a/2a28bcf9168d0483150729868867bae2/aspnetcore-runtime-3.1.0-preview3.19555.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/403af955-d346-4463-bdce-282ed6f5cdb9/e886b737518afe88278e63d33c2ecf71/aspnetcore-runtime-3.1.0-preview3.19555.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0ba154a9-0217-473c-9e62-ea85bbadec17/6f369f74d7beaf897c0538c4259a8618/aspnetcore-runtime-3.1.0-preview3.19555.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7fc998e4-6d8c-4cc4-ab9b-9ad591bc97f8/fb2e50aeff5c3464c78cd740392df91b/aspnetcore-runtime-3.1.0-preview3.19555.2-osx-x64.tar.gz
[aspnetcore-runtime-rh.rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/95dd5969-6109-4ca3-9cfb-361e6d768bc3/e382ef2ea2b4fc1fd69426ef0fa3fb40/aspnetcore-runtime-3.1.0-preview3.19555.2-rh.rhel.7-x64.rpm
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/24e6b70d-ea3d-4925-ae27-c09b0b6f2dbb/9e3fa70c47c8abfad397a54960b2ba6b/aspnetcore-runtime-3.1.0-preview3.19555.2-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/fafc0d07-887f-4460-94e0-16c3595ab5d7/5551ae31cac7af992d44900531869c22/aspnetcore-runtime-3.1.0-preview3.19555.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0f07f0c8-6d03-4adc-a809-b06a576e9ddf/7eb74f3c9097224ad232f6834c36f77c/aspnetcore-runtime-3.1.0-preview3.19555.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5ea17358-8c10-4122-af8d-8eb2da8215b2/a1fc08fd57334f1abb718f9c1091179b/aspnetcore-runtime-3.1.0-preview3.19555.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/90f94ae0-4db3-4ab8-ad05-ffbadebf2d89/d430c3a4568dfd3bd6283b6921122ee6/aspnetcore-runtime-3.1.0-preview3.19555.2-win-x86.zip
[aspnetcore-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/cc9e6631-62f7-4a41-b9c6-e429bc6bc3a6/ee53d5dc260c8295bb6291f0438055d7/aspnetcore-runtime-3.1.0-preview3.19555.2-x64.deb
[aspnetcore-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/20d5199b-c04a-4233-a787-25af8e5f4a23/9ecf5ddb4e4bc80404293aa3653c9bab/aspnetcore-runtime-3.1.0-preview3.19555.2-x64.rpm
[aspnetcore-targeting-pack.deb]: https://download.visualstudio.microsoft.com/download/pr/aba8eaa6-764c-49b9-a82d-1619ea191fea/ccb0c73e74f2e5d64edc5e8c952ded1d/aspnetcore-targeting-pack-3.1.0-preview3.19555.2.deb
[aspnetcore-targeting-pack.rpm]: https://download.visualstudio.microsoft.com/download/pr/7ff0dcd3-76c9-413d-ab68-edc768ccd5e7/3d00e8fbc5cd530204765925c6fe3f5c/aspnetcore-targeting-pack-3.1.0-preview3.19555.2.rpm
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/aaac7b0f-567c-4b09-9905-aba0e9cbb604/c977eafafa3f846fb081a496d6f9e640/dotnet-hosting-3.1.0-preview3.19555.2-win.exe

[//]: # ( SDK 3.1.100-preview3-014645 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/018e0c67-f335-4a44-b79f-79a4093342d7/29fc2229b5f83f4176b9c9ff16aebada/dotnet-sdk-3.1.100-preview3-014645-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/beadd57f-83ec-407a-96da-624c61c5fdcf/b1e5eb0c57f3558680e94310ba6c1470/dotnet-sdk-3.1.100-preview3-014645-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9893487d-ecfc-4654-a06d-a70d149ebae4/86997fe999ec5598d7e6fa8ae9d6cf66/dotnet-sdk-3.1.100-preview3-014645-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/941853c3-98c6-44ff-b11f-3892e4f91814/14e8f22c7a1d95dd6fe9a53296d19073/dotnet-sdk-3.1.100-preview3-014645-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f4377189-a171-425b-8ef6-f8f21e89a8b0/b0d3561b13bd43ab4771bb62a2fddd4d/dotnet-sdk-3.1.100-preview3-014645-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b29e180d-352b-4a27-9dd9-fb327f1e655f/6b4930d53b2d93f5edd927ef679bbeae/dotnet-sdk-3.1.100-preview3-014645-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/4e7d296b-67f0-44d4-8604-169210ef6e4c/016fc616bb1c8e0ef0314bdd7513250e/dotnet-sdk-3.1.100-preview3-014645-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/90a377d2-5255-4bce-8612-a11dc81fe450/8587dee87b56f392f96695177972c418/dotnet-sdk-3.1.100-preview3-014645-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/57e30e7e-d765-4e8b-90be-e904759386f2/3b73f472d962ccd7645d9b8d6db08e1a/dotnet-sdk-3.1.100-preview3-014645-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8362d64d-26d0-458b-b560-ca927fbd102b/c43ccfe2f8e1c640f994a33a16b98ef6/dotnet-sdk-3.1.100-preview3-014645-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/86bf80b7-2abb-4c21-8874-c0c4226ab0ec/8d826ba9082d9628b9e79be9ad34f1e9/dotnet-sdk-3.1.100-preview3-014645-win-x86.zip
[dotnet-sdk-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/e3fd1dac-b47e-43d3-9098-579396f7fab3/3fe41d4aa6703b557adb0b2131626313/dotnet-sdk-3.1.100-preview3-014645-x64.deb
[dotnet-sdk-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/b095aa96-b0f0-465a-ab59-097de76e50fe/2a3f0c0ec43d6cf5ccff91278f076f56/dotnet-sdk-3.1.100-preview3-014645-x64.rpm
