
# .NET Core 1.0.13

.NET Core 1.0.13 comprises:

* .NET Core Runtime 1.0.13
* .NET Core SDK 1.1.11

See the [Release Notes](https://github.com/dotnet/core/blob/master/release-notes/1.0/1.0.13.md) for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                                   | SDK Binaries<sup>1</sup>                            | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-dev-win-x86.exe] \| [x64][dotnet-dev-win-x64.exe] | [x86][dotnet-dev-win-x86.zip] \| [x64][dotnet-dev-win-x64.zip] | [x86][dotnet-win-x86.exe] \| [x64][dotnet-win-x64.exe] | [x86][dotnet-win-x86.zip] \| [x64][dotnet-win-x64.zip] | [Hosting Bundle][DotNetCore-WindowsHosting.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-dev-osx-x64.pkg]  | [x64][dotnet-dev-osx-x64.tar.gz]     | [x64][dotnet-osx-x64.pkg] | [x64][dotnet-osx-x64.tar.gz] | - |
| CentOS 7  | - | [x64][dotnet-dev-centos-x64.tar.gz] | - | [x64][dotnet-centos-x64.tar.gz]  | - |
| Debian 8  | - | [x64][dotnet-dev-debian-x64.tar.gz] | - | [x64][dotnet-debian-x64.tar.gz]  | - |
| RHEL 7    | -                                                | [x64][dotnet-dev-rhel-x64.tar.gz]                    | -                                                        | [x64][dotnet-rhel-x64.tar.gz] | - |
| Ubuntu 14.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu-x64.tar.gz] | - | [x64][dotnet-ubuntu-x64.tar.gz] | - |
| Ubuntu 16.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu.16.04-x64.tar.gz] | - | [x64][dotnet-ubuntu.16.04-x64.tar.gz]  | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -                                                | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | - |

1. Includes the .NET Core and ASP.NET Core runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

### Develop applications

To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

In your command prompt, run the following commands:

```bash
# Ubuntu 14.04, 16,04
sudo apt-get install apt-transport-https
sudo apt-get update
sudo apt-get install dotnet-dev-1.1.11
```

### Run applications

If you only need to run existing applications, run the following command.

```bash
# Ubuntu 14.04, 16,04
sudo apt-get install dotnet-sharedframework-microsoft.netcore.app-1.0.13
```

## Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## Windows Server Hosting

If you are looking to host stand-alone apps on Windows Servers, the ASP.NET Core Module for IIS can be installed separately on servers without installing .NET Core runtime. You can download the Windows (Server Hosting) installer and run the following command from an Administrator command prompt:

[DotNetCore.1.0.13_1.1.10-WindowsHosting.exe][DotNetCore-WindowsHosting.exe]

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/1.0/1.0.13.md

[dotnet-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/bf245f8d-baac-40c1-8e71-cbbba707567a/1409618b28f28081543611fc6b3975b2/dotnet-win-x86.1.0.13.zip
[dotnet-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/cb053d14-47f0-4b44-be07-10a8498c6e43/085f44c92dcc8f37f041362789d64652/dotnet-win-x86.1.0.13.exe
[dotnet-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9912c80e-d5cb-4444-ad0f-14c7d8be9934/6d84e4c1b52854fd3348b61a8f35390c/dotnet-win-x64.1.0.13.zip
[dotnet-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ca708427-f409-4c58-ba6c-8e4181165ca7/302fb8001cd5a43e1a2b3b298f178421/dotnet-win-x64.1.0.13.exe
[dotnet-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e0c8ff7d-f5bc-45f0-91a6-d498ca19ecdb/5a4c140f88ee9411c8c3422bbd3c21fb/dotnet-osx-x64.1.0.13.tar.gz
[dotnet-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f1abb833-4b3e-4c97-a1ef-5e8258a5bdf8/8e05b692b4e50005288c0712fc20ed9d/dotnet-osx-x64.1.0.13.pkg
[dotnet-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/239e6fa0-ad82-4536-a48e-655dd0ccab1a/89fcb7d66660bec8259c97cd1d554d88/dotnet-centos-x64.1.0.13.tar.gz
[dotnet-debian-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0459a9f3-c263-4086-b7e3-a846183f2132/c2f1813dd266658dd76628daba5806c3/dotnet-debian-x64.1.0.13.tar.gz
[dotnet-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9892faa7-c699-461d-afeb-dcd0869f544b/76cd9455b6623e390c4f61ca73d7701e/dotnet-ubuntu-x64.1.0.13.tar.gz
[dotnet-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30bac15b-7bca-4aa5-8981-bd71e171f3b0/ee84e87162dd3e344609faec9802cbde/dotnet-ubuntu.16.04-x64.1.0.13.tar.gz
[dotnet-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/632f280e-9f27-495f-bbe4-ccd17cde70ac/df8a4b586e8d7caa9ac6133e68aa41fe/dotnet-rhel-x64.1.0.13.tar.gz

[dotnet-dev-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/15a05546-15df-488f-adcf-0e77e86dbefb/1f902e78cfea6209c387adce764a88bc/dotnet-dev-osx-x64.1.1.11.tar.gz
[dotnet-dev-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3c23a7aa-eecd-461b-ad45-979c4c684917/1b464bd34c763e664f7eed6006889d87/dotnet-dev-osx-x64.1.1.11.pkg
[dotnet-dev-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/db408c7b-ef37-4374-b33b-a5b286adaa53/be0f0df977501c4df71ac3f04b9ce35e/dotnet-dev-win-x86.1.1.11.zip
[dotnet-dev-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9386d3bc-6799-4cc5-8288-c807674c72ed/b585db316f0d1c4cad749c247ef21b59/dotnet-dev-win-x86.1.1.11.exe
[dotnet-dev-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a298f85a-bc4c-4019-842e-021e397e3437/5c95727dfe79b600834291a8983b9507/dotnet-dev-win-x64.1.1.11.zip
[dotnet-dev-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/baf5a5a7-68d6-4cf1-afdf-47968b5f91e7/05e6dfe191607ef6135a34215464f600/dotnet-dev-win-x64.1.1.11.exe
[dotnet-dev-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/116bc57f-a6d6-474f-aca7-58c18fe0fac4/aa324344fc9c36623fb4a7c7e5bece0c/dotnet-dev-centos-x64.1.1.11.tar.gz
[dotnet-dev-debian-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1ef84426-c1d0-4e3b-86a4-7fce48baecb8/a47dbe0cd3bc1eefdabbf9354f60004b/dotnet-dev-debian-x64.1.1.11.tar.gz
[dotnet-dev-debian.9-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b5c87053-99b4-4c91-af5b-69a1c0e2c91e/ab8882f283fb7206d0f1ee965faa4288/dotnet-dev-debian.9-x64.1.1.11.tar.gz
[dotnet-dev-fedora.27-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/98eb7365-0ca8-4e29-b455-b165e583d0de/3a1da729266cb9b885f6747b376a0f7c/dotnet-dev-fedora.27-x64.1.1.11.tar.gz
[dotnet-dev-fedora.28-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b3e55604-5a36-412d-ada3-9a46bba55fd0/473cb6db3926c04b7598d750f1d30731/dotnet-dev-fedora.28-x64.1.1.11.tar.gz
[dotnet-dev-opensuse.42.3-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3b5e416e-1359-4638-b1f3-e0ac378d3550/13ee9ae8dd5bdd11a11abe1934542920/dotnet-dev-opensuse.42.3-x64.1.1.11.tar.gz
[dotnet-dev-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c0957a2b-cac6-44d8-b1cc-0dad4420c825/8dc69e33f8cf44152fdf173d3bf0b746/dotnet-dev-ubuntu-x64.1.1.11.tar.gz
[dotnet-dev-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c9f432a7-11fd-48a8-adef-fa95bc24a9ad/85a7293b69d07d5ed678ea21f6082539/dotnet-dev-ubuntu.16.04-x64.1.1.11.tar.gz
[dotnet-dev-ubuntu.18.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aeac042a-cfef-4064-b914-7419f13c20ae/be14353986c2fbb2259064bcd2cc522a/dotnet-dev-ubuntu.18.04-x64.1.1.11.tar.gz
[dotnet-dev-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e461be2e-e14f-4a78-b987-351da98fb9ab/dc2c11f04a967d3d5c15a9a47b2d9fcc/dotnet-dev-rhel-x64.1.1.11.tar.gz

[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/94463197-e5ce-4780-a3e3-824b593984a4/6c8ccf14c6d7c48f2abe97f35e3349a4/coreclr-1.0.13-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/c8437415-67ab-4a52-b9e2-cb2d873818cb/756c1aec8815d1d23852ee91a769739e/corefx-1.0.13-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/8b10e003-60e0-43de-80c8-1a1c93b0c9f8/fd1f4c730b2b2a808521686a470cd17b/core-setup-1.0.13-symbols.zip

[DotNetCore-WindowsHosting.exe]: https://download.visualstudio.microsoft.com/download/pr/b84d0334-d56b-47b3-9da4-c48a553ce286/5079d35485214be3fbd72a4fdf21a655/dotnetcore.1.0.13_1.1.10-windowshosting.exe

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.0.13-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.11-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/dotnet-core/1.0
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md
