<#
This is for all configuration values regarding the logging system

NOTES:
- All these configurations should have a handler, as the logging system relies entirely on static fields for performance reasons
- If you want to change the default values, change them both here AND in the C# library
#>

Set-DbatoolsConfig -FullName 'Logging.MaxErrorCount' -Value 128 -Initialize -Validation integerpositive -Handler { [Sqlcollaborative.Dbatools.Message.LogHost]::MaxErrorCount = $args[0] } -Description "The maximum number of error records maintained in-memory. This setting is on a per-Process basis. Runspaces share, jobs or other consoles counted separately."
Set-DbatoolsConfig -FullName 'Logging.MaxMessageCount' -Value 1024 -Initialize -Validation integerpositive -Handler { [Sqlcollaborative.Dbatools.Message.LogHost]::MaxMessageCount = $args[0] } -Description "The maximum number of messages that can be maintained in the in-memory message queue. This setting is on a per-Process basis. Runspaces share, jobs or other consoles counted separately."
Set-DbatoolsConfig -FullName 'Logging.MaxMessagefileBytes' -Value 5MB -Initialize -Validation integerpositive -Handler { [Sqlcollaborative.Dbatools.Message.LogHost]::MaxMessagefileBytes = $args[0] } -Description "The maximum size of a given logfile. When reaching this limit, the file will be abandoned and a new log created. Set to 0 to not limit the size. This setting is on a per-Process basis. Runspaces share, jobs or other consoles counted separately."
Set-DbatoolsConfig -FullName 'Logging.MaxMessagefileCount' -Value 5 -Initialize -Validation integerpositive -Handler { [Sqlcollaborative.Dbatools.Message.LogHost]::MaxMessagefileCount = $args[0] } -Description "The maximum number of logfiles maintained at a time. Exceeding this number will cause the oldest to be culled. Set to 0 to disable the limit. This setting is on a per-Process basis. Runspaces share, jobs or other consoles counted separately."
Set-DbatoolsConfig -FullName 'Logging.MaxErrorFileBytes' -Value 20MB -Initialize -Validation integerpositive -Handler { [Sqlcollaborative.Dbatools.Message.LogHost]::MaxErrorFileBytes = $args[0] } -Description "The maximum size all error files combined may have. When this number is exceeded, the oldest entry is culled. This setting is on a per-Process basis. Runspaces share, jobs or other consoles counted separately."
Set-DbatoolsConfig -FullName 'Logging.MaxTotalFolderSize' -Value 100MB -Initialize -Validation integerpositive -Handler { [Sqlcollaborative.Dbatools.Message.LogHost]::MaxTotalFolderSize = $args[0] } -Description "This is the upper limit of length all items in the log folder may have combined across all processes."
Set-DbatoolsConfig -FullName 'Logging.MaxLogFileAge' -Value (New-TimeSpan -Days 7) -Initialize -Validation timespan -Handler { [Sqlcollaborative.Dbatools.Message.LogHost]::MaxLogFileAge = $args[0] } -Description "Any logfile older than this will automatically be cleansed. This setting is global."
Set-DbatoolsConfig -FullName 'Logging.MessageLogFileEnabled' -Value $true -Initialize -Validation bool -Handler { [Sqlcollaborative.Dbatools.Message.LogHost]::MessageLogFileEnabled = $args[0] } -Description "Governs, whether a log file for the system messages is written. This setting is on a per-Process basis. Runspaces share, jobs or other consoles counted separately."
Set-DbatoolsConfig -FullName 'Logging.MessageLogEnabled' -Value $true -Initialize -Validation bool -Handler { [Sqlcollaborative.Dbatools.Message.LogHost]::MessageLogEnabled = $args[0] } -Description "Governs, whether a log of recent messages is kept in memory. This setting is on a per-Process basis. Runspaces share, jobs or other consoles counted separately."
Set-DbatoolsConfig -FullName 'Logging.ErrorLogFileEnabled' -Value $true -Initialize -Validation bool -Handler { [Sqlcollaborative.Dbatools.Message.LogHost]::ErrorLogFileEnabled = $args[0] } -Description "Governs, whether log files for errors are written. This setting is on a per-Process basis. Runspaces share, jobs or other consoles counted separately."
Set-DbatoolsConfig -FullName 'Logging.ErrorLogEnabled' -Value $true -Initialize -Validation bool -Handler { [Sqlcollaborative.Dbatools.Message.LogHost]::ErrorLogEnabled = $args[0] } -Description "Governs, whether a log of recent errors is kept in memory. This setting is on a per-Process basis. Runspaces share, jobs or other consoles counted separately."