<img src="https://raw.githubusercontent.com/world-class/REPL/master/_assets/images/repl.png" alt="REPL_logo" style="width: 100%; height: auto;"/>

[![first-timers-only](https://img.shields.io/badge/first--timers--only-friendly-blue.svg?style=flat-square)](https://www.firsttimersonly.com/) [![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://github.com/world-class/REPL/compare) ![GitHub](https://img.shields.io/github/license/world-class/REPL?style=flat-square)

A twist on the use of **REPL**, which stands for _read–eval–print
loop_ in computer programming. This repository aims to become a central
place to share resources that other learners have found useful,
especially in the context of studying a [BSc Computer Science offered by Goldsmiths, University of London](https://london.ac.uk/courses/computer-science) :school:.

<details>
<summary>Good luck in your journey!</summary>

<p>As the first cohort of students enrolling in this ~100% online
programme, it is in our interest to cooperate in order to maximize our
chances of celebrating all together when we graduate.</p>

<p>Good luck to all and may this path fulfill you, knowing that you will
find support along the way!</p>

</details>

<details>
<summary>Note on copyrighted material</summary>

<p><strong>This is not a place where you'll find prohibited
content, such as leaked confidential information and copyrighted
material. Anything that could potentially fall under the <a href="https://london.ac.uk/current-students/programme-documents/regulations">regulations of the University of London</a> will be removed if it appears by accident and you are welcome to
report it.</strong></p>

</details>

---

<br />

# • [Frequently Asked Questions (FAQ)](faq/README.md)

<br />

# Useful resources

- [Applying to UoL: Guide and FAQs about the process](applying_to_uol)
- [Books recommended by students in this degree](books)
- [Free software](software)
- [Kinks to be aware of in the different modules](kinks)
- [Notes from students, professors and more](https://github.com/world-class/REPL/tree/master/notes) (opens directly on GitHub).
- Online courses: [free resources](online_courses/free), [paid resources](online_courses/paid)
- [Podcasts](podcasts)
- [Slack resources](slack) (channels to join, important information available, help with using Slack, etc.)
- [Websites to visit](websites)
- [YouTube videos](youtube)

<br />

## How to ask for help?

<details>
<summary><strong>Reaching out to tutors and SRMs</strong></summary>

<p>Despite being ~100% remote, this degree is equipped with a team of tutors and SRMs (<em>Student Relationship Managers</em>) that can help you find what you need.</p>

<ul>
    <li>For module-specific inquiries, you can reach out to your tutors in the appropriate discussion forums on Coursera. Access any module you are enrolled in from the <a href="https://www.coursera.org/degrees/bachelor-of-science-computer-science-london/home/">home page of this degree</a> on Coursera.</li>
    <li>For non-academic questions, you can write <a href="https://www.coursera.org/learn/london-cs-orientation/discussions">in the <strong>Reach out</strong> forum</a> on Coursera.</li>
    <li>For private matters and other types of inquiries, you can write an email to <a href="mailto:BScCS-Support@london.ac.uk">BScCS-Support@london.ac.uk</a> or find an alternative route <a href="#contacting-each-other">in this section</a>, including phone numbers, Student Advice Center, Slack workspace and Discord server.</li>
</ul>

  </details>

<details>
<summary><strong>General advice on how to ask and find answers</strong></summary>

<p>Succeeding in this degree has a lot to do with how resourceful you are. This page is meant to be a helpful guidance along the way, but developing a few key skills on your own will become an increasing necessity, including being able to research online, debugging code effectively and knowing how to ask questions.</p>

<p>To get started on that learning path, please refer to the following web pages:</p>

<ul>
<li>Getting help<ul>
<li><a href="https://stackoverflow.com/help/how-to-ask">How to ask questions</a> - Stack Overflow</li>
<li><a href="https://stackoverflow.com/help/minimal-reproducible-example">How to create a minimal, reproducible example</a> - Stack Overflow</li>
<li><a href="https://codeblog.jonskeet.uk/2010/08/29/writing-the-perfect-question/">Writing the perfect question</a> - Jon Skeet&#39;s coding blog</li>
<li><a href="https://www.coursera.org/learn/uol-introduction-to-programming-1/lecture/uTcr6/code-philosophy-asking-for-help">Code philosophy, asking for help</a> - From <a href="modules/level_4/introduction_to_programming_i">Introduction to Programming I</a> module - :lock: <em>you need to be enrolled in this degree to view this lecture</em>.</li>
</ul>
</li>
<li>Debugging code<ul>
<li><a href="https://blog.hartleybrody.com/debugging-code-beginner/">10 Debugging Tips for Beginners: How to Troubleshoot and Fix Your Code Without Pulling Your Hair Out</a> - hartleybrody.com</li>
<li><a href="https://flight-manual.atom.io/hacking-atom/sections/debugging/">How to debug code in Atom editor</a> - Atom.io</li>
<li><a href="https://docs.microsoft.com/en-us/visualstudio/debugger/debugging-absolute-beginners?view=vs-2019">How to debug for absolute beginners in VS Code editor</a> - Microsoft.com</li>
<li><a href="https://github.com/adobe/brackets/wiki/How-to-Use-Brackets">How to use Brackets editor</a> - Adobe, on GitHub</li>
</ul>
</li>
<li>Finding answers<ul>
<li><a href="https://thebestschools.org/magazine/10-tips-to-improve-your-online-research/">10 Tips to Improve Your Online Research</a></li>
<li><a href="https://en.wikipedia.org/wiki/List_of_search_engines">List of search engines</a> - Wikipedia</li>
<li>Google<ul>
<li><a href="https://www.youtube.com/watch?v=erZ3IyBCXdY">15 Ways to Search Google 96% of People Don’t Know About</a> - YouTube</li>
<li><a href="https://www.lifehack.org/articles/technology/20-tips-use-google-search-efficiently.html">20 Google Search Tips to Use Google More Efficiently</a> - Lifehack </li>
<li><a href="http://www.powersearchingwithgoogle.com/course/aps">Advanced Power Searching</a> - Google Course</li>
<li><a href="https://coursebuilder.withgoogle.com/sample/course">Power Searching with Google</a> - Google Course</li>
</ul>
</li>
</ul>
</li>
</ul>

  </details>
<br />

## Modules in the curriculum

<details>
<summary><strong>Level 4 (year 1+)</strong></summary>

<table>
<thead>
<tr>
<th>Module name</th>
<th>Module code</th>
<th>Written exam?</th>
<th>Slack channel</th>
</tr>
</thead>
<tbody>
<tr>
<td><a href="modules/level_4/algorithms_and_data_structures_i">Algorithms and Data Structures I</a></td>
<td><strong>CM1035</strong></td>
<td><strong>Yes</strong></td>
<td><code>#cm1035-algos-data-i</code></td>
</tr>
<tr>
<td><a href="modules/level_4/computational_mathematics">Computational Mathematics</a> *</td>
<td><strong>CM1015</strong></td>
<td><strong>Yes</strong></td>
<td><code>#cm1015-computational-math</code></td>
</tr>
<tr>
<td><a href="modules/level_4/discrete_mathematics">Discrete Mathematics</a></td>
<td><strong>CM1020</strong></td>
<td><strong>Yes</strong></td>
<td><code>#cm1020-discrete-math</code></td>
</tr>
<tr>
<td><a href="modules/level_4/fundamentals_of_computer_science">Fundamentals of Computer Science</a></td>
<td><strong>CM1025</strong></td>
<td><strong>Yes</strong></td>
<td><code>#cm1025-fundamental-cs</code></td>
</tr>
<tr>
<td><a href="modules/level_4/how_computers_work">How Computers Work</a></td>
<td><strong>CM1030</strong></td>
<td><strong>Yes</strong></td>
<td><code>#cm1030-hcw</code> / <code>#rpl-google-it</code></td>
</tr>
<tr>
<td><a href="modules/level_4/introduction_to_programming_ii">Introduction to Programming II</a></td>
<td><strong>CM1010</strong></td>
<td>No</td>
<td><code>#cm1010-intro-prog-ii</code></td>
</tr>
<tr>
<td><a href="modules/level_4/introduction_to_programming_i">Introduction to Programming I</a></td>
<td><strong>CM1005</strong></td>
<td>No</td>
<td><code>#cm1005-intro-prog-i</code></td>
</tr>
<tr>
<td><a href="modules/level_4/web_development">Web Development</a></td>
<td><strong>CM1040</strong></td>
<td>No</td>
<td><code>#cm1040-web-dev</code></td>
</tr>
</tbody>
</table>
<p>* <strong>Not available for October 2019-March 2020</strong></p>

</details>

<details>
<summary><strong>Level 5 (year 2+)</strong></summary>

<table>
<thead>
<tr>
<th>Module name</th>
<th>Module code</th>
<th>Written exam?</th>
<th>Slack channel</th>
</tr>
</thead>
<tbody>
<tr>
<td><a href="modules/level_5/agile_software_projects">Agile Software Projects</a></td>
<td><strong>CM2020</strong></td>
<td>No</td>
<td></td>
</tr>
<tr>
<td><a href="modules/level_5/algorithms_and_data_structures_ii">Algorithms and Data Structures II</a></td>
<td><strong>CM2035</strong></td>
<td><strong>Yes</strong></td>
<td><code>#cm2035-algos-data-ii</code></td>
</tr>
<tr>
<td><a href="modules/level_5/computer_security">Computer Security</a></td>
<td><strong>CM2025</strong></td>
<td><strong>Yes</strong></td>
<td></td>
</tr>
<tr>
<td><a href="modules/level_5/databases_networks_and_the_web">Databases, Networks and the Web</a></td>
<td><strong>CM2040</strong></td>
<td><strong>Yes</strong></td>
<td><code>#cm2040-databases-networks-web</code></td>
</tr>
<tr>
<td><a href="modules/level_5/graphics_programming">Graphics Programming</a></td>
<td><strong>CM2030</strong></td>
<td>No</td>
<td><code>#cm2030-graphics-programming</code></td>
</tr>
<tr>
<td><a href="modules/level_5/object_oriented_programming">Object Oriented Programming</a></td>
<td><strong>CM2005</strong></td>
<td>No</td>
<td><code>#cm2005-object-oriented-programming</code></td>
</tr>
<tr>
<td><a href="modules/level_5/programming_with_data">Programming with Data</a></td>
<td><strong>CM2015</strong></td>
<td><strong>Yes</strong></td>
<td></td>
</tr>
<tr>
<td><a href="modules/level_5/software_design_and_development">Software Design and Development</a></td>
<td><strong>CM2010</strong></td>
<td><strong>Yes</strong></td>
<td></td>
</tr>
</tbody>
</table>

</details>

<details>
<summary><strong>Level 6 (year 3+)</strong></summary>

<p>There is a total of 13 possible modules in Level 6. Out of these,
<strong>6</strong> need to be taken along with a final project in order to
graduate. A student may either choose a specialism (see below) but may
also opt against a specialism to be able to study any <strong>6</strong> of the
following modules.</p>
<table>
<thead>
<tr>
<th>Module name</th>
<th>Module code</th>
<th>Written exam?</th>
</tr>
</thead>
<tbody>
<tr>
<td><a href="modules/level_6/cm_3045">3D Graphics and Animation</a></td>
<td><strong>CM3045</strong></td>
<td><strong>Yes</strong></td>
</tr>
<tr>
<td><a href="modules/level_6/cm_3035">Advanced Web Development</a></td>
<td><strong>CM3035</strong></td>
<td>No</td>
</tr>
<tr>
<td><a href="modules/level_6/cm_3020">Artificial Intelligence</a></td>
<td><strong>CM3020</strong></td>
<td><strong>Yes</strong></td>
</tr>
<tr>
<td><a href="modules/level_6/cm_3005">Data Science</a></td>
<td><strong>CM3005</strong></td>
<td>No</td>
</tr>
<tr>
<td><a href="modules/level_6/cm_3010">Databases and Advanced Data Techniques</a></td>
<td><strong>CM3010</strong></td>
<td><strong>Yes</strong></td>
</tr>
<tr>
<td><a href="modules/level_6/cm_3030">Games Development</a></td>
<td><strong>CM3030</strong></td>
<td><strong>Yes</strong></td>
</tr>
<tr>
<td><a href="modules/level_6/cm_3065">Intelligent Signal Processing</a></td>
<td><strong>CM3065</strong></td>
<td>No</td>
</tr>
<tr>
<td><a href="modules/level_6/cm_3055">Interaction Design</a></td>
<td><strong>CM3055</strong></td>
<td><strong>Yes</strong></td>
</tr>
<tr>
<td><a href="modules/level_6/cm_3015">Machine Learning and Neural Networks</a></td>
<td><strong>CM3015</strong></td>
<td><strong>Yes</strong></td>
</tr>
<tr>
<td><a href="modules/level_6/cm_3050">Mobile Development</a></td>
<td><strong>CM3050</strong></td>
<td>No</td>
</tr>
<tr>
<td><a href="modules/level_6/cm_3060">Natural Language Processing</a></td>
<td><strong>CM3060</strong></td>
<td><strong>Yes</strong></td>
</tr>
<tr>
<td><a href="modules/level_6/cm_3040">Physical Computing and Internet of Things</a></td>
<td><strong>CM3040</strong></td>
<td>No</td>
</tr>
<tr>
<td><a href="modules/level_6/cm_3025">Virtual Reality</a></td>
<td><strong>CM3025</strong></td>
<td><strong>Yes</strong></td>
</tr>
</tbody>
</table>

</details>

<details>
<summary><strong>Specialisms</strong></summary>

<p>Each specialism contains five prescribed modules from the above 13. All
five must be completed along with one elective module from any other
specialism. The specialisms are:</p>
<ul>
<li><a href="modules/level_6/data_science">Data Science</a> (<strong>CM3005</strong>)</li>
<li><a href="modules/level_6/games_dev">Games Development</a> (<strong>CM3030</strong>)</li>
<li><a href="modules/level_6/ml_ai">Machine Learning &amp; Artificial Intelligence</a> (<strong>CM3020</strong>)</li>
<li><a href="modules/level_6/phys_computing_iot">Physical Computing &amp; the Internet of Things</a> (<strong>CM3040</strong>)</li>
<li><a href="modules/level_6/user_experience">User Experience</a> (<strong>CM3055</strong>)</li>
<li><a href="modules/level_6/virtual_reality">Virtual Reality</a> (<strong>CM3025</strong>)</li>
<li><a href="modules/level_6/web_mobile_dev">Web &amp; Mobile Development</a> (<strong>CM3035</strong>)</li>
</ul>

</details>

<details>
<summary><strong>Final project</strong></summary>

<p>A final project must also be completed to graduate. If a student is
opting for a specialism, they are strongly encouraged to select a
relevant topic for the final project.</p>
<ul>
<li><a href="modules/level_6/final_project">Final Project</a> (<strong>CM3070</strong>, <em>written exam</em>)</li>
</ul>

</details>
<br />

## Calendar due dates and events

<details>
<summary><strong>Google Calendar</strong></summary>

<ul>
<li>Find out what, when and where things are happening with this <a href="https://calendar.google.com/calendar/embed?src=i8bo48kc5tnudmnn669v4m1vhs%40group.calendar.google.com">Google Calendar</a>.</li>
<li><strong>If you have a Google account</strong>, you can follow <a href="https://calendar.google.com/calendar/r?cid=aThibzQ4a2M1dG51ZG1ubjY2OXY0bTF2aHNAZ3JvdXAuY2FsZW5kYXIuZ29vZ2xlLmNvbQ">this link</a> instead.</li>
</ul>

  </details>

<details>
<summary><strong>See what's the current week</strong></summary>

<ul>
<li>Find out what week we are on right now in this very semester by <a href="https://week.atz.now.sh">following this link</a> (probably one of the simplest yet useful user interface you will ever see).</li>
</ul>

  </details>

<details>
<summary><strong>Sync deadlines and events from Coursera</strong></summary>

<ul>
<li><em>&quot;Automatically sync all the deadlines and other related items from all active courses to your calendar.&quot;</em> Simply visit the <a href="https://www.coursera.org/account-settings">account settings</a> page on Coursera and click on the <strong>Calendar Sync</strong> tab to see options to sync with Google Calendar, Apple Calendar and others.</li>
</ul>

  </details>
<br />

## Documents and resources provided publicly by the University of London

<details>
<summary><strong>Documents</strong></summary>

<ul>
<li><a href="https://london.ac.uk/about-us/how-university-run/policies/vle-code-conduct">Code of conduct</a></li>
<li><a href="./uol_documents/data_protection_policy.pdf">Data protection policy</a></li>
<li><a href="./uol_documents/events_due_diligence_privacy_notice.pdf">Events Due Diligence Privacy Notice</a></li>
<li><a href="./uol_documents/gdpr_rights_guide_students.pdf">GDPR Rights guide - students</a></li>
<li><a href="./uol_documents/guidelines_for_examinations_2018_19.pdf">Guidelines for Examinations 2018–2019</a></li>
<li><a href="./uol_documents/progregs_computer_science_2019_2020.pdf">Programme Regulations 2019–2020</a></li>
<li><a href="./uol_documents/progspec_computer_science_2019_2020.pdf">Programme specification, Computer Science 2019-2020</a></li>
<li><a href="./uol_documents/computer_science_prospectus_2019_20.pdf">Prospectus, Computer Science 2019-2020</a></li>
<li><a href="./uol_documents/online_library_academic_search_quick_start.pdf">Quick Start Guide - The Online Library</a></li>
<li><a href="./uol_documents/student_terms_and_conditions.pdf">Student Terms and Conditions 2019-2020</a></li>
<li><a href="./uol_documents/student_privacy_notice_uol_april_2018_final.pdf">Student privacy notice</a></li>
<li><a href="./uol_documents/welcome_webinar_questions_and_answers_september_24_2019.pdf">Welcome webinar Q&amp;A, September 24, 2019</a></li>
</ul>

  </details>

<details>
<summary><strong>Webpages of interest</strong></summary>

<ul>
<li>Exams<ul>
<li><a href="https://london.ac.uk/current-students/examinations">Examinations</a></li>
<li><a href="https://london.ac.uk/applications/how-it-works/how-assessment-works">How assessment works</a></li>
</ul>
</li>
<li><a href="https://london.ac.uk/applications/funding-your-study">Funding your study</a></li>
<li><a href="https://london.ac.uk/courses/computer-science">Main page of the BSc Computer Science</a><ul>
<li><a href="https://london.ac.uk/computer-science-structure">Structure of the degree</a></li>
</ul>
</li>
<li><a href="https://onlinelibrary.london.ac.uk/">Online library</a></li>
<li><a href="https://my.london.ac.uk/">Portal</a></li>
<li>Specialisms<ul>
<li><a href="https://london.ac.uk/courses/computer-science-data-science">Data Science</a></li>
<li><a href="https://london.ac.uk/courses/computer-science-games">Games Development</a></li>
<li><a href="https://london.ac.uk/courses/computer-science-machine-learning-and-ai">Machine Learning and Artificial Intelligence</a></li>
<li><a href="https://london.ac.uk/courses/bsc-computer-science-physical-computing">Physical Computing and the Internet of things</a></li>
<li><a href="https://london.ac.uk/courses/computer-science-user-experience">User Experience</a></li>
<li><a href="https://london.ac.uk/courses/computer-science-virtual-reality">Virtual Reality</a></li>
<li><a href="https://london.ac.uk/courses/computer-science-web-and-mobile-development">Web and Mobile Development</a></li>
</ul>
</li>
</ul>

  </details>
<br />

## Stay in touch

<details>
<summary><strong>What's happening at Goldsmiths</strong></summary>

<ul>
<li><a href="http://www.doc.gold.ac.uk/blog/">Blog.DoC</a> - <em>&quot;This is the blog for Goldsmiths&#39; Department of Computing. If you are a student, graduate or staff member of Goldsmiths Computing and you want to share news, photos or stories about your work, email our blog editor at: computing@gold.ac.uk&quot;</em></li>
<li><a href="https://www.gold.ac.uk/computing/events/">Computing events, seminars &amp; conferences</a> - <em>&quot;The Computing and Psychology departments&#39; regular seminars encompassing various aspects of cognition, computation and culture. All are welcome to attend.&quot;</em></li>
<li><a href="https://twitter.com/goldcomputing">Goldsmiths Computing (Twitter)</a> - <em>&quot;Creativity, independence and learning by doing. Computing at Goldsmiths, University of London.&quot;</em></li>
<li><a href="https://twitter.com/StudentsAtGold">Goldsmiths, UoL students (Twitter)</a> - <em>&quot;The official account for students at Goldsmiths, University of London. Online Mon-Fri 9-5pm.&quot;</em></li>
<li><a href="https://2020.goldsmiths.tech/">Hacksmiths</a> - <em>&quot;Hacksmiths is the student-run tech society at Goldsmiths. Our mission is to provide an opportunity for people in all departments and from all backgrounds the chance to learn about, and play with, technology.&quot;</em></li>
</ul>

  </details>

<details>
<summary><strong>Contacting UoL</strong></summary>

<ul>
<li><a href="https://london.ac.uk/contact-us">Contact page</a></li>
<li><a href="https://enquiries.londoninternational.ac.uk/login/newuserform.aspx?cctc=UOL&amp;category=UOL">General enquiries</a> (← For non-students. Students should ask in <strong><a href="https://my.london.ac.uk/">the portal</a></strong> instead.)</li>
<li>Reach out by phone: <code>+44 (0)20 7862 8000</code> (general), <code>+44 (0)20 7862 5766</code> (specific to this degree), <code>+44 (0)20 7862 8368</code> (fees office).</li>
<li><a href="https://london.kb.help/">Student Advice Center</a></li>
</ul>

  </details>

<details>
<summary><strong>Contacting other students in this programme</strong></summary>

<ul>
<li>Discord server (choose one of the following, it is the same server): <a href="https://discord.gg/Hyxse35">Invitation link #1</a>, <a href="https://discord.gg/YEt2f7E">Invitation link #2</a></li>
<li><a href="https://londoncs.slack.com/">Slack workspace</a></li>
<li><a href="https://zoom.us/">Zoom</a> (video conferencing used on Coursera)</li>
</ul>
<p>More software options for video conferencing on <a href="/software">this page</a>.</p>

</details>
<br />

## Getting ready: Study and work options

- [Job readiness, other online study options and work opportunities](after_uol).

---

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://github.com/amilos"><img src="https://avatars3.githubusercontent.com/u/4828656?v=4" width="100px;" alt=""/><br /><sub><b>Aleksandar Milosevic</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=amilos" title="Code">💻</a> <a href="https://github.com/world-class/REPL/commits?author=amilos" title="Documentation">📖</a></td>
    <td align="center"><a href="https://ankush.dev"><img src="https://avatars2.githubusercontent.com/u/9079960?v=4" width="100px;" alt=""/><br /><sub><b>Ankush Menat</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=amenat" title="Documentation">📖</a></td>
    <td align="center"><a href="https://writewithwrabit.com"><img src="https://avatars2.githubusercontent.com/u/16005567?v=4" width="100px;" alt=""/><br /><sub><b>Anthony Morris</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=amorriscode" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/arjunmuralidharan"><img src="https://avatars0.githubusercontent.com/u/49580702?v=4" width="100px;" alt=""/><br /><sub><b>Arjun Muralidharan</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=arjunmuralidharan" title="Documentation">📖</a> <a href="#content-arjunmuralidharan" title="Content">🖋</a></td>
    <td align="center"><a href="https://github.com/BlairCurrey"><img src="https://avatars2.githubusercontent.com/u/12960453?v=4" width="100px;" alt=""/><br /><sub><b>Blair Currey</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=BlairCurrey" title="Code">💻</a> <a href="https://github.com/world-class/REPL/commits?author=BlairCurrey" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/ChrisCastelo"><img src="https://avatars0.githubusercontent.com/u/49125861?v=4" width="100px;" alt=""/><br /><sub><b>Chris Castelo</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=ChrisCastelo" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/dannycallaghan"><img src="https://avatars1.githubusercontent.com/u/724781?v=4" width="100px;" alt=""/><br /><sub><b>Danny Callaghan</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=dannycallaghan" title="Documentation">📖</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://damog.net"><img src="https://avatars3.githubusercontent.com/u/1260?v=4" width="100px;" alt=""/><br /><sub><b>David Moreno</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=damog" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/dcabrejas"><img src="https://avatars3.githubusercontent.com/u/8201815?v=4" width="100px;" alt=""/><br /><sub><b>Diego Cabrejas</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=dcabrejas" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/felipebalbi"><img src="https://avatars2.githubusercontent.com/u/45936891?v=4" width="100px;" alt=""/><br /><sub><b>Felipe Balbi</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=felipebalbi" title="Documentation">📖</a> <a href="#content-felipebalbi" title="Content">🖋</a></td>
    <td align="center"><a href="https://github.com/gsej"><img src="https://avatars1.githubusercontent.com/u/7272850?v=4" width="100px;" alt=""/><br /><sub><b>gsej</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=gsej" title="Documentation">📖</a></td>
    <td align="center"><a href="https://xplaind.com"><img src="https://avatars0.githubusercontent.com/u/7108679?v=4" width="100px;" alt=""/><br /><sub><b>Irfanullah Jan</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=irfanullahjan" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/kaemo"><img src="https://avatars2.githubusercontent.com/u/1733602?v=4" width="100px;" alt=""/><br /><sub><b>Kajetan Maurycy Olszewski</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=kaemo" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/zubmic"><img src="https://avatars1.githubusercontent.com/u/49207678?v=4" width="100px;" alt=""/><br /><sub><b>Michał Żuber</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=zubmic" title="Documentation">📖</a></td>
  </tr>
  <tr>
    <td align="center"><a href="http://ryanslevin.com"><img src="https://avatars0.githubusercontent.com/u/41084841?v=4" width="100px;" alt=""/><br /><sub><b>Ryan Slevin</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=ryanslevin" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/eicksl"><img src="https://avatars2.githubusercontent.com/u/29685894?v=4" width="100px;" alt=""/><br /><sub><b>Spencer Eick</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=eicksl" title="Documentation">📖</a></td>
    <td align="center"><a href="https://www.sglavoie.com/"><img src="https://avatars0.githubusercontent.com/u/32682903?v=4" width="100px;" alt=""/><br /><sub><b>Sébastien Lavoie</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=sglavoie" title="Code">💻</a> <a href="https://github.com/world-class/REPL/commits?author=sglavoie" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/Xuan-Lim"><img src="https://avatars0.githubusercontent.com/u/24488417?v=4" width="100px;" alt=""/><br /><sub><b>Xuan Lim</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=Xuan-Lim" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/gstarch"><img src="https://avatars2.githubusercontent.com/u/18475611?v=4" width="100px;" alt=""/><br /><sub><b>Gerhard Lourens</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=gstarch" title="Documentation">📖</a> <a href="https://github.com/world-class/REPL/commits?author=gstarch" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/ykahan"><img src="https://avatars2.githubusercontent.com/u/15960877?v=4" width="100px;" alt=""/><br /><sub><b>Yehoshua Kahan</b></sub></a><br /><a href="https://github.com/world-class/REPL/commits?author=ykahan" title="Documentation">📖</a></td>
  </tr>
</table>

<!-- markdownlint-enable -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!

---

[![ForTheBadge built-with-love](http://ForTheBadge.com/images/badges/built-with-love.svg)](https://github.com/world-class/REPL/)
