[Go back to the main page](../README.md)

# Applying to the University of London Bachelors of Computer Science degree (UoL)

UoL has a [long, esteemed history of
administering reputable distance learning
degrees](https://en.wikipedia.org/wiki/University_of_London_Worldwide),
though information about their new BSc Computer Science is sparse
due to its being new. This documentation seeks to explain the process
behind applying in a concise and clear way so you know exactly what to
expect when you do it yourself.

## Table of Contents

- [Applying to the University of London Bachelors of Computer Science degree (UoL)](#applying-to-the-university-of-london-bachelors-of-computer-science-degree-uol)
  - [Table of Contents](#table-of-contents)
  - [Administrative Information: Admissions Process and Requirements](#administrative-information-admissions-process-and-requirements)
    - [English Requirements for Non-English Speaking Countries](#english-requirements-for-non-english-speaking-countries)
    - [Documents and Statement to Prepare for Application](#documents-and-statement-to-prepare-for-application)
  - [Application Process](#application-process)
  - [Recognition of Prior Learning (RPL) Application](#recognition-of-prior-learning-rpl-application)
  - [Frequently Asked Questions (FAQs)](#frequently-asked-questions-faqs)
  - [Additional Resources](#additional-resources)

## Administrative Information: Admissions Process and Requirements

Students may apply to the programme in two of the following ways:
Direct Admissions (where you are admitted to study as conventionally
expected) and Performance-based Admissions (often used as an
alternative route to getting admitted if you did not meet the academic
requirements). Regardless of which route you would be falling under,
you must meet an equivalent of three requirements for your track:

1. The entry requirements for your track of admissions
2. BSc Comp Sci's specific requirements of Maths at the appropriate level
3. [English Requirements](#english-requirements-for-non-english-speaking-countries)

For Direct Admissions: UoL's General Requirements for entry
must be met — your country's equivalent can be found here:
https://london.ac.uk/entrance-qualifications

For Performance-Based Admissions: your requirements can be found here:
https://www.coursera.org/degrees/bachelor-of-science-computer-science-london/admissions

If you're not sure which track you'll fall under — or whether
or not you will be able to obtain admissions, UoL's general
advice is to apply early and to apply anyway (see [Application
Process](#application-process)).

### English Requirements for Non-English Speaking Countries

Every student, English-speaking country or not must prove their
proficiency in English before applying. This is often proven
by native English speakers by showing that you were educated
in English. For those who were not educated in English, you
must show that you have [proficiency at the standards stated
here](https://london.ac.uk/applications/how-apply/english-requirements#awards-2563).

Students with qualifications not listed have also been accepted. It is
worth applying if you think you have an equivalent qualification not
listed.

### Documents and Statement to Prepare for Application

If you're familiar with the British UCAS system, which students use
after sixth form (12/13th Grade) apply to university, the application
is fairly similar. The only difference being that you're applying to
one university and not five.

In the application you will be asked to supply them with the following
things. It would be highly beneficial to have these prepared
beforehand (especially academic documents) to ensure that your
application decisions come in as quickly and efficiently as possible:

1. A scanned copy of your ID
2. A verified copy of the Academic Documents that back your meeting the requirements for the programme
3. A 100-250 word Personal Statement (of prompt: "Why do you wish to study for this programme?
   Please give your reasons, you should include details about your
   education, work experience and current responsibilities, which are
   relevant to this application.")

It is worth noting that you do not have your certificates verified
before applying. That being said, providing verification can be the
most tedious and time consuming part of the application process.
Getting this done before a high volume applications season can
save you a lot of time and grief waiting for a response. [Here
is some guidance from the university on how you can get this
done.](https://london.ac.uk/applications/how-apply/supplying-evidence)

## Application Process

Upon submission, you will be assigned to an admissions advisor. An
admissions advisor's role is to go through your qualifications to give
you advice on whether or not they can admit you.

Students unsure of whether or not they meet the requirements for
application should apply anyway to see if they can enter the
programme. Likewise, those without verified copies at the time of
application should apply to gain a decision made on their application.
Their acceptance advice is granted when verified documents are sent
through.

The link here documents very clearly the process
on what decisions can be made on your application:
https://london.ac.uk/applicationshow-apply/what-happens-next

A reality keen applicants and prospective students should know: the
admissions office, those in charge of education, or help in general
can be slow. **I would advise everyone interested in applying to apply
as soon as possible.**

## Recognition of Prior Learning (RPL) Application

RPL is the exemption of modules taken if you had taken it before
in a prior diploma or university. It can be seen as a form of
credit transfer. Full regulations can be found in the [course
regulations](https://london.ac.uk/sites/default/files/regulations/progregs-computer-science-2019-2020.pdf). Grades attained from the
programme will not be transferred, however a listing of the grade will
be written on your transcript.

You will have stated your intention to apply for RPL in your
application form, and upon acceptance you will have been given
detailed instructions on how to go about submitting proof for RPL.

There is cost and limitations involved. Currently RPL costs 392 GBP
for all 8 modules, and students are only able to receive RPL for Level
4 or first year modules.

You can get RPL credit in 3 of the following ways:

1. [Automatic RPL: You hold a diploma from the colleges stated/are transferring from one of UoL's on-campus programmes](https://london.ac.uk/applications/how-apply/recognition-prior-learning/recognition-and-accreditation-prior-learning-3)
2. [Discretionary RPL: You have a diploma/incomplete degree not stated but would like the programme director to consider for RPL](https://london.ac.uk/applications/how-apply/recognition-prior-learning/recognition-and-accreditation-prior-learning-3)
3. [Google's IT Diploma: You completed the course and would like the HCW exemption](https://www.coursera.org/professional-certificates/google-it-support)

RPL from a discretionary route will take awhile. Students have
reported the process taking a full month before the process was
complete. It would be wise to apply as soon as possible to avoid
delays with module registration.

## Frequently Asked Questions (FAQs)

**Q:** My application to UoL/for RPL/some other administrative process is taking so long, have they received it/why's it taking so long?

**A:** It takes forever. Sorry mate. That's why an emphasis on applying early was made in the documentation. Applying early not only gives you peace of mind, it means your application doesn't pile up and done when professors aren't stressed out when they read your application.

RPL has taken a month, UoL admissions has taken longer than the 5 days they aim for. Should this happen, do write a nice email to nudge them: ensuring that they have all you need done when they get around to your application.

**Q:** What does my degree look like?

**A:** It looks like [this](https://www.thestudentroom.co.uk/showthread.php?t=2459201).

**Q:** Where would we be graduating?

**A:** [Here, at The Barbican in London](https://www.youtube.com/watch?v=Oja7n2Kq2do)

## Additional Resources

- [UoL Unofficial Students' Discord](https://discord.gg/fugMPVR)
- [UoL Facebook](https://www.facebook.com/LondonU/?ref=br_rs)
- Do keep a look out for UoL's virtual open day if you're curious to learn more and speak to representatives for more information.
