[Go back to the main page](../README.md)

# Books

- [Free Programming Books (GitHub awesome list)](https://ebookfoundation.github.io/free-programming-books/) - _"[...] administered by the Free Ebook Foundation, a not-for-profit organization devoted to promoting the creation, distribution, archiving and sustainability of free ebooks."_

The following list goes beyond the essential/required reading that is part of this degree. The essential reading for each module, if available, can be found by visiting the relevant page in this repository from the [list of modules](../modules/).

# Table of contents

- [Books](#books)
- [Table of contents](#table-of-contents)
  - [Computer Science](#computer-science)
  - [Data Science](#data-science)
    - [Algorithms](#algorithms)
  - [Learning](#learning)
  - [Mathematics](#mathematics)
    - [Calculus](#calculus)
    - [Discrete mathematics](#discrete-mathematics)
    - [Linear algebra](#linear-algebra)
    - [Number theory and algebra](#number-theory-and-algebra)
    - [Statistics](#statistics)
  - [Programming](#programming)
    - [Assembly](#assembly)
    - [Games](#games)
    - [General](#general)
  - [UX/UI design](#uxui-design)

---

## Computer Science

- [How To Think Like A Computer Scientist With Python 3](http://openbookproject.net/thinkcs/python/english3e/), by Elkner, Wentworth, Downey, and Myers - _"An introduction to numerous useful features of a modern programming language and to basic object oriented programming, using Python 3 as the vehicle of choice"_
- [Structure and Interpretation of Computer Programs](https://sarabander.github.io/sicp/html/index.xhtml), by Harold Abelson, Gerald Jay Sussman and Julie Sussman (2<sup>nd</sup> edition) - _"An excellent computer science text used in introductory courses at MIT. So called because of the wizard on the jacket. One of the bibles of the LISP/Scheme world. Also, less commonly, known as the Purple Book."_

## Data Science

- [How To Think Like A Data Scientist](https://runestone.academy/runestone/books/published/httlads/index.html) - _"An introduction to data science in the form of an interactive online book."_

### Algorithms

- [Algorithms to Live by: The Computer Science of Human Decisions](https://algorithmstoliveby.com/) - _"[...] show how algorithms developed for computers also untangle very human questions. They explain how to have better hunches and when to leave things to chance, how to deal with overwhelming choices and how best to connect with others. From finding a spouse to finding a parking spot, from organizing one’s inbox to peering into the future, Algorithms to Live By transforms the wisdom of computer science into strategies for human living."_
- [Grokking Algorithms: An illustrated guide for programmers and other curious people](https://www.manning.com/books/grokking-algorithms) - _"Grokking Algorithms is a fully illustrated, friendly guide that teaches you how to apply common algorithms to the practical problems you face every day as a programmer. You'll start with sorting and searching and, as you build up your skills in thinking algorithmically, you'll tackle more complex concerns such as data compression and artificial intelligence. Each carefully presented example includes helpful diagrams and fully annotated code samples in Python."_
- [Hello World: Being Human in the Age of Algorithms](https://www.goodreads.com/book/show/43726517-hello-world) - _"Hello World is indispensable preparation for the moral quandaries of a world run by code, and with the unfailingly entertaining Hannah Fry as our guide, we’ll be discussing these issues long after the last page is turned."_ (from Goodreads)
- [Problem Solving 101: A Simple Book for Smart People](https://www.goodreads.com/en/book/show/6271219-problem-solving-101) - _"Watanabe uses sample scenarios to illustrate his techniques, which include logic trees and matrixes. A rock band figures out how to drive up concert attendance. An aspiring animator budgets for a new computer purchase. Students decide which high school they will attend. Illustrated with diagrams and quirky drawings, the book is simple enough for a middleschooler to understand but sophisticated enough for business leaders to apply to their most challenging problems."_ (from Goodreads)

## Learning

- [Make It Stick: The Science of Successful Learning](https://www.goodreads.com/book/show/18770267-make-it-stick) - _"To most of us, learning something "the hard way" implies wasted time and effort. Good teaching, we believe, should be creatively tailored to the different learning styles of students and should use strategies that make learning easier. Make It Stick turns fashionable ideas like these on their head. Drawing on recent discoveries in cognitive psychology and other disciplines, the authors offer concrete techniques for becoming more productive learners."_
- [Ultralearning: Master Hard Skills, Outsmart the Competition, and Accelerate Your Career](https://www.goodreads.com/book/show/44770129-ultralearning) - _"Learn a new talent, stay relevant, reinvent yourself, and adapt to whatever the workplace throws your way. Ultralearning offers nine principles to master hard skills quickly. This is the essential guide to future-proof your career and maximize your competitive advantage through self-education."_

## Mathematics

- [Mathematics for Machine Learning](https://mml-book.github.io/) - _"We wrote a book on Mathematics for Machine Learning that motivates people to learn mathematical concepts. The book is not intended to cover advanced machine learning techniques because there are already plenty of books doing this. Instead, we aim to provide the necessary mathematical skills to read those other books."_
- [Nix The Tricks](https://nixthetricks.com/index.html), by Tina Cardone and the online math community known as the MTBoS - _"This book is filled with alternatives to the shortcuts so prevalent in mathematics education and explains exactly why the tricks are so bad for understanding math."_
- [The Beauty of Mathematics in Computer Science](https://www.goodreads.com/book/show/40590852-the-beauty-of-mathematics-in-computer-science) - _"[...] explains the mathematical fundamentals of information technology products and services we use every day, from Google Web Search to GPS Navigation, and from speech recognition to CDMA mobile services."_

### Calculus

- [Calculus 1](https://openstax.org/details/books/calculus-volume-1) - _"Calculus is designed for the typical two- or three-semester general calculus course, incorporating innovative features to enhance student learning. The book guides students through the core concepts of calculus and helps them understand how those concepts apply to their lives and the world around them. Due to the comprehensive nature of the material, we are offering the book in three volumes for flexibility and efficiency. Volume 1 covers functions, limits, derivatives, and integration."_
- [Calculus 2](https://openstax.org/details/books/calculus-volume-2) - _"Calculus is designed for the typical two- or three-semester general calculus course, incorporating innovative features to enhance student learning. The book guides students through the core concepts of calculus and helps them understand how those concepts apply to their lives and the world around them. Due to the comprehensive nature of the material, we are offering the book in three volumes for flexibility and efficiency. Volume 2 covers integration, differential equations, sequences and series, and parametric equations and polar coordinates."_
- [Calculus 3](https://openstax.org/details/books/calculus-volume-3) - _"Calculus is designed for the typical two- or three-semester general calculus course, incorporating innovative features to enhance student learning. The book guides students through the core concepts of calculus and helps them understand how those concepts apply to their lives and the world around them. Due to the comprehensive nature of the material, we are offering the book in three volumes for flexibility and efficiency. Volume 3 covers parametric equations and polar coordinates, vectors, functions of several variables, multiple integration, and second-order differential equations."_
- [Calculus Made Easy](https://www.gutenberg.org/files/33283/33283-pdf.pdf), by Silvanus Thompson - _"Being a very-simplest introduction to those beautiful methods which are generally called by the terrifying names of the Differentia."_

### Discrete mathematics

- [Discrete Mathematics - An Open Introduction](http://discrete.openmathbooks.org/dmoi3.html), by Oscar Levin - _"Discrete Mathematics: An Open Introduction is a free, open source textbook appropriate for a first or second year undergraduate course for math majors, especially those who will go on to teach."_
- [How to Solve It - A New Aspect of Mathematical Method](https://lms.umb.sk/pluginfile.php/37176/mod_folder/content/0/Polya_How-to-solve-it.pdf), by G. Polya (PDF file)

### Linear algebra

- [Linear Algebra Done Right](http://linear.axler.net/LinearAbridged.pdf), by Sheldon Axler - _"The text focuses on the central goal of linear algebra: understanding the structure of linear operators on finite-dimensional vector spaces."_

### Number theory and algebra

- [A Computational Introduction to Number Theory and Algebra](https://shoup.net/ntb/ntb-v2.pdf), by Victor Shoup - _" My goal in writing this bookwas to provide an introduction to number theory and algebra, with an emphasis on algorithms and applications, that would be accessible to a broad audience. In particular, I wanted to write a book that would be appropriate for typical students in computer science or mathematics who have some amount of general mathematical experience, but without presuming too much specific mathematical knowledge."_

### Statistics

- [Introductory Business Statistics](https://openstax.org/details/books/introductory-business-statistics) - _"Introductory Business Statistics is designed to meet the scope and sequence requirements of the one-semester statistics course for business, economics, and related majors. Core statistical concepts and skills have been augmented with practical business examples, scenarios, and exercises. The result is a meaningful understanding of the discipline, which will serve students in their business careers and real-world experiences."_

## Programming

### Assembly

- [Assembly Language for x86 Processors, Global Edition](http://catalogue.pearsoned.co.uk/catalog/academic/product?ISBN=9781292061214) - _"Assembly Language for x86 Processors, 7e is suitable for undergraduate courses in assembly language programming and introductory courses in computer systems and computer architecture. Proficiency in one other programming language, preferably Java, C, or C++, is recommended."_

### Games

- [Game Engine Black Books](http://fabiensanglard.net/gebb/index.html) - _"It is a very deep insight on how id software developed the game engine that run Wolfenstein 3D and it is complete with code fragments with very detailed descriptions, down to the VGA programming and the assembly code that draws the screen during the game. Mindblowing!"_ (from David Della Rossa, student in this degree)

### General

- [Awesome Programming Books](https://github.com/majikarp/awesome-programming-books) - _"A curated list of awesome programming books."_

## UX/UI design

- [Actionable Gamification](https://yukaichou.com/gamification-book/) - _"Gamification Pioneer Yu-kai Chou takes readers on a journey to learn his sixteen years of obsessive research in creating the Octalysis Framework, and how to apply the framework to create engaging and successful experiences in their product, workplace, marketing, and personal lives."_ (from [Amazon](https://www.amazon.com/Actionable-Gamification-Beyond-Points-Leaderboards/dp/1511744049/))
