[Go back to the main page](../README.md)

# Frequently Asked Questions

## Table of contents

- [Frequently Asked Questions](#frequently-asked-questions)
  - [Table of contents](#table-of-contents)
  - [General topics](#general-topics)
    - [I need help! Whom should I ask?](#i-need-help-whom-should-i-ask)
      - [Module-specific inquiries](#module-specific-inquiries)
      - [Non-academic questions](#non-academic-questions)
      - [Private matters and other types of academic inquiries](#private-matters-and-other-types-of-academic-inquiries)
      - [Technical issues on Coursera](#technical-issues-on-coursera)
      - [Small queries regarding a module](#small-queries-regarding-a-module)
    - [Is there a simple repository of all knowledge generated regarding this program?](#is-there-a-simple-repository-of-all-knowledge-generated-regarding-this-program)
    - [How to access the library?](#how-to-access-the-library)
    - [When can we expect our ISIC cards?](#when-can-we-expect-our-isic-cards)
    - [What kind of materials will university deliver to us?](#what-kind-of-materials-will-university-deliver-to-us)
    - [Do we get a dedicated student advisor, as it is customary in other countries (for example the US)?](#do-we-get-a-dedicated-student-advisor-as-it-is-customary-in-other-countries-for-example-the-us)
    - [If we produce something during our studies, who "owns" it?](#if-we-produce-something-during-our-studies-who-owns-it)
    - [Are there opportunities for students to gain some form of work experience in the industry or even undergo internships during the course?](#are-there-opportunities-for-students-to-gain-some-form-of-work-experience-in-the-industry-or-even-undergo-internships-during-the-course)
    - [I feel I need to vent, where can I go?](#i-feel-i-need-to-vent-where-can-i-go)
  - [Recognition of Prior Learning (RPL)](#recognition-of-prior-learning-rpl)
    - [Is RPL time limited?](#is-rpl-time-limited)
    - [What can be accepted as RPL?](#what-can-be-accepted-as-rpl)
    - [Can we still apply RPL for Google IT Support course anytime during this semester or next?](#can-we-still-apply-rpl-for-google-it-support-course-anytime-during-this-semester-or-next)
    - [Does a possible RPL only get considered if it is from another university, or could the content (syllabus) of other certifications be looked at for possible matching/consideration?](#does-a-possible-rpl-only-get-considered-if-it-is-from-another-university-or-could-the-content-syllabus-of-other-certifications-be-looked-at-for-possible-matchingconsideration)
  - [Performance-Based Admission](#performance-based-admission)
    - [For performance-based admission, can I take more than two module this session?](#for-performance-based-admission-can-i-take-more-than-two-module-this-session)
  - [Modules & Progression](#modules--progression)
    - [Can a student switch pathways as the course goes on?](#can-a-student-switch-pathways-as-the-course-goes-on)
    - [How can I drop/withdraw from module?](#how-can-i-dropwithdraw-from-module)
    - [What is the maximum number of modules that one can select per semester?](#what-is-the-maximum-number-of-modules-that-one-can-select-per-semester)
    - [Where can I see a syllabus of all available modules?](#where-can-i-see-a-syllabus-of-all-available-modules)
    - [How can I progress to level 5 modules?](#how-can-i-progress-to-level-5-modules)
    - [Which math topics should I review before taking Numerical Math as to feel comfortable during the course?](#which-math-topics-should-i-review-before-taking-numerical-math-as-to-feel-comfortable-during-the-course)
    - [Can I at some point in the future switch to on campus and continue my degree?](#can-i-at-some-point-in-the-future-switch-to-on-campus-and-continue-my-degree)
    - [Would on-campus be at the usual UK tuition fee rate?](#would-on-campus-be-at-the-usual-uk-tuition-fee-rate)
    - [Can we register 3 modules + project in last semester?](#can-we-register-3-modules--project-in-last-semester)
    - [Do you recommend taking four modules at a time if they are available?](#do-you-recommend-taking-four-modules-at-a-time-if-they-are-available)
    - [Can a BSc CS student take more than 22 modules (excluding the final project)?](#can-a-bsc-cs-student-take-more-than-22-modules-excluding-the-final-project)
  - [Programme Regulations](#programme-regulations)
    - [How much do I need to pass module X?](#how-much-do-i-need-to-pass-module-x)
    - [I am taking module X, what type is it? Does it have a written exam?](#i-am-taking-module-x-what-type-is-it-does-it-have-a-written-exam)
    - [What do we learn in module X? Do we ever study X?](#what-do-we-learn-in-module-x-do-we-ever-study-x)
    - [What are the registration and progression rules?](#what-are-the-registration-and-progression-rules)
    - [I am a PBA (Performance-Based Admission) student, what does that mean?](#i-am-a-pba-performance-based-admission-student-what-does-that-mean)
    - [What is RPL?](#what-is-rpl)
    - [What specializations are available?](#what-specializations-are-available)
    - [What happens when I defer an assessment?](#what-happens-when-i-defer-an-assessment)
  - [Important Dates, Deadlines & Events](#important-dates-deadlines--events)
    - [When are the exams/When does the semester start/What is the registration deadline?](#when-are-the-examswhen-does-the-semester-startwhat-is-the-registration-deadline)
    - [What week are we on?](#what-week-are-we-on)
    - [How do I setup calendar sync on Coursera?](#how-do-i-setup-calendar-sync-on-coursera)
    - [I don't want to miss important announcements, what to do?](#i-dont-want-to-miss-important-announcements-what-to-do)
  - [Exams](#exams)
    - [Will you be expanding test centers? The closest one to me is rather far away.](#will-you-be-expanding-test-centers-the-closest-one-to-me-is-rather-far-away)
    - [If we sit the exam outside the UK, in a local examination centre, then it is done via British council, isn't it?](#if-we-sit-the-exam-outside-the-uk-in-a-local-examination-centre-then-it-is-done-via-british-council-isnt-it)
    - [How many exams will be there per semester for a module?](#how-many-exams-will-be-there-per-semester-for-a-module)
    - [Do online learners need to take assessments at specific locations? If so is this only final assessments?](#do-online-learners-need-to-take-assessments-at-specific-locations-if-so-is-this-only-final-assessments)
    - [Can you please describe a written examination for Numerical Math or Discreet Math? Is it usually a test or teachers check hand written answers?](#can-you-please-describe-a-written-examination-for-numerical-math-or-discreet-math-is-it-usually-a-test-or-teachers-check-hand-written-answers)
    - [Have you considered using ProctorU as a distributed exam solution? It seems to have a fair amount of adoption among MOOC providers](#have-you-considered-using-proctoru-as-a-distributed-exam-solution-it-seems-to-have-a-fair-amount-of-adoption-among-mooc-providers)
  - [Technical questions](#technical-questions)
    - [Which are the programming languages we will come across through the course?](#which-are-the-programming-languages-we-will-come-across-through-the-course)
    - [Will C# be taught in level 6, especially in VR module?](#will-c-be-taught-in-level-6-especially-in-vr-module)
    - [Which programming language is used in learning Graphics programming?](#which-programming-language-is-used-in-learning-graphics-programming)
    - [Do we get a choice of back/front end frameworks to use during the web modules?](#do-we-get-a-choice-of-backfront-end-frameworks-to-use-during-the-web-modules)
    - [Will Data Science field use Python?](#will-data-science-field-use-python)
    - [There are a lot of technologies involved in data science. Can you run through some of the ones that will be covered?](#there-are-a-lot-of-technologies-involved-in-data-science-can-you-run-through-some-of-the-ones-that-will-be-covered)
    - [Have the Level 6 Modules been produced and tested?](#have-the-level-6-modules-been-produced-and-tested)
    - [Have Level 5 and 6 Modules been quality assured?](#have-level-5-and-6-modules-been-quality-assured)
    - [If you're restructuring the program to adhere to accreditation standards, will that disrupt the current modules or impending modules?](#if-youre-restructuring-the-program-to-adhere-to-accreditation-standards-will-that-disrupt-the-current-modules-or-impending-modules)
  - [Grades & Results](#grades--results)
    - [My peer-reviewed work isn't graded yet, what can I do?](#my-peer-reviewed-work-isnt-graded-yet-what-can-i-do)
    - [How do you assign grades? Grading on a Curve or absolute grading?](#how-do-you-assign-grades-grading-on-a-curve-or-absolute-grading)
  - [Graduation & Beyond](#graduation--beyond)
    - [How is this degree going to tie in or transfer over to the new MSc Data Science from UoL and the soon to come MSc Machine Learning on Coursera?](#how-is-this-degree-going-to-tie-in-or-transfer-over-to-the-new-msc-data-science-from-uol-and-the-soon-to-come-msc-machine-learning-on-coursera)
    - [Is there no honours in the UK? Do we qualify for a masters straight after Bsc?](#is-there-no-honours-in-the-uk-do-we-qualify-for-a-masters-straight-after-bsc)
    - [Will there be difference in the diploma if we finish the degree online and on campus?](#will-there-be-difference-in-the-diploma-if-we-finish-the-degree-online-and-on-campus)
    - [Do usually students come to London to get their diplomas once they have graduated from UoL or are they being posted to graduates?](#do-usually-students-come-to-london-to-get-their-diplomas-once-they-have-graduated-from-uol-or-are-they-being-posted-to-graduates)
  - [Slack Community](#slack-community)
    - [What are the basics on how to use Slack?](#what-are-the-basics-on-how-to-use-slack)
    - [How do I reply to a specific user using threads?](#how-do-i-reply-to-a-specific-user-using-threads)
    - [I want to discuss off-topic things with other students, where should I go?](#i-want-to-discuss-off-topic-things-with-other-students-where-should-i-go)
  - [Off-topic](#off-topic)
    - [Where's the best place to read about Dr. Yee-King's research with computer music?](#wheres-the-best-place-to-read-about-dr-yee-kings-research-with-computer-music)

---

## General topics

### I need help! Whom should I ask?

#### Module-specific inquiries

- You can reach out to your tutors in the appropriate discussion forums on Coursera. Access any module you are enrolled in from the home page of this degree on Coursera.

#### Non-academic questions

- You can write in the **Reach out** forum on Coursera (in the **orientation module**).

#### Private matters and other types of academic inquiries

- You can write an email to Student Relationship Mangers (SRMs) BScCS-Support@london.ac.uk

#### Technical issues on Coursera

- If you think you're having technical problems with Coursera, create a ticket at: [https://learner.coursera.help/hc/en-us](https://learner.coursera.help/hc/en-us)

#### Small queries regarding a module

- You can also ask in module specific Slack channel. Be sure to thank the person who helps you :smile:

### Is there a simple repository of all knowledge generated regarding this program?

- Yes — [https://github.com/world-class/repl](https://github.com/world-class/repl)

### How to access the library?

- [https://www.coursera.org/learn/london-cs-orientation/supplement/Umu9M/student-resources](https://www.coursera.org/learn/london-cs-orientation/supplement/Umu9M/student-resources)

### When can we expect our ISIC cards?

- The email will come from <information@myisic.com>, so make sure you add this address to your email account so that it doesn’t go to your spam folder. If you do not receive an email, or you have any issues with your ISIC card, contact <virtual@myisic.com>. You can also log an enquiry in the ‘Ask a Question’ link in your student portal, in order for us to look into this further for you if necessary.

### What kind of materials will university deliver to us?

- When you register, we will give you access to your Student Portal. You can then access your
  University of London email account and two other key resources:

  - The Virtual Learning Environment (VLE). Here, you can access electronic copies of all printed study
    materials, resources including audio-visual, and forums to discuss course material and work
    collaboratively with others.
  - Access to academic support and feedback from London-based support teams. Tutors introduce the
    modules, respond to queries, monitor discussions and provide guidance on assessments. There will be
    interactive and engaging study materials including videos, quizzes and online games, so you can feel
    confident about your progress.

### Do we get a dedicated student advisor, as it is customary in other countries (for example the US)?

- As a student of the University of London you will have access to academic support and feedback from London-based support teams. Your online tutor will introduce the modules, respond to academic queries, and provide guidance on assessments through the Online Tutor Forum. Your Student Relationship Managers are available to assist you with non-academic and administrative queries via the Reach Out Forum in the Orientation Module, and via the support email <BscCs-support@london.ac.uk>.

### If we produce something during our studies, who "owns" it?

> In one UoL's correspondence it said that we would need to reach out to our professor if we wanted to monetize it. How would we go about that for this degree being online?

The section of the University’s Intellectual Property Rights Policy that specifically addresses your question is Part E. Please see [https://london.ac.uk/sites/default/files/governance/intellectualpropertypolicy.pdf](https://london.ac.uk/sites/default/files/governance/intellectualpropertypolicy.pdf).

If you have any specific queries about something you have created which you are interested in publishing, please contact us via the support email <BscCs-support@london.ac.uk> and we can look into this further for you.

### Are there opportunities for students to gain some form of work experience in the industry or even undergo internships during the course?

- I am afraid that this would not be provided by the University of London, however, we would not discourage students attempting to seek work experience on their own accord.

### I feel I need to vent, where can I go?

- [https://my.london.ac.uk/group/student/talkcampus](https://my.london.ac.uk/group/student/talkcampus)
- Visit the [#vent](https://londoncs.slack.com/archives/CJG51H2CS) channel on Slack.

---

## Recognition of Prior Learning (RPL)

### Is RPL time limited?

> For example, if I've taken an equivalent course at Uni 10 years back, is that still qualified?

- Please note that the general regulations state the following regarding RPL: Your prior learning may
  count towards a University of London qualification provided that:

  a) the academic/professional requirements for the previous study can be verified by us;

  b) the range, quality and currency of the previous study and/or of a previous qualification, and its coherence with the studies to be undertaken, is confirmed as appropriate;

  c) **your prior learning was completed within the past five years, unless Programme Regulations indicate otherwise**.

### What can be accepted as RPL?

- If you are registered on a full BSc programme, you may apply for recognition of prior learning for up to 120 credits at Level 4. We consider applications for recognition of prior learning (RPL) on the basis of studies successfully completed at an appropriate level. Further information regarding automatic and discretionary RPL for BSc Computer Science can be found on the website here: [https://london.ac.uk/applications/how-apply/recognition-prior-learning/recognition-and-accreditation-prior-learning-3](https://london.ac.uk/applications/how-apply/recognition-prior-learning/recognition-and-accreditation-prior-learning-3).

### Can we still apply RPL for Google IT Support course anytime during this semester or next?

- Please be advised that it is recognized by the University of London as prior learning, giving students exemption from the module How Computers Work at level 4. The deadline to register for RPL for the October 2019 session was 26 August 2019. If you wish to apply for RPL for the April 2020 session, you will be able to do so from 16 December 2019.

### Does a possible RPL only get considered if it is from another university, or could the content (syllabus) of other certifications be looked at for possible matching/consideration?

- For credit to be awarded for your prior learning, you must have completed a syllabus of similar level and depth as part of a previous qualification, normally within the previous five years.
- You need to apply for any prior learning to be recognized and accredited. You can do this on the relevant section of the online application form.
- If you have already submitted your application but now wish to request recognition of your prior learning, please contact us.

---

## Performance-Based Admission

### For performance-based admission, can I take more than two module this session?

- If you are entering any of the programmes via the Performance Based Admissions route, you are permitted to register for two modules only; Introduction to Programming I and either Numerical or Discrete Mathematics, depending on module availability.

---

## Modules & Progression

### Can a student switch pathways as the course goes on?

- You may apply to transfer between BSc Computer Science specialist pathways offered under these regulations provided that

  1. you have selected, or are still able to select, the core modules on the degree to which you wish to transfer;
  2. you are still within your maximum period of registration;
  3. you have not failed at the final attempt, a module that is core on the degree to which you wish to transfer;
  4. you have not passed more than one Level 6 module which does not fit on the degree to which you wish to transfer;
  5. you are not yet eligible for the BSc award upon which you are currently registered. For further information please see the [programme regulations](https://london.ac.uk/sites/default/files/regulations/progregs-computer-science-2019-2020.pdf).

### How can I drop/withdraw from module?

- You will have 14 days from the beginning of your course (the day your modules become available on the platform) to withdraw a module or transfer it to a later study session. After 14 days, any fees paid to the University will not be refunded unless there are mitigating circumstances which we will consider on submission of the relevant evidence. Please see [terms and conditions](https://london.ac.uk/applicationshow-apply/terms-and-conditions) for further information.

### What is the maximum number of modules that one can select per semester?

- The maximum number of modules you can register for in any one session is five (or three plus the final project). This can be a combination of new modules and resits (with a maximum of four new modules), or resits only.
- For further information please see the [programme regulations](https://london.ac.uk/sites/default/files/regulations/progregs-computer-science-2019-2020.pdf).

### Where can I see a syllabus of all available modules?

- [https://www.coursera.org/learn/london-cs-orientation/supplement/YUBNS/syllabus-introduction-to-programming-1-cm1005](https://www.coursera.org/learn/london-cs-orientation/supplement/YUBNS/syllabus-introduction-to-programming-1-cm1005)

### How can I progress to level 5 modules?

- To progress to Level 5 modules, you must have:
  - completed at least 45 credits at Level 4, including Introduction to Programming I and either Discrete or Numerical Mathematics
  - made an attempt at a further 45 credits at Level 4, including both Introduction to Programming II and the remaining Level 4 maths module
  - registered for any Level 4 modules not yet attempted alongside your Level 5 modules.

### Which math topics should I review before taking Numerical Math as to feel comfortable during the course?

- I would recommend reviewing a UK A-Level Maths textbook.

### Can I at some point in the future switch to on campus and continue my degree?

- Goldsmiths welcomes applications from students who wish to transfer to an on-campus degree. To complete your degree in two years of full-time study at Goldsmiths, you must have completed eight Level 4 modules successfully. To complete your degree in one year of full-time study at Goldsmiths, you must also have completed eight modules at Level 5.

- If you are interested in transferring to Goldsmiths and have successfully completed the required courses (or expect to do so in your intended year of transfer), please contact the Computing Team.

### Would on-campus be at the usual UK tuition fee rate?

- We would advise contacting Goldsmiths directly about this. Please see the below email address -
  <intcomp@gold.ac.uk>.

### Can we register 3 modules + project in last semester?

- You are only able to study for a maximum of 60 credits per session, so this would not be possible. You would need to study for two modules and the final project.

### Do you recommend taking four modules at a time if they are available?

- Unfortunately, it is not for us to recommend, as it very much depends on your current circumstances. It is important to think about how much time you can give to your studies, as you should allow 6-10 study hours per week for a module.

### Can a BSc CS student take more than 22 modules (excluding the final project)?

> I'm currently taking an Internet of Things specialism, but I may probably take an interest in Games Development in the future.

- If you want to study additional modules via a separate institution or platform, this is up to you. However, we would urge you to consider the time commitment of studying these additional modules.
- You will study over 22 weeks which means you should allow 6-10 study hours per week for a module.

---

## Programme Regulations

This section is dedicated to all the general questions that are answered well in the program regulations. Please read [the program regulations](https://london.ac.uk/sites/default/files/regulations/progregs-computer-science-2019-2020.pdf). :book:

### How much do I need to pass module X?

- See section 4.3.

### I am taking module X, what type is it? Does it have a written exam?

- See Appendix B.

### What do we learn in module X? Do we ever study X?

- See Appendix B.

### What are the registration and progression rules?

- See Section 5.6 — 5.7.

### I am a PBA (Performance-Based Admission) student, what does that mean?

- See Section 5.1 — 5.5.

### What is RPL?

- Recognition of Prior Learning. See Section 3.

### What specializations are available?

- See Appendix A.

### What happens when I defer an assessment?

- See Section 4.32 — 4.37.

---

## Important Dates, Deadlines & Events

### When are the exams/When does the semester start/What is the registration deadline?

- Tentative important dates: [https://www.coursera.org/learn/london-cs-orientation/supplement/8w7so/important-dates](https://www.coursera.org/learn/london-cs-orientation/supplement/8w7so/important-dates)

### What week are we on?

- Check the topic of [#general](https://londoncs.slack.com/archives/CDTPC3FKL) on Slack. It's kept updated for this purpose only.

### How do I setup calendar sync on Coursera?

- [https://www.coursera.org/learn/london-cs-orientation/supplement/xNQ2h/calendar-sync-and-time-zones](https://www.coursera.org/learn/london-cs-orientation/supplement/xNQ2h/calendar-sync-and-time-zones)

### I don't want to miss important announcements, what to do?

- Make sure you have a filter in your email for UoL emails. Also subscribe to [#official-communications](https://londoncs.slack.com/archives/CM4KKHUCB) on Slack.

---

## Exams

### Will you be expanding test centers? The closest one to me is rather far away.

- There are no plans to expand test centres at present. Please see [this link](https://london.ac.uk/current-students/examinations/examination-centres) for a list of over 500 approved exam centres.

### If we sit the exam outside the UK, in a local examination centre, then it is done via British council, isn't it?

> I wonder whether you collaborate with local experts (IT professors) or there are only British Council representatives who collect the papers and send them for evaluation to London?

- You will sit your exams at one of over 500 approved centres around the world (including local Ministries of Education or the British Council). These centres are separate from local teaching institutions and they charge a fee for hosting the exam. These papers are then gathered and returned to London for marking. For further information about exams, please see [https://london.ac.uk/current-students/examinations](https://london.ac.uk/current-students/examinations).

### How many exams will be there per semester for a module?

- Please be advised that this will depend on how many modules you register for and will be determined by the assessment requirements for those modules.

### Do online learners need to take assessments at specific locations? If so is this only final assessments?

- The University has 400 approved examination centres worldwide, so you don't need to travel to London to sit your exams. These centres charge a fee for hosting the exam. The fees are set by the exam centre so may vary by country and venue.
- Therefore, I would recommend that you check the fees with the exam centre directly. Please see the following link which provides a full list of available examination centres and their contact details: [http://bit.ly/2At85Fu](http://bit.ly/2At85Fu).

### Can you please describe a written examination for Numerical Math or Discreet Math? Is it usually a test or teachers check hand written answers?

- Students are required to sit for a written examination at a local examination centre. It will then go through a rigorous marking process before students receive their marks.

### Have you considered using ProctorU as a distributed exam solution? It seems to have a fair amount of adoption among MOOC providers

- There is a project at UoL which is looking into exam proctoring. I believe they are considering ProctorU.

---

## Technical questions

### Which are the programming languages we will come across through the course?

- JavaScript, C++, Python, C#.

### Will C# be taught in level 6, especially in VR module?

- Yes. We use Unity, which uses C#.

### Which programming language is used in learning Graphics programming?

- JavaScript.

### Do we get a choice of back/front end frameworks to use during the web modules?

- No.

### Will Data Science field use Python?

- Yes.

### There are a lot of technologies involved in data science. Can you run through some of the ones that will be covered?

- Python, numpy, scipy pandas, Jupyter notebooks, TensorFlow, data visualization tools.

### Have the Level 6 Modules been produced and tested?

- One commenced production earlier this year. Others begin in October 2019, two more phases start in April and October 2020.

### Have Level 5 and 6 Modules been quality assured?

- The design of the whole programme has been through a QAA process to ensure it aligns with the UK HE benchmark for computing.

### If you're restructuring the program to adhere to accreditation standards, will that disrupt the current modules or impending modules?

- We are not presently planning to restructure the programme.

---

## Grades & Results

### My peer-reviewed work isn't graded yet, what can I do?

- Ask in the Slack channel [#reviewexchange](https://londoncs.slack.com/archives/CJXHM0RTQ).

### How do you assign grades? Grading on a Curve or absolute grading?

- Information about the grading policy can be found within the BSc Computer Science Orientation Course. Please see the below - [https://www.coursera.org/learn/london-cs-orientation/supplement/rZzTr/grading-policy](https://www.coursera.org/learn/london-cs-orientation/supplement/rZzTr/grading-policy).

---

## Graduation & Beyond

### How is this degree going to tie in or transfer over to the new MSc Data Science from UoL and the soon to come MSc Machine Learning on Coursera?

> The ability to be able pursue Grad School is huge for me. And you probably know for Graduate School, students are required to provide Letters of Reference for their Application. Will the Online Tutors be the ones providing the letter since there is no interaction with the faculty at Goldsmiths?

- In regards to references, our Transcripts Office would be able to provide you with a general reference. You can also apply for a Letter of Certification from our Transcripts Office. Our Transcripts Office can provide an official letter of certification, which will confirm an award. You can contact us via the support email <bsccs-support@london.ac.uk> if you wish to request such a letter.

### Is there no honours in the UK? Do we qualify for a masters straight after Bsc?

- Yes, to be considered for the award of the BSc degree with honours you are required to have passed modules to the value of 360 credits. If you are interested in postgraduate study, you would need to contact the institution that you intend to study at, as entrance requirements vary from institution to institution.

### Will there be difference in the diploma if we finish the degree online and on campus?

- Your degree will be of exactly the same standard as a University of London degree awarded to an on-campus student by a Member Institution.

### Do usually students come to London to get their diplomas once they have graduated from UoL or are they being posted to graduates?

- When you graduate from the University of London, you receive two important documents: your Final Diploma; and, in most cases, a Diploma Supplement. Students will receive their diploma and transcript via post. When you complete your degree, you have the option of joining students from around the world at our graduation ceremony in London, which is held in March each year. For further information about your diploma please see: [https://london.ac.uk/applicationshow-it-works/your-certificate](https://london.ac.uk/applicationshow-it-works/your-certificate)

---

## Slack Community

### What are the basics on how to use Slack?

- [Available shortcuts](https://get.slack.help/hc/en-us/articles/201374536-Slack-keyboard-shortcuts)
- [How to format your messages](https://get.slack.help/hc/en-us/articles/202288908-Format-your-messages)
- [How to share snippets of code](https://slack.com/slack-tips/share-code-snippets) (JavaScript, HTML, CSS, Python, C++, etc.)
- [How to use pinned items](https://slack.com/intl/en-mx/help/articles/205239997-Pin-messages) (important info in each channel)
- [How to search effectively](https://slack.com/intl/en-mx/help/articles/202528808-Search-in-Slack) (filtering by channel, user, date, file types, etc.)
- [How to find channels](https://slackhq.com/introducing-channel-search-for-slack)
- [Slack help center](https://get.slack.help/hc/en-us) for anything else

### How do I reply to a specific user using threads?

- It's very important to use threads while communicating to keep chats organized. — [https://slack.com/intl/en-in/help/articles/115000769927-Use-threads-to-organise-discussions-](https://slack.com/intl/en-in/help/articles/115000769927-Use-threads-to-organise-discussions-)

### I want to discuss off-topic things with other students, where should I go?

- A list of Slack channels [can be found here](../slack/README.md).

---

## Off-topic

### Where's the best place to read about Dr. Yee-King's research with computer music?

- On my website: [http://www.yeeking.net](http://www.yeeking.net)
- And on my GS profile: [https://goldsmiths.academia.edu/MatthewYeeKing](https://goldsmiths.academia.edu/MatthewYeeKing)
