[Go back to the main page](https://github.com/world-class/REPL)

# Table of contents

- [Numerical Mathematics - Reported problems](#numerical-mathematics---reported-problems)
  - [Week 1](#week-1)
    - [Video: 1.001 Introduction to number bases and modular arithmetic](#video-1001-introduction-to-number-bases-and-modular-arithmetic)
    - [Video: 1.101 Introduction to number bases](#video-1101-introduction-to-number-bases)
    - [Video: 1.107 Place value for fractional numbers: binary](#video-1107-place-value-for-fractional-numbers-binary)
    - [Practice quiz: 1.110 Rational and irrational numbers: decimal and binary](#practice-quiz-1110-rational-and-irrational-numbers-decimal-and-binary)
  - [Week 2](#week-2)
    - [Video: 1.401 Octal and hexadecimal (integer)](#video-1401-octal-and-hexadecimal-integer)
    - [Practice quiz: 1.404 Translate between decimal and hexadecimal or octal (fractional)](#practice-quiz-1404-translate-between-decimal-and-hexadecimal-or-octal-fractional)
    - [FIXED - Video: 1.405 Special relationship between binary and hexadecimal, and binary and octal](#fixed---video-1405-special-relationship-between-binary-and-hexadecimal-and-binary-and-octal)
    - [Practice quiz: 1.406 Translate between binary and hexadecimal/octal](#practice-quiz-1406-translate-between-binary-and-hexadecimaloctal)
    - [Practice quiz: 1.602 Arithmetic in hexadecimal/octal](#practice-quiz-1602-arithmetic-in-hexadecimaloctal)
  - [Week 3](#week-3)
    - [Lesson 1.10](#lesson-110)
      - [Video: 1.1004 Multiplicative identity, inverse mod k, exponentiation mod k](#video-11004-multiplicative-identity-inverse-mod-k-exponentiation-mod-k)
      - [Video 1.1006 Mod, rem and division](#video-11006-mod-rem-and-division)
    - [Lesson 1.11](#lesson-111)
      - [Video 1.1101 Encryption using modular arithmetic](#video-11101-encryption-using-modular-arithmetic)
  - [Week 4](#week-4)
    - [Lesson 2.1: Video 2.103 Defining sequences](#lesson-21-video-2103-defining-sequences)
    - [Lesson 2.2: Video 2.201 Arithmetic progressions](#lesson-22-video-2201-arithmetic-progressions)
  - [Week 5](#week-5)
    - [Lesson 2.5](#lesson-25)
      - [Video 2.502 Series: sums of terms of sequences; summation symbol: sigma notation](#video-2502-series-sums-of-terms-of-sequences-summation-symbol-sigma-notation)
      - [Video 2.509 Finite sums](#video-2509-finite-sums)
    - [Lesson 2.6](#lesson-26)
      - [Practice quiz: 2.602 Limits of sequences](#practice-quiz-2602-limits-of-sequences)
      - [Video 2.604 Patterns in series; limit; convergent and divergent series](#video-2604-patterns-in-series-limit-convergent-and-divergent-series)
      - [FIXED - Practice quiz 2.608 Criteria for identifying convergent/divergent sequences and series](#fixed---practice-quiz-2608-criteria-for-identifying-convergentdivergent-sequences-and-series)
    - [Summative quiz](#summative-quiz)
  - [Week 6](#week-6)
    - [Lesson 3.1](#lesson-31)
      - [Video 3.101 Cartesian coordinates](#video-3101-cartesian-coordinates)
    - [Lesson 3.2](#lesson-32)
      - [Video 3.204 Functions and tables of values](#video-3204-functions-and-tables-of-values)
      - [Video 3.207 Plotting graphs by hand – straight lines](#video-3207-plotting-graphs-by-hand--straight-lines)
      - [Video 3.211 Plotting graphs by hand – reciprocal](#video-3211-plotting-graphs-by-hand--reciprocal)
    - [Lesson 3.4](#lesson-34)
      - [Video 3.401 Kinematic equations](#video-3401-kinematic-equations)
    - [Summative quiz](#summative-quiz-1)
  - [Week 7](#week-7)
    - [Lesson 4.1](#lesson-41)
      - [Video 4.101 Introduction to angles and triangles](#video-4101-introduction-to-angles-and-triangles)
    - [Lesson 4.2](#lesson-42)
      - [Practice quiz 4.204 Trigonometric ratios in the right-angled triangle](#practice-quiz-4204-trigonometric-ratios-in-the-right-angled-triangle)
      - [Video 4.206 Trigonometric ratios in the right-angled triangle: Part 2](#video-4206-trigonometric-ratios-in-the-right-angled-triangle-part-2)
  - [Week 8](#week-8)
    - [Summative quiz](#summative-quiz-2)
  - [Week 10](#week-10)
    - [Lesson 5.3](#lesson-53)
      - [Practice quiz 5.307 Solving trigonometric equations](#practice-quiz-5307-solving-trigonometric-equations)
    - [Lesson 5.4](#lesson-54)
      - [Summative quiz 5.402 Trigonometric functions](#summative-quiz-5402-trigonometric-functions)
  - [Week 12](#week-12)
    - [Lesson 6.2](#lesson-62)
      - [Video 6.207 Logarithmic equations](#video-6207-logarithmic-equations)
  - [Week 13](#week-13)
    - [Lesson 7.2](#lesson-72)
      - [Practice quiz 7.202 Differentiation from first principles](#practice-quiz-7202-differentiation-from-first-principles)
    - [Lesson 7.3](#lesson-73)
      - [Video 7.303 Chain rule](#video-7303-chain-rule)
  - [Week 14](#week-14)
    - [Lesson 7.6](#lesson-76)
      - [Practice quiz 7.602 Calculus topic](#practice-quiz-7602-calculus-topic)
  - [Week 15](#week-15)
    - [Lesson 8.1](#lesson-81)
      - [Video 8.101 Representations and properties of vectors](#video-8101-representations-and-properties-of-vectors)
    - [Lesson 8.2](#lesson-82)
      - [Video 8.204 Operations with matrices: linear combination, multiplication](#video-8204-operations-with-matrices-linear-combination-multiplication)
  - [Week 17](#week-17)
    - [Lesson 9.1](#lesson-91)
      - [Video 9.109 Designing regular shapes: polygons and stars](#video-9109-designing-regular-shapes-polygons-and-stars)
  - [Additional resources](#additional-resources)
    - [Larson, R. Precalculus with limits. (Boston, MA: Cengage, 2017) 4th edition [ISBN 9781337516853]](#larson-r-precalculus-with-limits-boston-ma-cengage-2017-4th-edition-isbn-9781337516853)

# Numerical Mathematics - Reported problems

This page is about the [numerical mathematics module](../../../modules/level_4/numerical_mathematics/).

## Week 1

### Video: 1.001 Introduction to number bases and modular arithmetic

- At 11:16, `(255, 255, 255)` is **white**, not blue.

### Video: 1.101 Introduction to number bases

- At 11:34: Wrong. Each column is a power of 60, so it should be times `1`, times `60` and times `3600`.

### Video: 1.107 Place value for fractional numbers: binary

- At 0:37: The "fractional point" is called "radix point".

### Practice quiz: 1.110 Rational and irrational numbers: decimal and binary

- Answers should be given without spaces.
- When a repeating fractional part is present, the answer should be written as `i.rr...`, where `i` stands for **integer part**, `r` is the **repeating** fraction and one must include three dots at the end. Example:

  $$3.12121212121212$$

  is written as

  $$3.1212...$$

## Week 2

### Video: 1.401 Octal and hexadecimal (integer)

- In the quiz at 3:41, the place values are supposed to be entered as "1, 16, 256". The answer isn't accepted.
- In the quiz at 4:24, 65536 should be written as $2^{16}$, but the "6" isn't part of the exponent part.
- At 5:07, second letter in hexadecimal should be "B", not "D".
- At 6:01, the hexadecimal number `11F` should have an expansion starting with $1 \times 16^2$, not $1 \times 16_2$ as displayed.
- In the quiz at 6:29, the third answer is 256, not 64. The last part is asking in the quiz for multiples in binary while the answer is given for hexadecimal.

### Practice quiz: 1.404 Translate between decimal and hexadecimal or octal (fractional)

- `3.44` in octal is $3 + \frac{1}{2} + \frac{1}{16}$, not $3 + \frac{1}{2} + \frac{1}{32}$.
- Options may present groupings of numbers. If a grouping is supposed to be of **3** digits for instance and you're presented with **4** digits, assume that the last digit should be in subscript (representing the number base, such as **2** for binary or **8** for octal) so that it makes sense when reading. In a grouping of 3 digits, `0002` should be interpreted as `000`, base `2`.

### FIXED - Video: 1.405 Special relationship between binary and hexadecimal, and binary and octal

- At 7:38, this is wrong. `C` (base 16) = 12 (base 10) = 1100 (base 2), not 1101.
- At 11:24, The grouping of digits is wrong. $1.001.111 1$ in binary should read $1 001.111 100$, having only one radix point.
- At 11:37, it is said the answer is `11.71` (base 8). Wrong: It's `11.74` (base 8).

### Practice quiz: 1.406 Translate between binary and hexadecimal/octal

- Question 6: `73.06` (base 8) _is_ `111011.00011` in binary.

### Practice quiz: 1.602 Arithmetic in hexadecimal/octal

- `6D × 60` in hexadecimal is `28E0`.
- `6C × 3B` in hexadecimal is `18E4`.

## Week 3

### Lesson 1.10

#### Video: 1.1004 Multiplicative identity, inverse mod k, exponentiation mod k

- At 27:20, 8<sup>3</sup> is _not_ 255 but 512.

#### Video 1.1006 Mod, rem and division

- At 1:49, the expression isn't rendered properly (the congruence symbol doesn't appear). Subsequent expressions also present this issue.

### Lesson 1.11

#### Video 1.1101 Encryption using modular arithmetic

- At 3:43, a banner appears in the background and has nothing to do with was it being taught.
- At 4:40 and 4:52, the congruence symbol is not rendered properly: $C \equiv M^e \pmod p$.

- At 6:04, it should be $C^7 \pmod {11}$, **not** $C^3 \pmod {11}$.
- At 8:43, the equation appears in the background and can't be read. The equation is: $ed = 3 \times 7 = 21$.

- At 11:28, again the expression can't be read. The expression is: $a^p \equiv a \pmod p$.

## Week 4

### Lesson 2.1: Video 2.103 Defining sequences

- Audio is out of sync from 15:19 onward: please refer to the transcript to better follow along.

### Lesson 2.2: Video 2.201 Arithmetic progressions

**Partially fixed**. The transcript and subtitles do not appear at this moment.

## Week 5

### Lesson 2.5

#### Video 2.502 Series: sums of terms of sequences; summation symbol: sigma notation

- At 20:38, the number `32` was skipped when calculating the sum of the series.

#### Video 2.509 Finite sums

- At 10:11, the summation for the term $k^2$ is omitted.

### Lesson 2.6

#### Practice quiz: 2.602 Limits of sequences

- Question 1: There is no clear way to indicate that there is no limit or what the considered interval really is.

#### Video 2.604 Patterns in series; limit; convergent and divergent series

- The result for the last example is $\frac{1}{3}$, not $270$.

#### FIXED - Practice quiz 2.608 Criteria for identifying convergent/divergent sequences and series

- Question 1: The answer is `divergent`.
- Question 2: The answer is `convergent,3/4`.

### Summative quiz

- Question 2: The quiz does not accept the valid answer and tells the user that the wrong answer is correct instead.

## Week 6

### Lesson 3.1

#### Video 3.101 Cartesian coordinates

- There is no sound.

### Lesson 3.2

#### Video 3.204 Functions and tables of values

- At 10:44, $f(\frac{-3}{4}) = \frac{-2}{\frac{-3}{4}} = \frac{8}{3}$, not $\frac{2}{3}$.

#### Video 3.207 Plotting graphs by hand – straight lines

- At 4:17, the result of $\frac{-1}{2}x + 3 = 0$ is $x = 6$, **not** $x = -6$.

#### Video 3.211 Plotting graphs by hand – reciprocal

- There is no sound nor visual guidance from 8:16 till 8:35.

### Lesson 3.4

#### Video 3.401 Kinematic equations

- At 8:00, the last formula presented at the bottom of the slide should not have $a^2$ but $a$ instead, as follow: $$s(t) = vt - \frac{1}{2}at^2$$

### Summative quiz

- No formatting seems appropriate to answer question 2. None of the following is accepted: `inf`, `infinity`, `infty`.

## Week 7

### Lesson 4.1

#### Video 4.101 Introduction to angles and triangles

- At 17:09, $\frac{37 \times 2\pi}{360} \approx 0.646 rad$, **not** $0.323 rad$.

### Lesson 4.2

#### Practice quiz 4.204 Trigonometric ratios in the right-angled triangle

- Questions 6 and 7 present different errors:
  - The information in the question doesn't necessarily match the data in the picture.
  - The grader expects impossible answers for the missing side and/or angle. Verify your answer with Pythagoras's theorem and the sine rule instead of relying on the grader.

#### Video 4.206 Trigonometric ratios in the right-angled triangle: Part 2

- At 14:03, $tan(B) = \frac{b}{c}$, **not** $tan(B) = \frac{b}{a}$.

## Week 8

### Summative quiz

- Question 1: The given angles in the selection are computed correctly, but they do not correspond to the correct letter: the value of angle **C** should be the value of angle **A** and vice versa.
- Question 4: The grader appears to consistently invert the solution when converting from radians to degrees. For example, **40 radians** is **~131.83°** but the expected answer is **0.698°**, which is the result **in radians** of **40°**.
- [**fixed**] The quiz doesn't let the student see what the mistakes are once the quiz has been submitted.

## Week 10

### Lesson 5.3

#### Practice quiz 5.307 Solving trigonometric equations

- Question 3: The answer should be _None of the other options is correct_ when asked for a value of $x$ where $tan(180^\text{o} - x) = tan(45^\text{o})$.

### Lesson 5.4

#### Summative quiz 5.402 Trigonometric functions

- Question 2: The option $cos(355^\text{o}) = cos(360^\text{o} - 355^\text{o}) = 0.996$ is valid and should be selected, but is currently marked as wrong.
- Question 3: Some translations that should occur in the negative x-direction, such as $sin(3x + 1)$, are mistakenly graded as being in the positive x-direction.

## Week 12

### Lesson 6.2

#### Video 6.207 Logarithmic equations

- At 14:40, a negative sign is added to $e^2$. The equation should instead be: $$e^2 x + e^2 = x \iff e^2 x - x + e^2 = 0$$

## Week 13

### Lesson 7.2

#### Practice quiz 7.202 Differentiation from first principles

- Question 1: The selection is invalid. $5x^{5-4}-3 \cdot2x^{2-1}+0$ should not be selected as it is not equivalent to the right answer, which is also another available option to select: $$\frac{d}{dx}(x^5-3x^2-1) = 5x^4-6x = x(5x^3-6) \neq 5x^{5-4}-3 \cdot2x^{2-1}+0$$

### Lesson 7.3

#### Video 7.303 Chain rule

- At around 3:45, the final expression for the derivative of $$y=\frac{1}{3x^2-5x+2}$$ is missing a negative sign in front of it. The correct expression should be as follow: $$y'=-\frac{6x-5}{(3x^2-5x+2)^2}$$

## Week 14

### Lesson 7.6

#### Practice quiz 7.602 Calculus topic

- Questions 5 and 6 assume $n\to \infty$, which is indispensable to know to calculate the limit.

## Week 15

### Lesson 8.1

#### Video 8.101 Representations and properties of vectors

- At 4:16, the notation for the vector is wrong. It should instead be: $$\vec{v} =\begin{pmatrix} 1 \\\ 2 \end{pmatrix}$$

### Lesson 8.2

#### Video 8.204 Operations with matrices: linear combination, multiplication

- At 9:48, the resulting matrix contains an error at row 2, column 4. The correct value is **122** as shown in this matrix:
  $$ A \times C = \begin{pmatrix} 12 & 1 & -6 & 50 & 6 \\ 21 & 4 & \frac{-27}{2} & 122 & 15\\ \end{pmatrix}$$

## Week 17

### Lesson 9.1

#### Video 9.109 Designing regular shapes: polygons and stars

- The video blacks out from 2:53 onward.

---

## Additional resources

### Larson, R. Precalculus with limits. (Boston, MA: Cengage, 2017) 4th edition [ISBN 9781337516853]

- Page **423**: Minor mistake in carrying calculations:
  ![Larson p423](images/larson_p423.png)
