[Go back to the main page](../../../README.md)

# Table of contents

- [Table of contents](#table-of-contents)
- [Algorithms and Data Structures I](#algorithms-and-data-structures-i)
- [Topics covered](#topics-covered)
- [Assessment](#assessment)
- [Resources](#resources)
  - [Complementary learning](#complementary-learning)
    - [Algorithms](#algorithms)
      - [`mergeSort` algorithm](#mergesort-algorithm)
      - [`quickSort` algorithm](#quicksort-algorithm)
    - [Computational complexity & P vs NP](#computational-complexity--p-vs-np)
  - [Essential reading](#essential-reading)
  - [Examples of past and current written exams](#examples-of-past-and-current-written-exams)
  - [Kinks to be aware of](#kinks-to-be-aware-of)
  - [Notes](#notes)
  - [On REPL](#on-repl)
  - [Syllabus](#syllabus)

---

# Algorithms and Data Structures I

This module will help you to develop your analytical and
problem-solving skills. It will encourage you to think about how to
use computers to solve problems. You'll develop skills in thinking
algorithmically and learn the central concepts of algorithms and data
structures. You will learn about linear data structures such as
arrays, vectors and lists and a unifying framework for considering
such data structures as collections. You'll study how algorithms can
be expressed as flowcharts and pseudocode and how to convert these
into programs. You'll learn specific algorithms used for sorting and
searching, and how to express repetition as iteration and
recursion. You will learn a simple model for execution of computation,
and how to describe computational problems and their solutions. The
model will allow you to compare algorithms regarding their correctness
and regarding their efficiency.

# Topics covered

- Introduction to algorithms, flowcharts and pseudocode
- Computations using flowcharts and pseudocode
- Pairs, vectors and dynamic arrays
- Basic searching
- Linked lists
- Basic sorting
- Advanced searching and introduction to complexity
- Recursive algorithms
- Advanced sorting
- Linear collections

# Assessment

One two hour unseen written examination and coursework (Type I)

# Resources

## Complementary learning

- [Algorithmic Design and Techniques](https://courses.edx.org/courses/course-v1:UCSanDiegoX+ALGS200x+2T2017/course) - _"On edX platform, by UCSanDiegoX."_

### Algorithms

- [Comparison of Algorithms](https://en.wikipedia.org/wiki/Sorting_algorithm#Comparison_of_algorithms) - See time complexity at a glance for various popular algorithms.
- [Data Structure & Algorithms Introduction](https://www.programiz.com/dsa/algorithm) - Sorting algorithms, data structures, tree data structure and more.

#### `mergeSort` algorithm

- [2.7.2. Merge Sort Algorithm](https://www.youtube.com/watch?v=mB5HXBb_HY8) - Abdul Bari
- [Algorithm lecture 8 -- Merge sort algorithm, analysis and problems](https://www.youtube.com/watch?v=sfmaf4QpVTw) - Gate Lectures by Ravindrababu Ravula

#### `quickSort` algorithm

- [Algorithms lecture 9 -- Quick sort algorithm](https://www.youtube.com/watch?v=3DV8GO9g7B4) - Gate Lectures by Ravindrababu Ravula
- [2.8.1 QuickSort Algorithm](https://www.youtube.com/watch?v=7h1s2SojIRw) - Abdul Bari

### Computational complexity & P vs NP

- [Big-O Cheat Sheet](https://www.bigocheatsheet.com/) - bigocheatsheet.com
- [Computational Complexity](https://www.youtube.com/watch?v=moPtwq_cVH8) - MIT OpenCourseWare
- [P vs. NP and the Computational Complexity Zoo](https://www.youtube.com/watch?v=YX40hbAHx3s) - hackerdashery

## Essential reading

_"Specific essential readings for this course will be taken from the following text book:_

- **Cormen, T.H., C.E. Leierson, R.L. Rivest and C. Stein Introduction to Algorithms. (Cambridge, MA: MIT Press, 2009) 3rd edition.**

_The specific pages for the reading activities will be given in the platform, and there is no need to read beyond to recommended pages._

_In addition to the text book, there are additional reading activities written by the course author, some of which involve coding exercises._

_There will also be discussion prompts asking you to do some independent research using online sources."_

## Examples of past and current written exams

- [2014 - 1](./past_exams/ADS14.pdf)
- [2014 - 2](./past_exams/ADS14-2.pdf)
- [2015](./past_exams/ADS15.pdf)
- [2016](./past_exams/ADS16.pdf)
- [2018](./past_exams/ADS18.pdf)
- [2020](./past_exams/ADS20.pdf) - ([Official answers](./past_exams/ADS20_answers.pdf)) (:lock: **enrolled students**: more answers were compiled on Slack, [see this thread](https://londoncs.slack.com/archives/CKZT2SR0U/p1582561904016800))

## Kinks to be aware of

- [List of reported errors and bugs with the module](../../../kinks/level_4/algorithms_and_data_structures_i/).

## Notes

- See shared notes [in this section](../../../notes/algorithms_and_data_structures_i).

## On REPL

- [YouTube](../../../youtube/README.md#algorithms).
- [Websites](../../../websites/README.md#algorithms).

## Syllabus

- [Syllabus PDF (October 2019)](./resources/Syllabus_Algorithms_and_Data_Structures_1_CM1035.pdf)
