[Go back to the main page](../../../README.md)

# Table of contents

- [Table of contents](#table-of-contents)
- [Discrete Mathematics](#discrete-mathematics)
- [Topics covered](#topics-covered)
- [Assessment](#assessment)
- [Resources](#resources)
  - [Additional reading](#additional-reading)
  - [Essential reading](#essential-reading)
  - [Examples of past and current written exams](#examples-of-past-and-current-written-exams)
  - [Kinks to be aware of](#kinks-to-be-aware-of)
  - [Mathematical symbols](#mathematical-symbols)
  - [Notes](#notes)
  - [On REPL](#on-repl)
  - [Solutions to problems in the textbook Discrete Mathematics and its Applications](#solutions-to-problems-in-the-textbook-discrete-mathematics-and-its-applications)
  - [Supplementary videos](#supplementary-videos)
  - [Syllabus](#syllabus)
  - [Weekly readings](#weekly-readings)

---

# Discrete Mathematics

This module helps hone your skills in thinking abstractly. It also
introduces you to many of the discrete models used to help understand
and design computational systems. Through this module, you'll develop
the fundamental discrete mathematical tools that will support you during
the BSc degree. Particular attention is paid to notions of
experimentation, reasoning and generalisation.

# Topics covered

[See this fabulous mind map for more details](./resources/CM-1020_DM_mind_map.png).

- Sets
- Boolean Algebra
- Propositional Logic
- Predicate Logic
- Functions
- Recursion and Mathematical Induction
- Relations
- Graphs
- Trees
- Counting

# Assessment

One two hour unseen written examination and coursework (Type I)

# Resources

## Additional reading

- [A Guide to Writing Proofs](./resources/A_Guide_to_Writing_Proofs.pdf).
- [Common Mistakes in Discrete Math](https://highered.mheducation.com/sites/0073383090/student_view0/common_mistakes_in_discrete_math.html) (from the companion website to the essential reading for the book _Discrete Mathematics and its Applications_).
- [Discrete Mathematics Questions and Answers](https://www.sanfoundry.com/1000-discrete-mathematics-questions-answers) - _"Our 1000+ Discrete Mathematics questions and answers focuses on all areas of Discrete Mathematics subject covering 100+ topics in Discrete Mathematics."_
- [Induction: going through examples (UoL students)](./resources/induction_example.pdf).
- [Matching (Graph Theory)](https://brilliant.org/wiki/matching) - _"Definition, terminology, bipartite matching, examples."_
- [Readings from MIT OpenCourseWare](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-042j-mathematics-for-computer-science-fall-2010/readings/) on proofs, graph theory, recurrences, probability.
- [Set Theory for Computer Science](./resources/set_theory_for_computer_science.pdf).
- [Solving Linear Recurrence Relations](./resources/solving_linear_recurrence_relations.pdf) - From University of California, Berkeley, [from this page](https://math.berkeley.edu/~arash/55/8_2.pdf).
- TrevTutor.com:
  - [Set theory, Logic, Counting, Proof techniques, relations and functions, number theory & formal language, with exams & solutions](https://trevtutor.com/discretemath/discretemath1/).
  - [Counting & probability, generating functions & recurrence relations, graph theory, with exams & solutions](https://trevtutor.com/discretemath/discrete-math-2/).

## Essential reading

_"The essentials readings for this course will come from the following text book, which is available in the University of London digital library:_

- **Kenneth, H, Rosen. Discrete Mathematics and its Applications. (2012) 7th Edition**
- **David Mackinson, Sets, Logic and Maths for Computing, Springer Verlag. 2012**

_This course does not require you to read the whole book, you will be given specific readings for each topic from these texts are listed with direct links on the Readings page for each topic. You will also be asked to do some independent research from online sources or using the University of London digital library."_

## Examples of past and current written exams

- [2014](./past_exams/DM14.pdf)
- [2015](./past_exams/DM15.pdf)
- [2016](./past_exams/DM16.pdf)
- [2017](./past_exams/DM17.pdf)
- [2018](./past_exams/DM18.pdf) ([answers are being compiled in this PDF](./past_exams/DM18_answers.pdf))
- [2020](./past_exams/DM20.pdf) ([PDF with answers](./past_exams/DM20_answers.pdf)) — :lock: **enrolled students**: answers are being compiled on Slack, [see this thread](https://londoncs.slack.com/archives/CKZT2LKPW/p1582307389452400)

## Kinks to be aware of

- [List of reported errors and bugs with the module](../../../kinks/level_4/discrete_mathematics/).

## Mathematical symbols

- The [list of mathematical symbols](https://en.wikipedia.org/wiki/List_of_mathematical_symbols) on Wikipedia is a handy reference. Chapter 1 of _Kenneth, H, Rosen. Discrete Mathematics and its Applications. (2012) 7th Edition_ is outside the scope of the essential readings for this module, but provides a solid foundation to understand the notations and some proof techniques used during the course.
- [Type mathematical symbols (online keyboard)](https://math.typeit.org) - Online keyboard to help with typing mathematical symbols.

## Notes

- See shared notes [in this section](../../../notes/discrete_mathematics).

## On REPL

- [Websites](../../../websites/README.md#discrete-mathematics)

  - **Algorithms**
    - [Hopcroft-Karp algorithm - Bipartite Matching](https://www-m9.ma.tum.de/graph-algorithms/matchings-hopcroft-karp/index_en.html) - Interactive: _"Here we demonstrate the Hopcroft-Karp algorithm that solves the problem of finding maximal matchings on bipartite graphs."_
    - [VisuAlgo](https://visualgo.net/en) - Visualising data structures and algorithms through animation.
  - **Binomial theorem**
    - [Intro to the Binomial Theorem](https://www.khanacademy.org/math/precalculus/x9e81a4f98389efdf:polynomials/x9e81a4f98389efdf:binomial/v/binomial-theorem) - Khan Academy
  - **Graph theory**
    - [D3 Graph Theory](https://d3gt.com) - _"Learn graph theory interactively."_
    - [Matching (Graph Theory)](https://brilliant.org/wiki/matching) - _"Definition, terminology, bipartite matching, examples."_
  - **Rules of inference - logic proofs**
    - [Rules of Inference and Logic Proofs](http://sites.millersville.edu/bikenaga/math-proof/rules-of-inference/rules-of-inference.html) - Covers modus ponens, modus tollens, disjunctive syllogism, De Morgan's law, biconditional, conjunctions, disjunctions, equivalences, double negation.

- [YouTube](../../../youtube/README.md#discrete-mathematics)
  - **Algorithms**
    - [Algorithms: Graph Search, DFS and BFS](https://www.youtube.com/watch?v=zaBhtODEL0w) - HackerRank
    - [Breadth-First Search (BFS) algorithm](https://www.youtube.com/watch?v=s-CYnVz-uh4) - MIT OpenCourseWare
    - [Depth-First Search (DFS), Topological Sort](https://www.youtube.com/watch?v=AfSk24UTFS8) - MIT OpenCourseWare
    - [Graph Traversals - BFS & DFS -Breadth First Search and Depth First Search](https://www.youtube.com/watch?v=pcKY4hjDrxk) - Abdul Bari
    - [Maximum Matching Algorithm](https://www.youtube.com/watch?v=gbasc4F-7hk) - HEGARTYMATHS
    - **Dijkstra's algorithm**
      - [Dijkstra's Shortest Path Algorithm | Graph Theory](https://www.youtube.com/watch?v=pSqmAO-m7Lk) - WilliamFiset
      - [Graph Data Structure 4. Dijkstra’s Shortest Path Algorithm](https://www.youtube.com/watch?v=pVfj6mxhdMw) - Computer Science
      - [Dijkstra's algorithm in 3 minutes — Review and example](https://www.youtube.com/watch?v=_lHSawdgXpI) - Michael Sambol
    - **Hopcroft–Karp algorithm**
      - [Hopcroft karp Algorithm explanation](https://www.youtube.com/watch?v=OhtWajIAU-M) - Holly Baker
      - [Hopcroft-Karp Algorithm](https://www.youtube.com/watch?v=0GNYjXUPTFM) - Samuel Russell
      - [Hopcroft–Karp algorithm](https://www.youtube.com/watch?v=lM5eIpF0xjA) - Joromy Bou Khalil
    - **Kruskal’s algorithm**
      - [Kruskal's algorithm in 2 minutes — Review and example](https://www.youtube.com/watch?v=71UQH7Pr9kU) - Michael Sambol
      - [Kruskal’s Algorithm for Minimum Spanning Tree](https://www.youtube.com/watch?v=3rrNH_AizMA) - GeeksforGeeks
    - **Prim's algorithm**
      - [Prim's algorithm in 2 minutes — Review and example](https://www.youtube.com/watch?v=cplfcGZmX7I) - Michael Sambol
  - [Computer Sc - Discrete Mathematical Structures](https://www.youtube.com/view_play_list?p=0862D1A947252D20) (playlist) - Kamala Krithivasan
  - [Discrete Math 1: Sets, propositional logic, factorials, permutations, combinations, proofs, mathematical induction, injective/surjective/bijective functions, inverse functions, algorithms](https://www.youtube.com/watch?v=tyDKR4FG3Yw&list=PLDDGPdw7e6Ag1EIznZ-m-qXu4XX3A0cIz) (playlist) - TheTrevTutor
  - [Discrete Math 2: Permutations, combinations, probability, graph theory, trees, Dijkstra's Algorithm](https://www.youtube.com/watch?v=DBugSTeX1zw&list=PLDDGPdw7e6Aj0amDsYInT_8p6xTSTGEi2) (playlist) - TheTrevTutor
  - [Discrete Math I](https://www.youtube.com/watch?v=OApHaIMKMJE&list=PLl-gb0E4MII0L5lz8uQ8j5aSFQQHoAzXx) (playlist) - Kimberly Brehm
  - [Discrete mathematics](https://www.youtube.com/watch?v=2juspgYR7as&list=PLsFENPUZBqioyqffh3YZ2pKUg4uZFQJUY) (playlist) - GATEBOOK Video Lectures
  - Recurrence relations: see lectures 14-15 of [Mathematics for Computer Science (2010)](https://www.youtube.com/watch?v=L3LMbpZIKhQ&list=PLB7540DEDD482705B) (playlist) - MIT OpenCourseWare
  - [Sets, sequences, functions, summations, matrices, algorithms](https://www.youtube.com/watch?v=ZMhoRLGNR5Y&list=PLl-gb0E4MII0HmmhGXBIFGppSSqqy_mV-) (playlist) - Kimberly Brehm
  - [Strong Induction Examples](https://www.youtube.com/watch?v=6O1s3_GsSHo) - Michael Barrus
  - [The Karnaugh Map - Rules of Simplification](https://www.youtube.com/watch?v=PA0kBrpHLM4) - Jonnie Palmer
  - [Transitive closure](https://www.youtube.com/watch?v=OO8Jfs9uZnc) - GVSUmath

## Solutions to problems in the textbook Discrete Mathematics and its Applications

- [7th Edition (2012) - written explanations on Slader.com](https://www.slader.com/textbook/9780073383095-discrete-mathematics-with-applications-7th-edition)
- [8th Edition (2018) - step-by-step solutions in videos on Numerade.com](https://www.numerade.com/books/discrete-mathematics-and-its-applications/)

## Supplementary videos

| Weeks in the module             | Resource                                                                                                                                                                                                                                                                                                                                                                                         |
| ------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| 1 & 2 Sets                      | [TheTrevTutor DM Video 1-9](https://www.youtube.com/playlist?list=PLDDGPdw7e6Ag1EIznZ-m-qXu4XX3A0cIz)                                                                                                                                                                                                                                                                                            |
| 3 & 4 Functions                 | [TheTrevTutor DM Video 51-56](https://www.youtube.com/playlist?list=PLDDGPdw7e6Ag1EIznZ-m-qXu4XX3A0cIz)                                                                                                                                                                                                                                                                                          |
| 5 & 6 Propositional logic       | [Introduction to mathematical thinking (0.0 - 4.3)](https://www.youtube.com/playlist?list=PL_onPhFCkVQiZgE9U539_QmKLJV_0YvlQ)                                                                                                                                                                                                                                                                    |
| 7 & 8 Predicate logic           | [Introduction to mathematical thinking (5.1 - 6.4)](https://www.youtube.com/playlist?list=PL_onPhFCkVQiZgE9U539_QmKLJV_0YvlQ)                                                                                                                                                                                                                                                                    |
| 9 & 10 Boolean Algebra          | [Karnaugh maps - (watch 4.2.1 - 4.2.5)](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-004-computation-structures-spring-2017/c4/c4s2/)                                                                                                                                                                                                                               |
| 11 & 12 Induction and recursion | - [Introduction to mathematical thinking (7.1 - 8.4)](https://www.youtube.com/playlist?list=PL_onPhFCkVQiZgE9U539_QmKLJV_0YvlQ) <br> - [Math for CS - MIT (Lecture 1, 2, 3, 14 and 15 and reading from MCS notes)](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-042j-mathematics-for-computer-science-fall-2010/video-lectures/)                                    |
| 13 & 14 Graphs                  | - [Math for CS - MIT (Lecture 6 to 10 and reading from MCS notes)](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-042j-mathematics-for-computer-science-fall-2010/video-lectures/) <br> - [FreeCodeCamp - Algorithms Course - Graph Theory Tutorial from a Google Engineer](https://www.youtube.com/watch?v=09_LlHjoEiY) (focuses more on implementation than theory) |
| 15 & 16 Trees                   | Partly covered in Math for CS - MIT videos for 13/14.                                                                                                                                                                                                                                                                                                                                            |
| 17 & 18 Relations               | [Math for CS - MIT (Lecture 11 and reading from MCS notes)](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-042j-mathematics-for-computer-science-fall-2010/video-lectures/)                                                                                                                                                                                           |
| 19 & 20 Combinatorics           | [Math for CS - MIT (Lecture 16 and 17 and reading from MCS notes)](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-042j-mathematics-for-computer-science-fall-2010/video-lectures/)                                                                                                                                                                                    |

## Syllabus

- [Syllabus PDF (October 2019)](./resources/Syllabus_Discrete_Mathematics_CM1020.pdf)

## Weekly readings

- [Reading by weeks and topics PDF](./resources/DM_Reading.pdf)
