[Go back to the main page](../../../README.md)

- [Fundamentals of Computer Science](#fundamentals-of-computer-science)
- [Topics covered](#topics-covered)
- [Assessment](#assessment)
- [Resources](#resources)
  - [Essential reading](#essential-reading)
  - [Notes](#notes)
  - [Study guide](#study-guide)
  - [Syllabus](#syllabus)
  - [Weekly reading list](#weekly-reading-list)
  - [Supplementary Videos](#supplementary-videos)

# Fundamentals of Computer Science

In this module, you'll gain a broad understanding of key topic areas in
computer science and the fundamental concepts underpinning them. In the
area of fundamental concepts, you'll learn about binary representations
and logic, complexity theory and theories of computation, finite state
machines and Turing machines. Building on this, you'll then study key
areas of interest in computer science including databases, artificial
intelligence and machine learning. These will be presented as practical
examples to illustrate how they are implemented in modern computer
systems.

# Topics covered

- Boolean logic
- Algorithms
- Searching and sorting algorithms
- Theory of Computation and complexity
- Turing machines and universal machines
- Basic combinatorial principles
- Proof techniques
- Finite automata
- Regular languages
- Context-free grammar

# Assessment

One two hour unseen written examination and coursework (Type I)

# Resources

## Essential reading

_"Specific essential readings for each week from the following list are included in the Readings page for each week:_"

- Kenneth H. Rosen (2011). Discrete Mathematics and its Applications, 7th. McGraw-Hill
- :key: Michael Sipser (2012). Introduction to the theory of computation, 3rd. Cengage Learning
- :key: John Hopcroft et al. (2013). Introduction to Automata Theory, Languages and Computation, Pearson
- Dexter Kozen (2007). Automata and Computability, 1st. Springer
- Merlin Forbes (2012). A Theoretical Introduction to Turing Machine, 1st. Learning Press
- Shi-Kui Chang (2003). Data Structures and Algorithms, 1st. World Scientific Publishing Co

## Notes

- See shared notes [in this section](../../../notes/fundamentals_of_computer_science).

## Study guide

- [Resources compiled by Hassan Sarhan](https://github.com/h-sarhan/FCS-study-guide).

## Syllabus

- [Syllabus PDF (October 2019)](./resources/Syllabus_Fundamentals_of_Computer_Science_CM1025.pdf)

## Weekly reading list

- [Weekly reading list PDF](./resources/FCS_reading_list.pdf)

## Supplementary Videos

Following are supplementary videos for Theory of computation part of the module (week 7-14) for week 1-6 refer NM/DM material and for week 15-20 refer ADS1 material.

- [Stanford - Lagunita - Jeff Ullman - "Automata theory" (uses Hopcroft - Ullman book and slideshow based lectures)](https://lagunita.stanford.edu/courses/course-v1:ComputerScience+Automata+Fall2016/about)
- [UC Davis - YouTube - Dan Gusfield - "Theory of Computation" (Uses Sipser book and blackboard style lectures)](https://www.youtube.com/watch?v=GP21wU6R0-o&list=PLslgisHe5tBM8UTCt1f66oMkpmjCblzkt)
- [Portland State university - YouTube - Harry Porter - "Theory of Computation"(Uses Sipser book and paper+sharpie for teaching) ](https://www.youtube.com/playlist?list=PLbtzT1TYeoMjNOGEiaRmm_vMIwUAidnQz)
