[Go back to the main page](../../../README.md)

# Table of contents

- [Table of contents](#table-of-contents)
- [Introduction to Programming I](#introduction-to-programming-i)
- [Topics covered](#topics-covered)
- [Assessment](#assessment)
- [Resources](#resources)
  - [Essential reading](#essential-reading)
  - [JavaScript](#javascript)
    - [p5.js - JavaScript library](#p5js---javascript-library)
    - [W3 Schools](#w3-schools)
  - [Kinks to be aware of](#kinks-to-be-aware-of)
  - [Notes](#notes)
  - [On REPL (see relevant sections)](#on-repl-see-relevant-sections)
  - [Sleuth assignments](#sleuth-assignments)
    - [Tips & Tricks](#tips--tricks)
    - [Utils and aids (student created)](#utils-and-aids-student-created)
  - [Syllabus](#syllabus)
  - [Text editor](#text-editor)

# Introduction to Programming I

This module focuses on basic programming techniques. You'll learn
how to use the fundamental elements of computer programming such as
variables, conditionals, functions and loops. You'll learn how to
create interactive, graphical computer programs. You will also be
introduced to basic object-oriented programming techniques.

# Topics covered

- Your development environment
- Drawing in 2D
- Variables, Objects and Interaction
- Conditional Statements
- Basic loops and arrays
- Traversing with for loops
- Functions
- Advanced loops and arrays
- Extending Objects
- Constructor functions

# Assessment

Coursework only (Type II)

# Resources

## Essential reading

_"There is no required textbook for this module. The module draws on number of different, largely web-based, public resources as well as the resources produced as bespoke material for this module. The programming language is Javascript, with the p5js library used for graphical and interactive programming functionality. The main external resource is the set of online tutorials available from: [https://p5js.org/learn/](https://p5js.org/learn/)."_

_"Specific readings for each topic are listed with direct links to free online resources that provide additional material on the topics of this course."_

## JavaScript

### p5.js - JavaScript library

- [p5.js](https://p5js.org/) - Official website to find [the reference guide](https://p5js.org/reference) and an [online editor](https://editor.p5js.org/) to practice. Next step: [p5.js libraries](https://p5js.org/libraries/).
  - [Examples](https://p5js.org/examples/) are also available to get started.
- [The Coding Train](https://www.youtube.com/user/shiffman/playlists) (playlists) - Channel from Daniel Shiffman, a board member of `p5.js`.

### W3 Schools

- [JavaScript Array Iteration Methods](https://www.w3schools.com/js/js_array_iteration.asp) - Will help in making your code more concise and readable.

## Kinks to be aware of

- [List of reported errors and bugs with the module](../../../kinks/level_4/introduction_to_programming_i/).

## Notes

- See shared notes [in this section](../../../notes/introduction_to_programming_i).

## On REPL (see relevant sections)

- [Podcasts](../../../podcasts/)
- [Websites](../../../websites/)
- [YouTube](../../../youtube/)

## Sleuth assignments

### Tips & Tricks

- Get familiar with finding precise coordinates in an image inside Brackets (text editor).
- Practice all basic drawing functions with `p5.js` in the [online editor](https://editor.p5js.org/) before attempting to solve crimes.
- You have a maximum number of attempts for each case: go ahead when you are pretty confident you are on the right path on your first attempt. You will have to wait a certain amount of time (about 24 hours) before you can attempt to solve the crime again.

### Utils and aids (student created)

- JavaScript library with visual aids for solving case 202 stage 4 [utils4sleuth.js](https://gist.github.com/amilos/beb1eee1cbd334f1e9abca8c9772c725).
- Python program to create directories for Sleuth cases [Make-Sleuth-Folders.py](https://github.com/BlairCurrey/Make-Sleuth-Folders)

## Syllabus

- [Syllabus PDF (April 2019)](./resources/ITP1-Syllabus.pdf)

## Text editor

The recommended text editor for this module is [Brackets](http://brackets.io/). More options available on the [free software page](../../../software/).
