[Go back to the main page](../../../README.md)

# Table of contents

- [Table of contents](#table-of-contents)
- [Web Development](#web-development)
- [Topics covered](#topics-covered)
- [Assessment](#assessment)
- [Resources](#resources)
  - [Essential reading](#essential-reading)
  - [Games](#games)
  - [Kinks to be aware of](#kinks-to-be-aware-of)
  - [On REPL (See sections on Web development)](#on-repl-see-sections-on-web-development)
  - [Programming](#programming)
    - [JavaScript](#javascript)
  - [Syllabus](#syllabus)

---

# Web Development

This module provides you with a foundational web development skillset.
You will learn the critical languages of the web: HTML, CSS and
JavaScript. Using HTML and CSS, you'll learn how to markup, layout and
style web content. You'll study the document object model and how you
can dynamically manipulate it with JavaScript to create interactive web
pages. You'll consider accessibility and usability issues, and how you
can overcome them. You'll learn about website deployment and how to
make your websites accessible to other people. The module also enables
you to present your work online in the form of a website.

Enrolled students only: [Course syllabus available on Coursera](https://www.coursera.org/learn/london-cs-orientation/supplement/p88ho/syllabus-web-development-cm1040).

# Topics covered

- Introduction to Web Development
- Web Site Design
- Essential HTML
- Introduction to CSS
- Positioning in Styling & Design
- Responsive CSS
- Introduction to JavaScript for the Web
- Manipulating the DOM using JavaScript
- JavaScript Libraries
- Web Hosting & Professional Practices

# Assessment

Coursework only (Type III)

# Resources

## Essential reading

_"There is no required textbook for this module. The module will draw on a number of different, largely web-based, public resources as well as the resources produced as bespoke material for this module. Some key online references are:_

- W3 Schools Online Web Tutorials, http://www.w3schools.com
- Mozilla Developer Network Tutorials, https://developer.mozilla.org/
- Marijn Haverbeke, 2012 "Eloquent JavaScript: A Modern Introduction to Programming" - free online text http://eloquentjavascript.net

_Specific readings for each topic are listed with direct links to free online resources that provide additional material on the topics of this course."_

## Games

- [CSS Diner](https://flukeout.github.io/) - _"A fun game to help you learn and practice CSS selectors."_
- [Flexbox Froggy](http://flexboxfroggy.com/) - _"A game for learning CSS flexbox."_
- [Flexbox Zombies](https://flexboxzombies.com/p/flexbox-zombies) - _"Master Flexbox layout: a game by geddski."_
- [Grid Critters](https://gridcritters.com/) - _"Completely learn CSS Grid once and for all."_
- [Grid Garden](https://codepip.com/games/grid-garden/) - _"How well can you tend to your carrot garden using CSS grid? In this game, you must water your carrot crops and poison the weeds by mastering CSS grid, a powerful new module that makes 2-dimensional grid layouts a piece of cake. With it you can define columns, rows, and grid template areas."_
- [Service Workies](https://serviceworkies.com/) - _"Learn Service Workers inside and out with the new game of Service Worker mastery."_

## Kinks to be aware of

- [List of reported errors and bugs with the module](../../../kinks/level_4/web_development/).

## On REPL (See sections on Web development)

- [Podcasts](../../../podcasts/)
- [YouTube](../../../youtube/)
- [Websites](../../../websites/)

## Programming

- [Mozilla Developer Network Tutorials](https://developer.mozilla.org/)
- [W3 Schools Online Web Tutorials](http://www.w3schools.com/)

### JavaScript

- [Eloquent JavaScript](http://eloquentjavascript.net/), by Marijn Haverbeke. The book can be downloaded:
  - [As PDF](http://eloquentjavascript.net/Eloquent_JavaScript.pdf);
  - [As EPUB](https://eloquentjavascript.net/Eloquent_JavaScript.epub);
  - [As MOBI](https://eloquentjavascript.net/Eloquent_JavaScript.mobi) (for Kindle).
- [Handlebars Training](https://www.youtube.com/playlist?list=PLtV5RF44Yj8S4RcpQehL-2XMuVsJXwNvK), by Rich Finelli (YouTube playlist)

## Syllabus

- [Syllabus PDF (April 2019)](./resources/syllabus_WD_CM1040.pdf)
