[Go back to the main page](../../../README.md)

# _Games Development_ specialism modules

### Artificial Intelligence

Focusing on Artificial Intelligence (AI) techniques, you will learn the
historical development of AI including search, vision and planning. You
will become familiar with the foundations of agent-based approaches to
software design, decision making and problem solving including under
uncertainty. You will have an opportunity to apply AI techniques to
particular problems such as game playing and decision making.

### Virtual Reality

The Virtual Reality (VR) module combines the theory and psychology of VR
with practical development skills. You'll learn the skills needed to
design compelling VR environments and the skills that apply to creative
practice, science and industry. This module gives you the skills needed
to develop VR, including understanding the basic theory of presence in
VR, which underlies the basic design principles. Using a 3D engine to
create interactive virtual environments, you'll also learn practical
development skills, including creating 3D environments, designing and
implementing 3D interaction for VR and building social VR experiences
with interactive virtual characters.

### Games Development

This module introduces you to i) industry standard tools for game
development, such as game engines, and ii) the process of game
development, including prototyping and playtesting. You will undertake a
series of game development projects, each lasting a few weeks and with
a specific brief. For each project, you'll propose a game that fits
the brief then deliver the game and document it thoroughly. Through this
process, you'll develop an awareness of intended audience and the use
of media for documentation. Contemporary video game production draws on
a range of techniques from AI to perform tasks like controlling virtual
agents and generating novel content. This module also introduces crucial
game AI concepts. Compared to mainstream AI, the emphasis is less on
optimal problem-solving and more on entertaining the player with limited
computational resources. This module provides practical experience of
programming game AI systems and an understanding of the relevant theory.

### 3D Graphics and Animation

This module covers advanced methods used in current state-of-the-art
graphics and animation systems. It includes mathematical foundations,
computational techniques and their use in creative practice. In this
module, you'll learn how to write programs that generate animated
3D graphics. There are several distinct study areas: 3D modelling and
animation, the graphics pipeline, simulation of physics and shader
programming. You'll study a range of examples and learn how to program
graphics in contemporary graphical software for different applications.

### Interaction Design

In this module, you'll examine the notion of ‘interaction with
technology'. You will focus on the concepts behind modern UX design
and production and gain a solid grasp and practical experience of
the process which allows the creation of interactive systems. This
process involves specification, design, prototyping and evaluation.
You'll examine several design approaches and techniques and consider
how they enable usability engineering. You'll learn how to evaluate
interactive systems against criteria such as efficiency and usability.
You'll examine accessibility issues from the perspective of different
populations.
