[Go back to the main page](../README.md)

# Slack

# Table of contents

- [Slack](#slack)
- [Table of contents](#table-of-contents)
  - [Resources](#resources)
    - [Channels](#channels)
      - [Fun channels](#fun-channels)
      - [Help and resources](#help-and-resources)
      - [Modules level 4](#modules-level-4)
      - [Modules level 5](#modules-level-5)
      - [Specialisms](#specialisms)
    - [How to use Slack](#how-to-use-slack)
  - [For developers & contributors](#for-developers--contributors)
    - [Slack Onboarding](#slack-onboarding)
      - [Slack Onboarding Workflow ('Slack Tutor')](#slack-onboarding-workflow-slack-tutor)

## Resources

### Channels

Don't forget to check out the right channels on Slack that will be best suited to help you!

#### Fun channels

| Channel          | Purpose                                                                                                                                     |
| ---------------- | ------------------------------------------------------------------------------------------------------------------------------------------- |
| `#hackathons`    | Organise coding challenges                                                                                                                  |
| `#hacking`       | Ethical hacking / general InfoSec stuff                                                                                                     |
| `#introductions` | Introduce yourself to your new course mates                                                                                                 |
| `#journal-club`  | Read and discuss research papers                                                                                                            |
| `#memes`         | Share all the dank memes                                                                                                                    |
| `#music`         | Off topic discussion about music                                                                                                            |
| `#pets`          | For a bit of furry, feathery or scaly relief                                                                                                |
| `#photography`   | Share your favorite photos and view those from others                                                                                       |
| `#random`        | A place for non-work-related flimflam, faffing, hodge-podge or jibber-jabber you'd prefer to keep out of more focused work-related channels |
| `#uol_game-jam`  | Group for organising game jams                                                                                                              |

#### Help and resources

| Channel                       | Purpose                                                                                                                                                                                                                                                   |
| ----------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `#advanceddegree`             | Everything related to advanced degree(s)                                                                                                                                                                                                                  |
| `#askpreviouscohorts`         | Asking previous cohorts questions related to the programme                                                                                                                                                                                                |
| `#bookworm`                   | What the great minds of this world are reading                                                                                                                                                                                                            |
| `#bugs`                       | When you see a bug, report it here so we can all collectively flag it and speed up the process of cleaning up the course content                                                                                                                          |
| `#channel-discovery`          | Find great new channels related to our degree                                                                                                                                                                                                             |
| `#cs-professionals`           | Gathering for professionals from computer science & engineering industry                                                                                                                                                                                  |
| `#entrepreneurs`              | A channel for entrepreneurs or wannabe entrepreneurs to collaborate and help each other                                                                                                                                                                   |
| `#free-stuff`                 | Free stuff to share with others. How have you used your student card etc?                                                                                                                                                                                 |
| `#functional`                 | Since functional programming is becoming kind of a mandatory skill in many companies and since it is not easy to be good at it, maybe we want to share thoughts, links, ideas, know-how, blogs, presentations, designs, patterns etc.                     |
| `#general`                    | This channel is for workspace-wide communication and announcements. All members are in this channel.                                                                                                                                                      |
| `#job_opportunities`          | To share IT job opportunities                                                                                                                                                                                                                             |
| `#linux`                      | A channel for Linux related discussions                                                                                                                                                                                                                   |
| `#live-sessions`              | Study in live sessions with your peers, making the most of our collective intelligence                                                                                                                                                                    |
| `#maths`                      | To share interesting math problems                                                                                                                                                                                                                        |
| `#newbies`                    | Discussion about programming fundamentals, for programming newbies                                                                                                                                                                                        |
| `#notes`                      | Sharing different notes not only from uni or links to other uni open lectures                                                                                                                                                                             |
| `#official-communications`    | Please post any helpful conversations with SRMs or communication from UoL here. Use threads and try to keep things searchable. (Add textual descriptions). A fair warning: even though the name says official. Nothing posted here is binding in any way. |
| `#open_source_collaborations` | For UoL students to collaborate together on projects they may want to use for portfolios or building future businesses                                                                                                                                    |
| `#pair-programming`           | Find partners to work with on programming problems                                                                                                                                                                                                        |
| `#podcasts`                   | Listen your way to success while being entertained                                                                                                                                                                                                        |
| `#resources`                  | Post useful learning resources here                                                                                                                                                                                                                       |
| `#reviewexchange`             | For those that need a peer review to review each other                                                                                                                                                                                                    |
| `#studytips_and_tools`        | Share study tips, methods, apps that might help others                                                                                                                                                                                                    |
| `#teachyourselfcs`            | Discussions related to the roadmap provided by teachyourselfcs.com, Find Resources on https://teachyourselfcs-uol.btofficiel.now.sh                                                                                                                       |
| `#vent`                       | We know that sometimes, you need to let off steam. Instead of cluttering other channels, it makes more sense to have a dedicated channel to just venting                                                                                                  |

All channels starting with `#asg` for **Accountable Study Groups**.

#### Modules level 4

| Channel                      | Module name                                                                                       |
| ---------------------------- | ------------------------------------------------------------------------------------------------- |
| `#cm1005-intro-prog-i`       | [Introduction to programming I](../modules/level_4/introduction_to_programming_i/README.md)       |
| `#cm1010-intro-prog-ii`      | [Introduction to programming II](../modules/level_4/introduction_to_programming_ii/README.md)     |
| `#cm1015-computational-math` | [Computational mathematics](../modules/level_4/computational_mathematics/README.md)               |
| `#cm1020-discrete-math`      | [Discrete mathematics](../modules/level_4/discrete_mathematics/README.md)                         |
| `#cm1025-fundamental-cs`     | [Fundamentals of computer science](../modules/level_4/fundamentals_of_computer_science/README.md) |
| `#cm1030-hcw`                | [How computers work](../modules/level_4/how_computers_work/README.md)                             |
| `#cm1035-algos-data-i`       | [Algorithms and data structures I](../modules/level_4/algorithms_and_data_structures_i/README.md) |
| `#cm1040-web-dev`            | [Web development](../modules/level_4/web_development/README.md)                                   |

#### Modules level 5

| Channel                               | Module name                                                                                         |
| ------------------------------------- | --------------------------------------------------------------------------------------------------- |
| `#cm2035-algos-data-ii`               | [Algorithms and data structures II](../modules/level_5/algorithms_and_data_structures_ii/README.md) |
| `#cm2040-databases-networks-web`      | [Databases, Networks and the Web](../modules/level_5/databases_networks_and_the_web)                |
| `#cm2030-graphics-programming`        | [Graphics Programming](../modules/level_5/graphics_programming)                                     |
| `#cm2005-object-oriented-programming` | [Object Oriented Programming](../modules/level_5/object_oriented_programming)                       |

#### Specialisms

| Channel         | Specialism                                                                       |
| --------------- | -------------------------------------------------------------------------------- |
| `#data_science` | [Data Science](../modules/level_6/data_science/README.md)                        |
| `#gamedev`      | [Game Development](../modules/level_6/games_dev/README.md)                       |
| `#iot`          | [Internet of Things](../modules/level_6/phys_computing_iot/README.md)            |
| `#mlai`         | [Machine Learning & Artificial Intelligence](../modules/level_6/ml_ai/README.md) |
| `#ux`           | [User Experience](../modules/level_6/user_experience/README.md)                  |
| `#vr`           | [Virtual Reality](../modules/level_6/virtual_reality/README.md)                  |
| `#webdev`       | [Web and Mobile Development](../modules/level_6/web_mobile_dev/README.md)        |

### How to use Slack

- [Available shortcuts](https://get.slack.help/hc/en-us/articles/201374536-Slack-keyboard-shortcuts)
- [How to format your messages](https://get.slack.help/hc/en-us/articles/202288908-Format-your-messages)
- [How to share snippets of code](https://slack.com/slack-tips/share-code-snippets) (JavaScript, HTML, CSS, Python, C++, etc.)
- [How to use pinned items](https://slack.com/intl/en-mx/help/articles/205239997-Pin-messages) (important info in each channel)
- [How to search effectively](https://slack.com/intl/en-mx/help/articles/202528808-Search-in-Slack) (filtering by channel, user, date, file types, etc.)
- [How to find channels](https://slackhq.com/introducing-channel-search-for-slack)
- [Using threads while communicating to keep chats organized](https://slack.com/intl/en-in/help/articles/115000769927-Use-threads-to-organise-discussions-)
- [Slack help center](https://get.slack.help/hc/en-us) for anything else

## For developers & contributors

### Slack Onboarding

#### Slack Onboarding Workflow ('Slack Tutor')

A Slack workflow welcomes new students joining the workspace to guide them on their journey from the very beginning by pointing them to this repository and other useful resources. Right now, the custom message sent by the workflow is as follow:

```
Hey @new_user_name! Welcome aboard. A few key points you will want to know to get started:

- *Reply using threads* to keep things neat instead of posting to the channel. :thumbsup:
- Read the *Programme Regulations* and the *Guidelines for Examinations*: london.ac.uk/sites/default/files/regulations/progregs-computer-science-2019-2020.pdf and london.ac.uk/sites/default/files/examiners/guidelines-for-examinations-2018-19.pdf
- *Post in the relevant channels*: there is a channel for each module, starting with `#cm`. For example, discrete maths questions should go in #cm1020-discrete-math. Use #askpreviouscohorts or #october2019batch for cohort specific discussion instead of #general.
- *Make sure a channel doesn't already exist* before creating another one with the same purpose. You can collaborate in a *private group work* by creating a *private channel* instead of a public one.
- *Curated list of course related resources* here: github.com/world-class/REPL
- Remember to check the *pinned messages* in each channel: you'll find useful info!
- *Please do your own research* (Slack, search engine, etc.) before asking a question that has been answered many times. For a start, make sure you have read all the documents you will find on that page: github.com/world-class/REPL#documents-and-resources-provided-publicly-by-the-university-of-london
- Don't forget the *_Search_ feature* available on Slack (specific keywords, messages from a specific user with *from:@username*, in different channels, by files, within certain dates, etc.). → slack.com/help/articles/202528808-search-in-slack
- Get in touch with your tutors and SRMs (Student Relationship Managers)! → github.com/world-class/REPL#reaching-out-to-tutors-and-srms
- Be *nice*, be *respectful*. Don't make jokes or post memes that target a particular gender, religion, nationality or sexuality — we're a global and multicultural community. *Some students may be more sensitive* about certain topics and we certainly *don't want to discriminate* anybody and *don't want to make Slack a hostile environment* in any way.
- *Do not violate UoL guidelines* (don’t post *illegal* materials, solutions to *graded quizzes* or big *chunks of code* related to any graded assignment).
- *Refer to specific modules, videos and quizzes by their number* (week and item numbers as shown in Coursera), so that it is easy for future users to look for answers. You'll find a #bugs channel to help you uncover if a bug you have encountered has been documented before: please post to that channel *only once a bug has been identified* as such in another channel.
- *Thank people* when they help you! :slightly_smiling_face: Despite the distance, we're still humans (most of us, anyways).

We hope you'll have a great time here! *_Remember that succeeding as a CS student has a lot to do with being able to find answers on your own and sharing them to cement your learning_* :bulb:.

Be well and *welcome* :slightly_smiling_face:!
```
