[Go back to the main page](../README.md)

# Table of contents

- [Table of contents](#table-of-contents)
- [Free Software](#free-software)
  - [Discounts](#discounts)
  - [Free access](#free-access)
    - [Mixed: Discounts & Free](#mixed-discounts--free)
  - [Free software](#free-software-1)
    - [2D animation](#2d-animation)
    - [3D animation](#3d-animation)
    - [3D prototyping](#3d-prototyping)
    - [Antivirus](#antivirus)
    - [Audio](#audio)
      - [Players](#players)
      - [Production](#production)
      - [Recording & Editing](#recording--editing)
    - [Automation](#automation)
      - [File management](#file-management)
      - [Services](#services)
      - [Time tracking](#time-tracking)
    - [Bug Tracker](#bug-tracker)
    - [Burning CDs/DVDs](#burning-cdsdvds)
    - [Clipboard manager](#clipboard-manager)
    - [Cloud IDE](#cloud-ide)
    - [Code snippets savers](#code-snippets-savers)
    - [Cross-platform compatibility](#cross-platform-compatibility)
    - [Data compression](#data-compression)
    - [Data converter](#data-converter)
    - [Data storage & syncronization](#data-storage--syncronization)
    - [Desktop publishing](#desktop-publishing)
    - [Documentation](#documentation)
    - [Ebook readers](#ebook-readers)
    - [Format checker & validator](#format-checker--validator)
    - [FTP](#ftp)
    - [Graphics software](#graphics-software)
    - [IDE (Integrated Development Environment)](#ide-integrated-development-environment)
    - [Image processing](#image-processing)
    - [LaTeX](#latex)
      - [Online editors](#online-editors)
      - [Plugins](#plugins)
      - [Distributions](#distributions)
      - [TeX editors](#tex-editors)
    - [Learning environment](#learning-environment)
    - [Mathematical tools](#mathematical-tools)
    - [Mind mapping](#mind-mapping)
    - [Office suite](#office-suite)
    - [Operating Systems](#operating-systems)
      - [Linux distributions](#linux-distributions)
        - [Beginner-friendly](#beginner-friendly)
    - [Password managers](#password-managers)
    - [PDF editors](#pdf-editors)
    - [PDF viewers](#pdf-viewers)
    - [Presentation sharing](#presentation-sharing)
    - [Productivity](#productivity)
      - [All-in-one organization](#all-in-one-organization)
      - [Conversations with teams](#conversations-with-teams)
      - [Emails](#emails)
      - [Habit tracker](#habit-tracker)
      - [Managing documents](#managing-documents)
      - [Note taking](#note-taking)
      - [Tasks and project management](#tasks-and-project-management)
      - [Writing assistant](#writing-assistant)
    - [Programming tools](#programming-tools)
      - [Python](#python)
        - [Data science](#data-science)
    - [RSS/Atom readers/aggregators - Keeping on top of news](#rssatom-readersaggregators---keeping-on-top-of-news)
    - [Screen recorders](#screen-recorders)
      - [Beginner friendly](#beginner-friendly-1)
      - [More advanced](#more-advanced)
    - [Screenshot tools](#screenshot-tools)
    - [System utilities](#system-utilities)
    - [Text editors](#text-editors)
      - [Beginner friendly](#beginner-friendly-2)
    - [Time trackers](#time-trackers)
    - [Touch typing](#touch-typing)
    - [UX/UI design](#uxui-design)
    - [Version control system](#version-control-system)
    - [Video communication](#video-communication)
    - [Video conversion](#video-conversion)
    - [Video edition](#video-edition)
    - [Video player](#video-player)
    - [Virtualization (running other operating system without installation)](#virtualization-running-other-operating-system-without-installation)
    - [VPN (unblock Coursera and other restricted content)](#vpn-unblock-coursera-and-other-restricted-content)
    - [Web browsers](#web-browsers)
      - [Especially useful for web development](#especially-useful-for-web-development)
      - [Extensions - Plugins](#extensions---plugins)
        - [Firefox](#firefox)
          - [Remove distractions](#remove-distractions)
        - [Google Chrome](#google-chrome)
          - [Remove distractions](#remove-distractions-1)

---

# Free Software

## Discounts

- [Spotify](https://www.spotify.com/student) - 50% off for students.

## Free access

- [JetBrains for students](https://www.jetbrains.com/student) - _"Free individual licenses for students and faculty members."_ Includes: AppCode, CLion, DataGrip, dotCover, dotMemory, dotTrace, GoLand, IntelliJ IDEA Ultimate, PhpStorm, PyCharm, ReSharper, ReSharper C++, Rider, RubyMine, WebStorm.

### Mixed: Discounts & Free

- [Student Developer Pack – GitHub Education](https://education.github.com/pack) - _"give students free access to the best developer tools in one place so they can learn by doing."_

---

## Free software

**Note:**

- [Open source software](https://en.wikipedia.org/wiki/Open-source_software) is denoted with a :star:.
- Tools that can be used online are denoted with a :cloud:.

[List of free and open-source software packages](https://en.wikipedia.org/wiki/List_of_free_and_open-source_software_packages). A few note-worthy options in the context of this degree are presented below.

---

### 2D animation

- :star: [OpenToonz](https://opentoonz.github.io/e)
- :star: [Pencil2D](https://www.pencil2d.org)
- :star: [Pivot animator](http://pivotanimator.net)
- :star: [Synfig Studio](https://www.synfig.org)
- :star: [TupiTube](https://www.maefloresta.com)

### 3D animation

- :star: [Blender](https://www.blender.org)

### 3D prototyping

- :star: [MakeHuman](http://www.makehumancommunity.org) - _"Makehuman is a free and open source 3D computer graphics software middleware designed for the prototyping of photo realistic humanoids."_ ([from Wikipedia](https://en.wikipedia.org/wiki/MakeHuman))

### Antivirus

- :star: [Clamav](https://www.clamav.net) (Windows, Linux, macOS, BSD, Solaris) - _"ClamAV® is an open source antivirus engine for detecting trojans, viruses, malware & other malicious threats."_ ([from Clamav](https://www.clamav.net))

### Audio

- :star: [Comparison of free software for audio](https://en.wikipedia.org/wiki/Comparison_of_free_software_for_audio)

#### Players

- :star: [Amarok](https://amarok.kde.org) (Windows, macOS, Linux)
- :star: [Clementine](https://www.clementine-player.org) (Windows, macOS, Linux)

#### Production

- :heavy*dollar_sign: [REAPER](https://www.reaper.fm) **(60 days free trial, US\$60 for personal license)** (Windows, macOS, Linux\*) - *"REAPER is a complete digital audio production application for computers, offering a full multitrack audio and MIDI recording, editing, processing, mixing and mastering toolset."\_ (\* experimental)

#### Recording & Editing

- :star: [Audacity](https://www.audacityteam.org) (Windows, macOS, Linux)

### Automation

#### File management

- [Organize](https://github.com/tfeldmann/organize) - _"Your desktop is a mess? You cannot find anything in your downloads and documents? Sorting and renaming all these files by hand is too tedious? Time to automate it once and benefit from it forever. `organize` is a command line, open-source alternative to apps like Hazel (macOS) or File Juggler (Windows)."_

#### Services

- [IFTTT](https://ifttt.com) - _"If This Then That, also known as IFTTT is a free web-based service to create chains of simple conditional statements, called applets."_ ([from Wikipedia](https://en.wikipedia.org/wiki/IFTTT))

#### Time tracking

- [ActivityWatch](https://github.com/ActivityWatch/activitywatch) - _"Records what you do so that you can know how you've spent your time. All in a secure way where you control the data."_

### Bug Tracker

- [MantisBT](https://www.mantisbt.org) - _"MantisBT is an open source issue tracker that provides a delicate balance between simplicity and power. Users are able to get started in minutes and start managing their projects while collaborating with their teammates and clients effectively."_

### Burning CDs/DVDs

- :star: [List of free software](https://en.wikipedia.org/wiki/Category:Free_optical_disc_authoring_software)

### Clipboard manager

- [Clip Clip](https://clipclip.com) (Windows) - _"ClipClip is free clipboard management software for Windows that will revolutionize the way you copy and paste. ClipClip makes it possible to copy multiple texts, images or files to your clipboard. You can then browse or search through these Latest Clips, or convert them to Saved Clips so you can assign a title and organize them into folders to use later on."_
- :star: [CopyQ](https://hluk.github.io/CopyQ) (Windows, macOS, Linux) - _"CopyQ is advanced clipboard manager with editing and scripting features. CopyQ monitors system clipboard and saves its content in customized tabs. Saved clipboard can be later copied and pasted directly into any application."_
- [Paste](https://setapp.com/apps/paste) (macOSOS) - _"Your Mac’s robust cloud clipboard manager and time-reliever."_

### Cloud IDE

- :heavy*dollar_sign: :cloud: [Codeanywhere](https://codeanywhere.com) - *"Share and collaborate on your code in real time. Whether you want to pair program, or just get some help from a friend. Codeanywhere makes it easy."\_

### Code snippets savers

- :cloud: [Gist](https://gist.github.com) (from GitHub) - _"Instantly share code, notes, and snippets."_
- :cloud: [Ideone](https://ideone.com) - _"Ideone is an online compiler and debugging tool which allows you to compile source code and execute it online in more than 60 programming languages."_

### Cross-platform compatibility

- :star: [Wine](https://www.winehq.org) - _"Wine (originally an acronym for "Wine Is Not an Emulator") is a compatibility layer capable of running Windows applications on several POSIX-compliant operating systems, such as Linux, macOS, & BSD."_ (Android, Linux, macOS)

### Data compression

- :star: [Free data compression software](https://en.wikipedia.org/wiki/Category:Free_data_compression_software)

### Data converter

- :cloud: [Mr. Data Converter](http://shancarter.github.io/mr-data-converter) - _"I will convert your Excel data into one of several web-friendly formats, including HTML, JSON and XML."_

### Data storage & syncronization

- :cloud: [Dropbox](https://www.dropbox.com) (Windows, macOS, Linux) - **2GB Free**. _"Dropbox is a file hosting service operated by the American company Dropbox, Inc., headquartered in San Francisco, California, that offers cloud storage, file synchronization, personal cloud, and client software."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Dropbox_%28service%29)
- :cloud: [Google Drive](https://www.google.com/drive) (Windows, macOS, officially) - **15GB Free**. _"Google Drive is a file storage and synchronization service developed by Google. [...] Google Drive allows users to store files on their servers, synchronize files across devices, and share files."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Google_Drive))
- :cloud: [pCloud](https://www.pcloud.com) (Windows, macOS, Linux) - **10GB Free**. _"pCloud is the secure cloud storage, where you can store, share and work on all your files. You can access them on any device, anywhere you go!"_
- :star: [Syncthing](https://syncthing.net) - (Windows, macOS, Linux, FreeBSD, Solaris, OpenBSD) - _"Syncthing is a continuous file synchronization program. It synchronizes files between two or more computers and replaces proprietary sync and cloud services with something open, trustworthy and decentralized. Your data is your data alone and you deserve to choose where it is stored, if it is shared with some third party and how it's transmitted over the internet."_

### Desktop publishing

- :star: [Scribus](https://www.scribus.net) (Windows, macOS, Linux) - _One of the premier Open Source desktop applications._

### Documentation

- :star: [Sphinx](http://www.sphinx-doc.org) (Windows, macOS, Linux) - _"Sphinx is a tool that makes it easy to create intelligent and beautiful documentation, written by Georg Brandl and licensed under the BSD license. It was originally created for the Python documentation, and it has excellent facilities for the documentation of software projects in a range of languages."_

### Ebook readers

- :star: [Calibre](https://calibre-ebook.com) (Windows, macOS, Linux)
- [Kindle](https://www.amazon.com/kindle-dbs/fd/kcp) (Windows, macOS, Android, iOS, Linux - installed by Wine)
- :cloud: [Kindle Cloud Reader](https://read.amazon.com) (Windows, macOS, Linux)

### Format checker & validator

- :cloud: [JSONLint](https://jsonlint.com) - _"JSONLint is a validator and reformatter for JSON, a lightweight data-interchange format. Copy and paste, directly type, or input a URL in the editor above and let JSONLint tidy and validate your messy JSON code."_

### FTP

- :cloud: [net2ftp](http://net2ftp.com) - _"net2ftp is a web based FTP client. It is mainly aimed at managing websites using a browser."_

### Graphics software

- :star: [List of free graphics software](https://en.wikipedia.org/wiki/Category:Free_graphics_software)
- Graphic art & Office suite
  - :star: [Calligra](https://www.calligra.org)
  - :cloud: :star: [draw.io](https://www.draw.io) (Linux, macOS, Windows, Browser, ChromeOS) - _"Create flow charts, process diagrams, org charts, UML diagrams, ER models, network diagrams, and much more."_ (from [draw.io](https://www.draw.io))

### IDE (Integrated Development Environment)

- [Comparison of integrated development environments](https://en.wikipedia.org/wiki/Comparison_of_integrated_development_environments)
- :star: [Eclipse](https://eclipse.org) - C, C++, Java, Perl, PHP, Python, Ruby and more. (Windows, macOS, Linux)
- [IntelliJ IDEA](https://www.jetbrains.com/idea) - AngularJS, CoffeeScript, CS, HTML, JavaScript, LESS, Node JS, PHP, Python, Ruby, Sass, TypeScript and more. (Windows, macOS, Linux)
- :star: [Netbeans](https://netbeans.org) - C, C++, C++11, Fortan, HTML 5, Java, PHP and more. (Works with Java)
- [PyCharm](https://www.jetbrains.com/pycharm) - Python. (Windows, macOS, Linux)
- :star: [Visual Studio Code](https://code.visualstudio.com) - C, C#, CSS, D, F#, Go, Java, JavaScript, Lua, Markdown, PHP, Python, R, Ruby, SQL, Swift, TypeScript and more. (Windows, macOS, Linux)
- [Visual Studio Community](https://visualstudio.microsoft.com/vs/community) - C#, Visual Basic, F#, C++, HTML, JavaScript, TypeScript, Python, and more. (Windows, macOS)

### Image processing

- :star: [GIMP](https://www.gimp.org) – Free equivalent to Photoshop
- :star: [Inkscape](https://inkscape.org) – Vector graphics editor
- :star: [Krita](https://krita.org/en) – Digital painting and sketching application

### LaTeX

#### Online editors

- :cloud: [Overleaf](https://www.overleaf.com) - _"The easy to use, online, collaborative LaTeX editor."_

#### Plugins

- [Vimtex](https://github.com/lervag/vimtex) - _"A modern vim plugin for editing LaTeX files."_

#### Distributions

- [TexLive](https://tug.org/texlive) - _"A free software distribution for the TeX typesetting system."_

#### TeX editors

- :star: [Kile](https://kile.sourceforge.io) (Windows, macOS, Linux) - _"Kile is a TeX/LaTeX editor to edit TeX/LaTeX source code. It runs on Unix-like systems including Mac OS X and Linux, as well as Microsoft Windows via the KDE on Windows initiative, with the Qt and KDE libraries installed."_
- :star: [LyX](https://www.lyx.org) (Windows, macOS, Linux) - _"LyX is an open source document processor based on the LaTeX typesetting system."_ ([from Wikipedia](https://en.wikipedia.org/wiki/LyX))
- :star: [Texmaker](http://www.xm1math.net/texmaker) (Windows, macOS, Linux) - _"Texmaker is a cross-platform open-source LaTeX editor with an integrated PDF viewer."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Texmaker))
- :star: [TeXstudio](https://www.texstudio.org) - _"TeXstudio is a cross-platform open-source LaTeX editor. Its features include an interactive spelling checker, code folding, and syntax highlighting."_ ([from Wikipedia](https://en.wikipedia.org/wiki/TeXstudio))

### Learning environment

- :cloud: [GoConqr](https://www.goconqr.com) - _"GoConqr is a personal learning environment that allows students & teachers to create, discover and share learning resources. Goconqr includes study tools to create Mind Maps, Flashcards, Notes and Quizzes."_

### Mathematical tools

- :star: [Free plotting software](https://en.wikipedia.org/wiki/Category:Free_plotting_software)
- :star: [Free statistical software](https://en.wikipedia.org/wiki/Category:Free_statistical_software)
- :star: [GeoGebra](https://www.geogebra.org/?lang=en) - Graphing, geometry, 3D, and more
- :star: [SciPy](https://www.scipy.org) - Library used for scientific computing and technical computing

### Mind mapping

- [Coggle](https://coggle.it) (Web-based) - _"Coggle is an online tool for creating and sharing mindmaps and flow charts. It works online in your browser: there's nothing to download or install. Whether you're taking notes, brainstorming, planning, or doing something awesomely creative, it is super simple to visualise your ideas with Coggle. Share with as many friends or colleagues as you like. Changes you make will show up instantly in their browser, wherever they are in the world."_
- :cloud: :star: [draw.io](https://www.draw.io) (Linux, macOS, Windows, Browser, ChromeOS) - Best for flowcharts. _"Create flow charts, process diagrams, org charts, UML diagrams, ER models, network diagrams, and much more."_ (from [draw.io](https://www.draw.io))
- :star: [Freeplane](https://www.freeplane.org/) (Windows, macOS, Linux) - _"Freeplane is a free and open source software application that supports thinking, sharing information and getting things done at work, in school and at home."_
- :cloud: [MindMeister](https://www.mindmeister.com) (Web, Android, iOS) - "MindMeister is an online mind mapping tool that lets you capture, develop and share ideas visually. MindMeister is completely web-based, which means there's no download and no updating! Whether you're working on Windows, Mac OS or Linux, you can always access your mind maps right inside the web-browser."
- [MindMup](https://www.mindmup.com) (Web-based) - _"Powerful keyboard shortcuts speed up your work. Frictionless interface helps you focus. Convert maps easily to PDF, PowerPoint, outlines... Publish and share maps online Easily save to Google Drive and manage using Google Apps."_

### Office suite

- :star: [LibreOffice](https://www.libreoffice.org) (Windows, macOS, Linux)
- :cloud: [Google Docs](https://www.google.com/docs/about) (Windows, macOS, Linux)
- [WPS Office](https://www.wps.com/office-free) (Windows, Linux, Android, iOS)

### Operating Systems

- [FreeBSD](https://www.freebsd.org) - _"FreeBSD is a free and open-source Unix-like operating system descended from the Berkeley Software Distribution, which was based on Research Unix. The first version of FreeBSD was released in 1993."_ ([from Wikipedia](https://en.wikipedia.org/wiki/FreeBSD))
- [Linux](https://www.linux.org) - _"Linux is a family of free and open-source software operating systems based on the Linux kernel, an operating system kernel first released on September 17, 1991 by Linus Torvalds. Linux is typically packaged in a Linux distribution."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Linux))
- [macOS](https://www.apple.com/lae/macos/mojave) - _"It is the primary operating system for Apple's Mac family of computers. Within the market of desktop, laptop and home computers, and by web usage, it is the second most widely used desktop OS, after Microsoft Windows."_ ([from Wikipedia](https://en.wikipedia.org/wiki/MacOS))
- [Windows](https://www.microsoft.com/en-us/windows) - _"Microsoft Windows is a group of several graphical operating system families, all of which are developed, marketed, and sold by Microsoft. Each family caters to a certain sector of the computing industry."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Microsoft_Windows))

#### Linux distributions

- [DistroWatch](https://distrowatch.com) - _"DistroWatch is a website which provides news, popularity rankings, and other general information about various Linux distributions as well as other free software/open source Unix-like operating systems such as OpenSolaris, MINIX and BSD. It now contains information on several hundred distributions."_ ([from Wikipedia](https://en.wikipedia.org/wiki/DistroWatch))

##### Beginner-friendly

- :star: [Fedora](https://getfedora.org/en/workstation) - A more developer centric distribution based on Red Hat Enterprise Linux (RHEL) ecosystem.
- :star: [Linux Mint](https://linuxmint.com) - _"Linux Mint is a community-driven Linux distribution based on Debian and Ubuntu that strives to be a "modern, elegant and comfortable operating system which is both powerful and easy to use.""_ ([from Wikipedia](https://en.wikipedia.org/wiki/Linux_Mint)
- :star: [Ubuntu](https://www.ubuntu.com/download/desktop) - A beginner-friendly distribution based on Debian.

### Password managers

- Beginner friendly
  - [Dashlane](https://www.dashlane.com) (Windows, macOS, Linux, Chromebook)
  - :star: [KeePass](https://keepass.info) (Windows, macOS, BSD)
  - :star: [KeePassXC](https://keepassxc.org) (Windows, macOS, Linux)
  - :star: [Firefox Lockwise](https://lockwise.firefox.com) (Browser extension, Android, iOS) - _"Firefox Lockwise is an experimental product from Mozilla, the makers of Firefox. It’s an app for iOS and Android that gives you access to passwords you’ve saved to Firefox."_
  - [LastPass](https://www.lastpass.com) (Windows, macOS, Linux, Chromebook)
- More advanced
  - :star: [gopass](https://www.gopass.pw) (Windows, macOS, Linux)
  - :star: [pass](https://www.passwordstore.org) (Windows, macOS, Linux, Android, iOS)

### PDF editors

- :star: [LibreOffice Draw](https://www.libreoffice.org/discover/draw) (Windows, macOS, Linux)
- :star: [Inkscape](https://inkscape.org) (Windows, macOS, Linux)
- Limited to split, merge, rotate, mix and extract
  - [Master PDF](https://code-industry.net/free-pdf-editor) (Windows, macOS, Linux)
  - :star: [PDF Shuffler](https://sourceforge.net/p/pdfshuffler/wiki/Home) (Linux)
  - [PDFSAM Basic](https://pdfsam.org/download-pdfsam-basic) (Windows, macOS, Linux)
- Online
  - [PDF2GO](https://www.pdf2go.com) - Easy to use.
  - [PDFEscape](https://www.pdfescape.com) - Intuitive. Limited to 10MB filesize.
  - [Sejda](https://www.sejda.com/pdf-editor) - Slow. Good for basic editing

### PDF viewers

- :star: Firefox, Google Chrome, :star: Chromium - Built-in viewer (Windows, macOS, Linux)
- [Foxit Reader](https://www.foxitsoftware.com/pdf-reader) (Windows, macOS, Linux)
- [PDF Reader – PDF Viewer & Epub, Ebook reader](https://play.google.com/store/apps/details?id=com.officetool.pdfreader2018.pdfviewer) (Android)
- [PDF Viewer Pro](https://itunes.apple.com/us/app/pdf-viewer-pro-by-pspdfkit/id1120099014) (iOS)
- As secondary feature
  - :star: [GIMP](https://www.gimp.org) (Windows, macOS, Linux)
  - :star: [Inkscape](https://inkscape.org) (Windows, macOS, Linux)
  - :star: [Scribus](https://www.scribus.net) (Windows, macOS, Linux)
- Linux
  - :star: [Evince](https://wiki.gnome.org/Apps/Evince) (GNOME)
  - :star: [Okular](https://okular.kde.org) (KDE)
  - :star: [CUPS](https://www.cups.org)

### Presentation sharing

- [SlideShare](https://www.slideshare.net) - _"Share what you know and love through presentations, infographics, documents and more."_

### Productivity

#### All-in-one organization

- :heavy*dollar_sign: [Notion](https://www.notion.so) ([Personal plan free for students](https://www.notion.so/students)) (Windows, macOS, Android, iOS, web) - **Free version currently limited to 1000 block storage and 5MB upload limit.** - *"Write, plan, collaborate, and get organized. Notion is all you need — in one tool."\_

#### Conversations with teams

- [Microsoft Teams](https://teams.microsoft.com) - _"Microsoft Teams is a unified communication and collaboration platform that combines persistent workplace chat, video meetings, file storage, and application integration."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Microsoft_Teams))
- [Slack](https://slack.com) - _"Slack is a cloud-based proprietary instant messaging platform developed by Slack Technologies."_ ([from Wikipedia](<https://en.wikipedia.org/wiki/Slack_(software)>))
- [Twist](https://twist.com) - _"Imagine a distraction-free teamwork app. Where conversations stay organized and on-topic. And where information is easy to find, forever. That’s Twist."_

#### Emails

- :heavy*dollar_sign: [Front](https://frontapp.com) - *"Front is the first inbox for teams. Organize all your conversations in one place, route them to the right people, and get more done as a team."\_

#### Habit tracker

- [Habitica](https://habitica.com) - _"Habitica is a free habit and productivity app that treats your real life like a game. Habitica can help you achieve your goals to become healthy and happy."_
- [Habitify](https://habitify.me) (macOS, Android, iOS, web) - _"Track your habits, discover weak spots & improve them to achieve your goals."_

#### Managing documents

- :cloud: [Google Docs](https://www.google.com/docs/about) - _Web-based app designed to store, create, and edit spreadsheets and documents online._

#### Note taking

- :cloud: [Evernote](https://evernote.com) - _"Evernote is a mobile app designed for note taking, organizing, task lists, and archiving._" ([from Wikipedia](https://en.wikipedia.org/wiki/Evernote))
- :star: [Joplin](https://github.com/laurent22/joplin) (Windows, Linux, macOS, Android, iOS) - _"Joplin is a free, open source note taking and to-do application, which can handle a large number of notes organised into notebooks."_ (from [Joplin Github](https://github.com/laurent22/joplin))
- [OneNote](https://www.onenote.com) (Windows, macOS, Android, iOS, web) - _"Microsoft OneNote is a program for free-form information gathering and multi-user collaboration. It gathers users' notes, drawings, screen clippings and audio commentaries. Notes can be shared with other OneNote users over the Internet or a network."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Microsoft_OneNote)
- :star: :cloud: [Simplenote](https://simplenote.com) (Windows, macOS, Linux, Android, iOS, web) - _The simplest way to keep notes. Light, clean, and free._
- [Typora](https://www.typora.io) (Windows, macOS, Linux) - _"Typora is a minimal markdown editor, providing new ways for reading and writing markdown. It is currently in beta. Typora is commercial software (not open source), but is free during beta."_
- [Vimwiki](https://github.com/vimwiki/vimwiki) (Windows, macOS, Linux) - _"VimWiki is a personal wiki for Vim -- a number of linked text files that have their own syntax highlighting. With VimWiki you can: organize notes and ideas; manage to-do lists; write documentation; maintain a diary; export everything to HTML."_

#### Tasks and project management

- :cloud: [Asana](https://asana.com) - _Asana is the work management platform teams use to stay focused on the goals, projects, and daily tasks that grow business._
- :cloud: [Basecamp](https://basecamp.com) - Currently [free when applying as a student](https://basecamp.com/discounts) - _"Before Basecamp: Projects feel scattered, things slip, it’s tough to see where things stand, and people are stressed. After Basecamp: Everything’s organized in one place, you’re on top of things, progress is clear, and a sense of calm sets in."_
- :cloud: [ClickUp](https://clickup.com) - _The productivity platform. Create. Plan. Organize. Everything._
- :cloud: [Google Keep](https://keep.google.com) - _Keep offers a variety of tools for taking notes, including text, lists, images, and audio._
- :cloud: [meistertask](https://www.meistertask.com) - _The most intuitive project and task management tool on the web._
- :cloud: [Pearltrees](https://www.pearltrees.com) - _"Pearltrees refers to itself as "a place for your interests". Functionally the product is a visual and collaborative curation tool that allows users to organize, explore and share any URL they find online as well as to upload personal photos, files and notes."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Pearltrees)
- :cloud: [Pocket](https://getpocket.com) - _"Pocket, previously known as Read It Later, is an application and web service for managing a reading list of articles from the Internet."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Pocket_%28service%29))
- :cloud: [TickTick](https://ticktick.com) - _Capture ideas, organize to-dos, and make the most of your life._
- :star: [Todo.txt](http://todotxt.org) - (_operating system agnostic_, Android, iOS, CLI) _"If you have a file called todo.txt on your computer right now, you're in the right place. So many power users try dozens of complicated todo list software applications, only to go right back to their trusty todo.txt file."_
- :cloud: [Todoist](https://todoist.com) - _Todoist lets you keep track of everything in one place, so you can get it all done and enjoy more peace of mind along the way._
- :cloud: [Trello](https://trello.com/en) - _Trello's boards, lists, and cards enable you to organize and prioritize your projects in a fun, flexible, and rewarding way._
- :cloud: [Wunderlist](https://www.wunderlist.com) - _"Whether you’re planning a holiday, sharing a shopping list with a partner or managing multiple work projects, Wunderlist is here to help you tick off all your personal and professional to-dos."_

#### Writing assistant

- :cloud: [Grammarly](https://www.grammarly.com) - _From grammar and spelling to style and tone, Grammarly helps you eliminate errors and find the perfect words to express yourself._
- :star: [UMLet](https://www.umlet.com) - _UMLet is a UML tool aimed at providing a fast way of creating UML diagrams. UML elements are modified using text input instead of pop-up dialogs._
- :star: :cloud: [UMLetino](http://www.umletino.com) - _UMLetino 14.3 is a free online UML tool for fast UML diagrams. It runs in your browser, and does not require any installs._

### Programming tools

#### Python

##### Data science

- [Anaconda distribution](https://www.anaconda.com) (Windows, macOS, Linux) - _The World's Most Popular Python Data Science Distribution_

### RSS/Atom readers/aggregators - Keeping on top of news

- :star: [List of free readers](https://en.wikipedia.org/wiki/List_of_free_and_open-source_software_packages#RSS/Atom_readers/aggregators)
- :cloud: [Feedly](https://feedly.com)
- :cloud: [Feedreader Online](https://feedreader.com)
- :cloud: [Flipboard](https://flipboard.com)

### Screen recorders

#### Beginner friendly

- :cloud: [Apowersoft Free Online Screen Recorder](https://www.apowersoft.com/free-online-screen-recorder) (Windows, Android, iOS)
- [AZ Screen Recorder](https://play.google.com/store/apps/details?id=com.hecorat.screenrecorder.free&hl=en) (Android)
- :star: [GNOME Screenshots](https://help.gnome.org/users/gnome-help/stable/screen-shot-record.html.en) (Linux)
- [Go Record: Screen Recorder](https://itunes.apple.com/us/app/go-record-screen-recorder/id1345200849) (iOS)
- [Screencast o matic](https://screencast-o-matic.com/screen-recorder) (Windows, macOS, Chromebook)
- :star: [Simple Screen Recorder](https://www.maartenbaert.be/simplescreenrecorder) (Linux)

#### More advanced

- :star: [ffmpeg](https://ffmpeg.org) (Windows, macOS, Linux)
- :star: [OBS Studio](https://obsproject.com) (Windows, macOS, Linux)

### Screenshot tools

- :star: [Flameshot](https://flameshot.js.org) (Linux)
- :star: [GNOME Screenshots](https://help.gnome.org/users/gnome-help/stable/screen-shot-record.html.en) (Linux)
- [Screenshot](https://support.apple.com/en-us/HT201361) (macOS)
- [Snipping Tool](https://support.microsoft.com/en-us/help/13776/windows-10-use-snipping-tool-to-capture-screenshots) (Windows)
- :star: [Spectacle (KDE)](https://kde.org/applications/utilities/org.kde.spectacle) (Linux)

### System utilities

- :star: [Redshift](http://jonls.dk/redshift) (Linux) - _Adjusts the color temperature of your screen according to your surroundings._
- :star: [f.lux](https://justgetflux.com) (Windows, macOS, Linux, iOS, Android) - _It makes the color of your computer's display adapt to the time of day, warm at night and like sunlight during the day._

### Text editors

- [Comparison of text editors](https://en.wikipedia.org/wiki/Comparison_of_text_editors)

#### Beginner friendly

- :star: [Atom](https://atom.io)
- :star: [Brackets](http://brackets.io) - Used in module [Introduction to Programming I](../modules/level_4/introduction_to_programming_i).
- :star: [Visual Studio Code](https://code.visualstudio.com)

### Time trackers

- [Clockify](https://clockify.me) - (Web, Chrome, Firefox, Windows, macOS, Linux, iOS, Android, Integrations) - _"Clockify is the only truly free time tracking software. It's a simple time tracker and timesheet app that lets you and your team track work hours across projects. Unlimited users, free forever."_
- [RescueTime](https://www.rescuetime.com) - _"RescueTime helps you understand where your time goes each day. Optimize your energy. And take back control of your day."_
- [Timeular](https://timeular.com) - (Windows, macOS, iOS, Android) - **Uses physical device connected through Bluetooth.** - _"Easily track your time at work, get insights into where you spend it and increase your productivity. Start using Timeular as your time tracking tool today."_
- [Toggl](https://toggl.com) - (Chrome, iOS, Android, Windows, macOS, Linux) - _"Toggl makes time tracking so simple you’ll actually use it. But even if you forget, our tracking reminders and idle detection have your back."_
- [WakaTime](https://wakatime.com) - _"The open source plugin for productivity metrics, goals, leaderboards, and automatic time tracking."_

### Touch typing

- [Typing.com](https://www.typing.com) - Learn to type for free without looking at your keyboard.

### UX/UI design

See also [Graphics software](#graphics-software).

- [Adobe XD](https://www.adobe.com/products/xd.html) - _"Wireframe, design, prototype, present, and share amazing experiences for web, mobile, voice, and more — all in one app. XD is made for designers, creative teams, and organizations that need to design at scale. It’s everything you need to work more efficiently, collaborate effortlessly, and create and manage your design system."_
- :heavy*dollar_sign: [Balsamiq](https://balsamiq.com) - *"With Balsamiq Wireframes, anyone can design great user interfaces."\_
- :cloud: [Figma](https://www.figma.com) - _"A better way to design. Design, prototype, and gather feedback all in one place."_ **(free for individuals, with limitations)**

### Version control system

- [Free version control software](https://en.wikipedia.org/wiki/Category:Free_version_control_software)
- :star: [Git](https://git-scm.com) - _"Git is a distributed version-control system for tracking changes in source code during software development. It is designed for coordinating work among programmers, but it can be used to track changes in any set of files."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Git))
- [Perforce (Helix Core)](https://www.perforce.com) - _"[...] software used for application development, including version control software, web-based repository management, developer collaboration, application lifecycle management and Agile planning software."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Perforce))

### Video communication

- [Appear.in](https://appear.in) - _"Easy video meetings for your business."_
- [Facebook Live](https://live.fb.com) - _"A fun, powerful way to connect with your followers and create new ones along the way._"
- [Google Hangouts](http://www.google.com/hangouts) - _"Google Hangouts is a communication platform developed by Google which includes messaging, video chat, and VOIP features."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Google_Hangouts)
- [Skype](https://www.skype.com) - _"[...] specializes in providing video chat and voice calls between computers, tablets, mobile devices, the Xbox One console, and smartwatches via the Internet. Skype also provides instant messaging services. Users may transmit text, video, audio and images. Skype allows video conference calls."_ [(from Wikipedia)](https://en.wikipedia.org/wiki/Skype)
- [Slack calls](https://slack.com) - _"With Slack Calls, you can make a voice or video call with any member of your workspace."_
- [Zoom](https://zoom.us) - _"[...] remote conferencing services using cloud computing. Zoom offers communications software that combines video conferencing, online meetings, chat, and mobile collaboration."_ [(from Wikipedia)](https://en.wikipedia.org/wiki/Zoom_Video_Communications)

### Video conversion

- [Free video conversion software](https://en.wikipedia.org/wiki/Category:Free_video_conversion_software)

### Video edition

- [List of video editing software](https://en.wikipedia.org/wiki/List_of_video_editing_software)

### Video player

- [Comparison of video player software](https://en.wikipedia.org/wiki/Comparison_of_video_player_software)
- :star: [Media Player Classic](https://mpc-hc.org) (Windows)
- :star: [mpv](https://mpv.io) (Windows, macOS, Linux)
- :star: [SMPlayer](https://www.smplayer.info) (Windows, Linux)
- :star: [VLC](https://www.videolan.org/vlc) (Windows, macOS, Linux)

### Virtualization (running other operating system without installation)

- [Free virtualization software](https://en.wikipedia.org/wiki/Category:Free_virtualization_software)
- :star: [VirtualBox](https://www.virtualbox.org)

### VPN (unblock Coursera and other restricted content)

- [NordVPN](https://nordvpn.com) (Windows, macOS, Linux, Android, iOS, Chrome, Firefox, Android TV) - _"NordVPN is a personal virtual private network (VPN) service provider. It has desktop applications for Windows, macOS, and Linux, mobile apps for Android and iOS, as well as an application for Android TV. Manual setup is available for wireless routers, NAS devices and other platforms. NordVPN is based in Panama, as the country has no mandatory data retention laws."_ ([from Wikipedia](https://en.wikipedia.org/wiki/NordVPN))
- [ProtonVPN](https://protonvpn.com) - (Windows, macOS, Linux, Android, iOS) _"ProtonVPN is a virtual private network (VPN) service provider operated by the Swiss company ProtonVPN AG, the company behind the email service ProtonMail."_ ([from Wikipedia](https://en.wikipedia.org/wiki/ProtonVPN))
- [Surfshark](https://surfshark.com) (Windows, macOS, Linux, Android, iOS, Chrome, Firefox, etc.) - _"Surfshark is an award-winning, secure VPN that encrypts your online data to help you stay private & protected every day, hassle-free."_

### Web browsers

- :star: [List of free web browsers](https://en.wikipedia.org/wiki/List_of_free_and_open-source_software_packages#Web_browsers)
- [Vivaldi](https://vivaldi.com) - _"Vivaldi is a new browser with unrivaled customization and control. Fast, secure and flexible – this is a browser made for you."_

#### Especially useful for web development

- :star: [Firefox](https://www.mozilla.org/en-US/firefox/new) (works on all major operating systems)
- [Google Chrome](https://www.google.com/chrome) (works on all major operating systems)
- [Microsoft Edge](https://www.microsoft.com/en-us/windows/microsoft-edge) (**Windows** preferred)
- [Safari](<https://en.wikipedia.org/wiki/Safari_(web_browser)>) (**macOS** preferred)

#### Extensions - Plugins

##### Firefox

###### Remove distractions

- [LeechBlock NG](https://addons.mozilla.org/en-US/firefox/addon/leechblock-ng) - _"LeechBlock NG is a simple productivity tool designed to block those time-wasting sites that can suck the life out of your working day. All you need to do is specify which sites to block and when to block them."_

##### Google Chrome

###### Remove distractions

- [StayFocusd](https://chrome.google.com/webstore/detail/stayfocusd/laankejkbhbdhmipfmgcngdelahlfoji) - _"StayFocusd increases your productivity by limiting the amount of time that you can spend on time-wasting websites."_
