[Go back to the main page](../README.md)

# Websites

- [Websites](#websites)
- [Artificial intelligence](#artificial-intelligence)
  - [Machine learning](#machine-learning)
- [Career](#career)
  - [Advice](#advice)
  - [Resume building](#resume-building)
- [Computer science](#computer-science)
  - [Algorithms](#algorithms)
    - [Visualizations](#visualizations)
  - [Articles](#articles)
  - [Computational complexity](#computational-complexity)
  - [Courses and videos](#courses-and-videos)
  - [Free (e)books](#free-ebooks)
- [Data science](#data-science)
  - [Jupyter](#jupyter)
  - [Pandas](#pandas)
  - [Working with data (Pandas, NumPy, Matplotlib, IPython, Scikit-Learn...)](#working-with-data-pandas-numpy-matplotlib-ipython-scikit-learn)
- [Free e-books and video courses](#free-e-books-and-video-courses)
- [Hacking](#hacking)
- [LaTeX](#latex)
- [Linux & Unix](#linux--unix)
- [Mathematics](#mathematics)
  - [Beginner topics](#beginner-topics)
  - [Calculus](#calculus)
    - [Derivatives](#derivatives)
  - [Discrete mathematics](#discrete-mathematics)
    - [Algorithms](#algorithms-1)
      - [Hopcroft-Karp](#hopcroft-karp)
    - [Binomial theorem](#binomial-theorem)
    - [Graph theory](#graph-theory)
    - [Rules of inference - logic proofs](#rules-of-inference---logic-proofs)
  - [Encryption](#encryption)
  - [Limits](#limits)
  - [Linear Algebra](#linear-algebra)
  - [Machine learning](#machine-learning-1)
  - [Modular arithmetic](#modular-arithmetic)
  - [Number bases](#number-bases)
  - [Online tools](#online-tools)
  - [Statistics](#statistics)
  - [Trigonometry](#trigonometry)
- [Music (ideal for programming)](#music-ideal-for-programming)
- [Online services](#online-services)
  - [Clean your inbox](#clean-your-inbox)
  - [Diff checker (compare different files)](#diff-checker-compare-different-files)
  - [Disposable/temporary emails](#disposabletemporary-emails)
  - [File sharing & storage](#file-sharing--storage)
  - [Gantt charts](#gantt-charts)
  - [Image hosting](#image-hosting)
  - [Manage your privacy](#manage-your-privacy)
  - [Receive SMS](#receive-sms)
- [Open source](#open-source)
- [Programming](#programming)
  - [App monitoring](#app-monitoring)
  - [Basics](#basics)
  - [Books](#books)
  - [Coding challenges](#coding-challenges)
  - [Documentation](#documentation)
  - [Interview preparation](#interview-preparation)
    - [Books](#books-1)
    - [Facebook](#facebook)
    - [Google](#google)
    - [Microsoft](#microsoft)
  - [Games](#games)
    - [CSS](#css)
    - [JavaScript](#javascript)
    - [Projects and ideas](#projects-and-ideas)
    - [Python](#python)
    - [Security](#security)
    - [Service workers](#service-workers)
  - [Git / GitHub](#git--github)
  - [iOS](#ios)
    - [Swift](#swift)
  - [JavaScript](#javascript-1)
  - [Julia](#julia)
  - [Python](#python-1)
  - [Questions and answers](#questions-and-answers)
  - [Regular expressions (regex)](#regular-expressions-regex)
  - [SQL](#sql)
  - [TypeScript](#typescript)
- [Startups](#startups)
- [Technology](#technology)
- [Typing faster](#typing-faster)
- [Variety](#variety)
- [Web](#web)
  - [Buying a domain name](#buying-a-domain-name)
  - [Cloud Computing](#cloud-computing)
  - [Information on websites](#information-on-websites)
  - [Website annotation](#website-annotation)
  - [Website testing](#website-testing)
- [Web development](#web-development)
  - [Learning](#learning)
  - [Tools](#tools)

# Artificial intelligence

## Machine learning

- [ML Cheatsheet](https://ml-cheatsheet.readthedocs.io/en/latest/calculus.html) - _"Brief visual explanations of machine learning concepts with diagrams, code examples and links to resources for learning more."_
- [Machine Learning Crash Course with TensorFlow APIs](https://developers.google.com/machine-learning/crash-course) - Google. - _"Google's fast-paced, practical introduction to machine learning."_
- [Machine Learning: 2014-2015](https://www.cs.ox.ac.uk/people/nando.defreitas/machinelearning) - University of Oxford

# Career

## Advice

- [TopResume](https://www.topresume.com/career-advice). _"Job-search tips and expert advice to help you get ahead in your career."_

## Resume building

- [Kickresume](https://www.kickresume.com) - _" We help students take first steps towards a successful career. Kickresume Premium is now free for all students. Verify your student status with ISIC, ITIC or EURO>26."_

# Computer science

- [Computer Science 162, 001 - Fall 2013](https://archive.org/details/ucberkeley-webcast-PL-XXv-cvA_iDrt_oPWfQ4-fjHm2KSSOPq) - UC Berkeley
- [Computer Science 188, 001 - Spring 2015](https://archive.org/details/ucberkeley-webcast-PL-XXv-cvA_iA4YSaTMfF_K_wvrKAY2H8u) - UC Berkeley
- [Computer Science 194, 024 - Spring 2013](https://archive.org/details/ucberkeley-webcast-PL-XXv-cvA_iB_5Q8G8kW5idSwNmXypmQE) - UC Berkeley
- [Computer Science 61B, 001 - Fall 2014](https://archive.org/details/ucberkeley-webcast-PL-XXv-cvA_iDVox3OKFhF4LxMHqpi2GS2) - UC Berkeley
- [Four Semesters of Computer Science in Six Hours (part 2)](https://btholt.github.io/four-semesters-of-cs-part-two/) - Brian Holt.
- [Four Semesters of Computer Science in Six Hours](https://btholt.github.io/four-semesters-of-cs/) - Brian Holt.
- [Open Source Society University](https://github.com/ossu/computer-science) - _"The OSSU curriculum is a complete education in computer science using online materials."_
- [Teach Yourself Computer Science](https://teachyourselfcs.com) - _"Study all nine subjects below, in roughly the presented order, using either the suggested textbook or video lecture series, but ideally both. Aim for 100-200 hours of study of each topic, then revisit favorites throughout your career."_
- [The Missing Semester of Your CS Education](https://missing.csail.mit.edu/) - _"Classes teach you all about advanced topics within CS, from operating systems to machine learning, but there’s one critical subject that’s rarely covered, and is instead left to students to figure out on their own: proficiency with their tools."_
- [Understanding Computers and the Internet](http://computerscience1.tv/2011/spring) - Harvard Extension School. About hardware, Internet, multimedia, security, website development, programming.

## Algorithms

- [Algorithms in the "Real World" (2018)](http://www.cs.cmu.edu/~guyb/realworld.html) - Compression, error correcting codes, cryptography, parallel algorithms, locality and I/O efficient algorithms, indexing and searching, nearest neighbors, dimensionality reduction.
- [Comparison of Algorithms](https://en.wikipedia.org/wiki/Sorting_algorithm#Comparison_of_algorithms) - See time complexity at a glance for various popular algorithms.
- [Dictionary of Algorithms and Data Structures](https://xlinux.nist.gov/dads) - _"This is a dictionary of algorithms, algorithmic techniques, data structures, archetypal problems, and related definitions."_
- [Introduction to algorithms](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-006-introduction-to-algorithms-fall-2011/) ([problem sets](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-006-introduction-to-algorithms-fall-2011/assignments/)) - MIT OpenCourseWare.
- [Khan Academy - Algorithms](https://www.khanacademy.org/computing/computer-science/algorithms/) - _"We've partnered with Dartmouth college professors Tom Cormen and Devin Balkcom to teach introductory computer science algorithms, including searching, sorting, recursion, and graph theory. Learn with a combination of articles, visualizations, quizzes, and coding challenges."_
- [Skiena's Algorithms Lectures](https://www3.cs.stonybrook.edu/~algorith/video-lectures/)

### Visualizations

- [HackerEarth](https://www.hackerearth.com/practice/algorithms/sorting/bubble-sort/visualize/) - Visualize sorting algorithms, step by step.
- [VisuAlgo](https://visualgo.net/en) - Visualising data structures and algorithms through animation.

## Articles

- [Famous Laws Of Software Development](https://www.timsommer.be/famous-laws-of-software-development/)
- [What every computer science major should know](http://matt.might.net/articles/what-cs-majors-should-know/)

## Computational complexity

- [Big-O Cheat Sheet](https://www.bigocheatsheet.com/) - bigocheatsheet.com

## Courses and videos

- [List of Computer Science courses with video lectures](https://github.com/Developer-Y/cs-video-courses)

## Free (e)books

- [IT eBooks](http://it-ebooks.info/)
- [Structure and Interpretation of Computer Programs (SICP)](https://mitpress.mit.edu/sites/default/files/sicp/index.html), by Harold Abelson, Gerald Jay Sussman and Julie Sussman. _"Licensed under a Creative Commons Attribution-ShareAlike 4.0 International License by the MIT Press."_

# Data science

## Jupyter

- [Jupyter Notebook for Beginners: A Tutorial](https://www.dataquest.io/blog/jupyter-notebook-tutorial/)
- [Six easy ways to run your Jupyter Notebook in the cloud](https://www.dataschool.io/cloud-services-for-jupyter-notebook/)
- [Tutorial: Advanced Jupyter Notebooks](https://www.dataquest.io/blog/advanced-jupyter-notebooks-tutorial/)

## Pandas

- [Modern Pandas](https://tomaugspurger.github.io/modern-1-intro) - _"This series is about how to make effective use of pandas, a data analysis library for the Python programming language. It's targeted at an intermediate level: people who have some experience with pandas, but are looking to improve."_
- [Official website](https://pandas.pydata.org) - _"pandas is an open source, BSD-licensed library providing high-performance, easy-to-use data structures and data analysis tools for the Python programming language."_

## Working with data (Pandas, NumPy, Matplotlib, IPython, Scikit-Learn...)

- [Kaggle: Micro-Courses](https://www.kaggle.com/learn/overview) - _"Practical data skills you can apply immediately: that's what you'll learn in these free micro-courses. They're the fastest (and most fun) way to become a data scientist or improve your current skills."_
- [Python Data Science Handbook: full text in Jupyter Notebooks](https://github.com/jakevdp/PythonDataScienceHandbook) - _"This repository contains the entire Python Data Science Handbook, in the form of (free!) Jupyter notebooks."_

# Free e-books and video courses

- [Packt Publishing – free programming ebooks and videos](https://www.packtpub.com/packt/offers/free-learning) - Daily offer of up-to-date, quality material.

# Hacking

- :star: [Awesome Hacking](https://github.com/Hack-with-Github/Awesome-Hacking) - _"A collection of awesome lists for hackers, pentesters & security researchers."_
- [Hacker Tools](https://hacker-tools.github.io) - _"Learn to make the most of the tools that hackers have been using for decades."_

# LaTeX

- [Overleaf](https://www.overleaf.com) - _"The easy to use, online, collaborative LaTeX editor."_
- [Templates](http://www.latextemplates.com) - _"The best source of free quality LaTeX templates."_
- [Wikibook](https://en.wikibooks.org/wiki/LaTeX) - _"This is a guide to the LaTeX typesetting system. It is intended as a useful resource for everybody, from new users who wish to learn, to old hands who need a quick reference."_
- [Mathpix Snip](https://mathpix.com) - _"Do you spend a lot of time typing equations in LaTeX? Try Mathpix Snip for iOS, Android, macOS, Windows or Linux and start converting images to LaTeX instantly!"_

# Linux & Unix

- [CIS 191: Linux and Unix - University of Pennsylvania](https://www.cis.upenn.edu/~cis191/index.html) - _"This half-credit course provides a thorough introduction to Unix and Linux. Topics will range from critical basic skills such as examining and editing files, compiling programs and writing shell scripts, to higher level topics such as the architecture of Unix and its programming model."_
- [Distrowatch](https://distrowatch.com) - _"DistroWatch is a website which provides news, distribution pages hit rankings, and other general information about various Linux distributions as well as other free software/open source Unix-like operating systems."_ ([from Wikipedia](https://en.wikipedia.org/wiki/DistroWatch))
- [Linux.com - What is Linux?](https://www.linux.com/what-is-linux/) - _"Here is all the information you need to get up to speed on the Linux platform."_

# Mathematics

- [Mathematics 16A, 002 - Fall 2013](https://archive.org/details/ucberkeley-webcast-PL-XXv-cvA_iCCCqDD9uTufr5I3Xtr3szk) - UC Berkeley

## Beginner topics

- [Khan Academy](https://www.khanacademy.org) - Brush up on arithmetic, algebra, geometry, trigonometry, statistics & probability, calculus, differential equations, linear algebra, functions.

## Calculus

- [Calculus III](http://tutorial.math.lamar.edu/Classes/CalcIII/CalcIII.aspx) - _Here are my online notes for my Calculus III course that I teach here at Lamar University. Despite the fact that these are my “class notes”, they should be accessible to anyone wanting to learn Calculus III or needing a refresher in some of the topics from the class._
- [Calculus for beginners, from MIT](http://www-math.mit.edu/~djk/calculus_beginners) - _"Calculus for Beginners and Artists"_
- [Calculus problem set](https://www.math.ucdavis.edu/~kouba/ProblemsList.html)

### Derivatives

- [Derivative Calculator](https://www.derivative-calculator.net) - _"Calculate derivatives online — with steps and graphing!"_
- [Introduction to differentiation on ExamSolutions](https://www.examsolutions.net/a-level-maths/ocr/c1-tutorials/#Different) - Gradient, second derivative, tangents, normals, stationary points, increasing and decreasing functions.
- [Introduction to differentiation II on ExamSolutions](https://www.examsolutions.net/a-level-maths/ocr/c3-tutorials/#diff) - Exponential functions, chain rule, product rule, quotient rule, reciprocal function, exam questions, connected rates of change.

## Discrete mathematics

- [Readings from MIT OpenCourseWare](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-042j-mathematics-for-computer-science-fall-2010/readings/) on proofs, graph theory, recurrences, probability.

### Algorithms

#### Hopcroft-Karp

- [Bipartite Matching](https://www-m9.ma.tum.de/graph-algorithms/matchings-hopcroft-karp/index_en.html) - Interactive: _"Here we demonstrate the Hopcroft-Karp algorithm that solves the problem of finding maximal matchings on bipartite graphs."_

### Binomial theorem

- [Intro to the Binomial Theorem](https://www.khanacademy.org/math/precalculus/x9e81a4f98389efdf:polynomials/x9e81a4f98389efdf:binomial/v/binomial-theorem) - Khan Academy

### Graph theory

- [D3 Graph Theory](https://d3gt.com) - _"Learn graph theory interactively."_
- [Matching (Graph Theory)](https://brilliant.org/wiki/matching) - _"Definition, terminology, bipartite matching, examples."_

### Rules of inference - logic proofs

- [Rules of Inference and Logic Proofs](http://sites.millersville.edu/bikenaga/math-proof/rules-of-inference/rules-of-inference.html) - Covers modus ponens, modus tollens, disjunctive syllogism, De Morgan's law, biconditional, conjunctions, disjunctions, equivalences, double negation.

## Encryption

- [Part 1: How RSA Works With Examples](http://doctrina.org/How-RSA-Works-With-Examples.html) - Barry Steyn
- [Part 2: Why RSA Works: Three Fundamental Questions Answered](http://doctrina.org/Why-RSA-Works-Three-Fundamental-Questions-Answered.html) - Barry Steyn

## Limits

- [Limits and continuity](https://www.khanacademy.org/math/differential-calculus/dc-limits) - Khan Academy

## Linear Algebra

- [Applied Linear Algebra 1](https://open.math.uwaterloo.ca/4?gid=314) - University of Waterloo (Canada)
- [Interactive Linear Algebra](https://textbooks.math.gatech.edu/ila) - _"This is an introductory textbook on linear algebra, written by Joe Rabinoff and Dan Margalit for Math 1553 at Georgia Tech."_
- [Matrix multiplication](http://matrixmultiplication.xyz) - Online tool to perform matrix calculations.
- Problem sets
  - [PDF][exercises and problems in linear algebra, portland state university](https://web.pdx.edu/~erdman/LINALG/Linalg_pdf.pdf), Version July 13, 2014

## Machine learning

- [Mathematics for Machine Learning](https://mml-book.github.io) - _"We wrote a book on Mathematics for Machine Learning that motivates people to learn mathematical concepts. The book is not intended to cover advanced machine learning techniques because there are already plenty of books doing this. Instead, we aim to provide the necessary mathematical skills to read those other books."_

## Modular arithmetic

- [Modular arithmetic](https://modular-arithmetic.appspot.com/#modularArithmetic) - Clear, simple explanations: _"Numbers in a given modulo "wrap around". They reach a certain value, and then continue from the beginning up to that value. Then, begin again. [...]"_

## Number bases

- [Multiplication in base five](https://www.basic-mathematics.com/multiplication-in-base-five.html)

## Online tools

- [Desmos](https://www.desmos.com) - _"Graph functions, plot data, evaluate equations, explore transformations, and much more – for free!"_
- [Symbolab](https://www.symbolab.com) - _"Symbolab: equation search and math solver - solves algebra, trigonometry and calculus problems step by step."_ **(:heavy_dollar_sign: requires subscription for all features)**
- [Wolfram Alpha](https://www.wolframalpha.com) - _"Wolfram Alpha is a computational knowledge engine or answer engine."_ **(:heavy_dollar_sign: requires subscription for all features)**

## Statistics

- [Statistics 20, 003 - Fall 2010](https://archive.org/details/ucberkeley-webcast-PLFCCED623A3AB020F) - UC Berkeley

## Trigonometry

- [How To Learn Trigonometry Intuitively](https://betterexplained.com/articles/intuitive-trigonometry) - Better Explained
- [The trigonometry of non-right triangles](http://www.xaktly.com/XMathMain.html) -
  Angle measurement, trigonometry basics, non-right triangle trig, inverse trig functions, analytic trigonometry, trigonometric equations video, polar coordinates, complex plane, rock climbing, conic sections.

# Music (ideal for programming)

- [Music For Programming](http://musicforprogramming.net) - Play programming music right from your web browser in an IDE-like interface.
- [Rainy Mood](https://rainymood.com) (noise generator) - _"Helps you to focus, relax, and sleep. [...] The internet's most popular rain experience."_

# Online services

## Clean your inbox

- [Unroll.me](https://unroll.me) - _"Instantly see a list of all your subscription emails. Unsubscribe easily from whatever you don't want."_

## Diff checker (compare different files)

- [Diffchecker](https://www.diffchecker.com) - _"Diffchecker is a diff tool to compare text differences between two text files."_ Works with images/PDF too and even through the terminal with Node.js.

## Disposable/temporary emails

_"Disposable email addressing, also known as DEA or dark mail, refers to an approach where a unique email address is used for every contact or entity. The benefit is that if anyone compromises the address or utilises it in connection with email abuse, the address owner can easily cancel (or "dispose" of) it without affecting any of their other contacts."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Disposable_email_address))

- [10 Minute Mail](https://10minutemail.net) - _"10minutemail.net is a free, disposable e-mail service. Your temporary e-mail address will expire after 10 minutes, after which you cannot access it. You can extend the time by 10 minutes."_
- [Spamgourmet](https://www.spamgourmet.com) - Customize disposable emails on the fly.
- [Temp Mail Address](https://www.tempmailaddress.com) - Get an email assigned live that will expire according to your needs.
- [Temp Mail](https://temp-mail.org) - Automatically get assigned a temporary account where you can see in real time your emails coming in.
- [ThrowAwayMail](https://www.throwawaymail.com) - Obtain a temporary email that's valid for 48 hours.

## File sharing & storage

- [Box](https://www.box.com) - **10GB Free (250MB file size limit)**. _"Box, Inc., based in Redwood City, California, is a cloud content management and file sharing service for businesses. Official clients and apps are available for Windows, macOS, and several mobile platforms."_ ([from Wikipedia](<https://en.wikipedia.org/wiki/Box_(company)>))
- [Dropbox](https://www.dropbox.com) - **2GB Free**. _"Dropbox is a file hosting service operated by the American company Dropbox, Inc., headquartered in San Francisco, California, that offers cloud storage, file synchronization, personal cloud, and client software."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Dropbox_%28service%29))
- [Firefox Send](https://send.firefox.com) - Send up to **2.5GB** files when signing up or **1GB privately**, without signing in. Decide for how long to store your files online, who can download them and how many times.
- [Google Drive](https://www.google.com/drive) - **15GB Free**. _"Google Drive is a file storage and synchronization service developed by Google. [...] Google Drive allows users to store files on their servers, synchronize files across devices, and share files."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Google_Drive))
- [Hightail](https://www.hightail.com) - **2GB Free (100MB file size limit), 7 days file expiration**. _"Hightail, formerly YouSendIt, is a cloud service that lets users send, receive, digitally sign and synchronize files."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Hightail))
- [pCloud](https://www.pcloud.com) - **10GB Free**. _"pCloud is the secure cloud storage, where you can store, share and work on all your files. You can access them on any device, anywhere you go!"_
- [Sync](https://www.sync.com) - **5 GB of secure file storage with basic sharing features**. 2048-bit RSA, SSL/TLS encryption, end-to-end encryption, 30 days version history, restore & rewind, password protected sharing, remote device lockout.
- [WeTransfer](https://wetransfer.com) - Free: Send up to **2GB** with **7 days** file expiration.

## Gantt charts

- [Teamgantt](https://teamgantt.com) - _"TeamGantt is the refreshing solution that brings project scheduling software online. You can now plan and manage your projects with this super-easy-to-use gantt software. Inviting your co-workers, teammates, and friends to view and edit your gantt chart is simple and fun."_

## Image hosting

- [500px](https://web.500px.com) - Primarily used to showcase photography.
- [Flickr](https://www.flickr.com) - _"Flickr is an image hosting service and video hosting service. It was created by Ludicorp in 2004."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Flickr))
- [Free Image Hosting.net](http://www.freeimagehosting.net) - No sign up required.
- [Google Photos](https://photos.google.com) (storage included with Google Drive, **15GB for free**) - _"Google Photos is a photo sharing and storage service developed by Google."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Google_Photos))
- [ImageShack](https://imageshack.us/)- _"Unlimited space to host images, easy to use image uploader, albums, photo hosting, sharing, dynamic image resizing on web and mobile."_
- [Imgbox](https://imgbox.com) - _"Hotlinking, super blazing fast, 10MB maximum file size, simple interface, unlimited storage space, unlimited storage time."_
- [Imgur](https://imgur.com) - _"Imgur is an online image sharing community and image host founded by Alan Schaaf in 2009."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Imgur))
- [Postimage](https://postimages.org) - _"Provides free image upload and hosting integration for forums. Free picture hosting and photo sharing for websites and blogs."_
- [TinyPic](http://tinypic.com) - No sign up required. _"TinyPic is a photo and video sharing service, owned and operated by Photobucket.com, that allows users to upload, link and share, images and videos on the Internet. The idea is similar to URL shortening in which each uploaded image is given a relatively short internet address."_ ([from Wikipedia](https://en.wikipedia.org/wiki/TinyPic))
- [Use](https://www.use.com) - _"Use.com offers unlimited free image hosting - No sign up required! It's easy to upload, link, and share your photos on eBay®, craigslist®, MySpace®, blogs..."_

## Manage your privacy

- [Firefox Monitor](https://monitor.firefox.com) - _"See if you’ve been part of an online data breach. Find out what hackers already know about you. [...] If your information surfaces in a new data breach, we’ll send you an alert. [...] Get ongoing breach monitoring for multiple email addresses."_

## Receive SMS

- [Receive SMS](https://receive-smss.com) - _"receive-smss.com is a free service for receiving SMS messages and voice mails online. There is no need to register. Just select your phone number from the list below. You can use it to receive messages from Facebook, Telegram, WeChat, VK, PayPal, AliPay and more."_

# Open source

- [Open Source Guides](https://opensource.guide) - _"Open source software is made by people just like you. Learn how to launch and grow your project."_

# Programming

## App monitoring

- :heavy*dollar_sign: [Datadog](https://www.datadoghq.com) - *"Modern monitoring & analytics. See inside any stack, any app, at any scale, anywhere."\_
- :heavy*dollar_sign: [Dynatrace](https://www.dynatrace.com/solutions/application-monitoring) - *"Dynatrace application monitoring provides all performance metrics in real time and detects and diagnoses problems automatically."\_
- [Uptime Robot](https://uptimerobot.com) - _"Downtime Happens. Get Notified! 50 Monitors, Checked Every 5 Minutes, Totally Free!"_

## Basics

- [SoloLearn](https://www.sololearn.com) - _"Learn on the web and on the go. Available on all major devices and platforms. Always pick up where you left off. More simple and enjoyable than ever!"_

## Books

[Programming Notes for Professionals books](https://books.goalkicker.com/) - Wide range of relevant topics (algorithms, C++, CSS, Git, HTML5, JavaScript, LaTeX, Linux, Python, SQL, etc.). _"Books are updated weekly."_

## Coding challenges

- [Challenge Rocket](https://challengerocket.com) - _"Solve a challenge. Test your skills. Get hired."_
- [Code Abbey](https://www.codeabbey.com) - Somewhat more beginner-oriented. _"We believe that three things lead to success: Practice, Practice and Practice!"_
- [CodeSignal](https://codesignal.com) - _"CodeSignal (formerly CodeFights) is a skills-based assessment platform operated by American company BrainFights, Inc., whose mission is to discover, develop and promote technical talent. [...] CodeSignal applies game mechanics that offer developers of all skill levels online computer programming challenges for both instructional and recruiting purposes."_ ([from Wikipedia](https://en.wikipedia.org/wiki/CodeSignal))
- [CodeWars](https://www.codewars.com) - _"Achieve mastery through challenge. Improve your skills by training with others on real code challenges."_
- [Coderbyte](https://coderbyte.com) - _"Get access to the best collection of coding challenges that you can solve directly online in 10 programming languages. The challenges come with official solutions and tens of thousands of user solutions. You can also brush up on your skills by reading our tutorials in topics like advanced JavaScript features, data structures, and algorithm interview questions asked at companies like Google and Microsoft."_
- [CodinGame](https://www.codingame.com) - _"The new way to improve your programming skills while having fun and getting noticed."_
- [Exercism](https://exercism.io) - _"Level up your programming skills with 3,066 exercises across 51 languages, and insightful discussion with our dedicated team of welcoming mentors. Exercism is 100% free forever."_
- [HackerEarth](https://www.hackerearth.com) - _"Explore 4 different programming tracks, solve over 2,000 coding problems, and crack your coding interview."_
- [HackerRank](https://www.hackerrank.com) - _"Join over 7 million developers. Practice coding, prepare for interviews, and get hired."_
- [LeetCode](https://leetcode.com) - _"LeetCode is the best platform to help you enhance your skills, expand your knowledge and prepare for technical interviews."_
- [Project Euler](https://projecteuler.net) - _"Project Euler (named after Leonhard Euler) is a website dedicated to a series of computational problems intended to be solved with computer programs."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Project_Euler))
- [Sphere Online Judge](https://www.spoj.com) - _"Become a true programming master. Learn how to code and build efficient algorithms."_
- [Topcoder](https://www.topcoder.com) - _"Topcoder (formerly TopCoder) is a crowdsourcing company with an open global community of designers, developers, data scientists, and competitive programmers. Topcoder pays community members for their work on the projects and sells community services to corporate, mid-size, and small-business clients."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Topcoder))

## Documentation

- [GitBook](https://www.gitbook.com) - _"Document Everything! For you, your users and your team. [...] A place to think and track ideas for you & your team. [...] A home for your team, best-practices and thoughts. [...] Beautiful docs for your APIs, Products, FAQs, User Guides, ..."_
- [Sphinx](http://www.sphinx-doc.org) - _"Sphinx is a tool that makes it easy to create intelligent and beautiful documentation, written by Georg Brandl and licensed under the BSD license. It was originally created for the Python documentation, and it has excellent facilities for the documentation of software projects in a range of languages."_

## Interview preparation

- [Interview Cake](https://www.interviewcake.com) - Check out their paid course/coaching too! - _"Free practice programming interview questions. Interview Cake helps you prep for interviews to land offers at companies like Google and Facebook."_

### Books

- [Cracking the Coding Interview](http://www.crackingthecodinginterview.com), by Gayle Laakmann McDowell.

### Facebook

- [Interviewing at Facebook — On-Site JavaScript Technical Interview Questions](https://medium.com/javascript-in-plain-english/facebook-on-site-technical-interview-1264cacad263) - Medium, Adi S.

### Google

- [Interviewing at Google — JavaScript Assessment Questions](https://medium.com/javascript-in-plain-english/interviewing-at-google-javascript-assessment-questions-f9bf0c0df157) - Medium, Adi S.

### Microsoft

- [Interviewing at Microsoft— JavaScript Assessment Questions](https://medium.com/javascript-in-plain-english/microsoft-online-assessment-questions-js-f68ecdb6e927) - Medium, Adi S.

## Games

### CSS

- [CSS Diner](https://flukeout.github.io) - _"It's a fun game to learn and practice CSS selectors."_
- [Flexbox Froggy](http://flexboxfroggy.com) - _"A game for learning CSS flexbox."_
- [Flexbox Zombies](https://flexboxzombies.com/p/flexbox-zombies) _"This is a Mastery Game. Each section unravels part of the plot, gives you mastery over a new flexbox concept, and presents zombie survival challenges that force you to solidify your new skills like your life depends on it."_
- [Grid Critters](https://gridcritters.com) - _"Completely learn CSS Grid once and for all."_
- [Grid Garden](https://codepip.com/games/grid-garden) - _"How well can you tend to your carrot garden using CSS grid? In this game, you must water your carrot crops and poison the weeds by mastering CSS grid, a powerful new module that makes 2-dimensional grid layouts a piece of cake. With it you can define columns, rows, and grid template areas."_

### JavaScript

- [CheckiO](https://checkio.org) - _"Coding games for beginners and advanced programmers where you can improve your coding skills by solving engaging challenges and fun task using JavaScript."_
- [Screeps](https://screeps.com) - _"It’s an open-source sandbox MMO RTS game for programmers, wherein the core mechanic is programming your units’ AI. You control your colony by writing JavaScript which operate 24/7 in the single persistent real-time world filled by other players on par with you."_

### Projects and ideas

- [Build your own X](https://github.com/danistefanovic/build-your-own-x) - _"Build your own (insert technology here)"_

### Python

- [CheckiO](https://checkio.org) - _"Coding games for beginners and advanced programmers where you can improve your coding skills by solving engaging challenges and fun task using Python."_
- [TwilioQuest](https://www.twilio.com/quest) - _"Learn to code and lead your intrepid crew on a mission to save The Cloud in TwilioQuest, a PC role-playing game inspired by classics of the 16-bit era. Free forever, and available now for Windows, Mac, and Linux."_

### Security

- [Wargames](https://overthewire.org/wargames) - _"The wargames offered by the OverTheWire community can help you to learn and practice security concepts in the form of fun-filled games."_

### Service workers

- [Service Workies](https://serviceworkies.com) - _"Learn Service Workers inside and out with the new PWA Mastery Game."_

## Git / GitHub

- [Git Immersion](http://gitimmersion.com) - _"A guided tour that walks through the fundamentals of Git, inspired by the premise that to know a thing is to do it."_
- [Learn Git Branching](https://learngitbranching.js.org) - _"An interactive Git visualization tool to educate and challenge!"_
- [Pro Git Book](https://git-scm.com/book/en/v2) - _"The entire Pro Git book, written by Scott Chacon and Ben Straub and published by Apress, is available here. All content is licensed under the Creative Commons Attribution Non Commercial Share Alike 3.0 license. Print versions of the book are available on Amazon.com."_
- [Try GitHub](http://try.github.io) - _Resources to learn Git: Handbook, cheat sheets, git commands in the browser, etc._

## iOS

### Swift

- [Developing iOS 10 Apps with Swift](https://itunes.apple.com/us/course/developing-ios-10-apps-with-swift/id1198467120?ign-mpt=uo%3D8) - Stanford

## JavaScript

- [You Don't Know JS (book series)](https://github.com/getify/You-Dont-Know-JS) - _"This is a series of books diving deep into the core mechanisms of the JavaScript language."_
- [JavaScript Arrays](https://www.executeprogram.com) - _"Memorize the JavaScript array methods quickly, including weird corner cases; no more looking them up. Slice, filter, map, reduce, and the rest."_

## Julia

- [Quantitative Economics with Julia](https://lectures.quantecon.org/jl) - Learning Julia, dynamic programming, many mathematical concepts.

## Python

- [Quantitative Economics with Python](https://lectures.quantecon.org/py) - Great reference for scientific libraries, working with data, advanced Python concepts, dynamic programming.

## Questions and answers

- [Stack Overflow](https://stackoverflow.com) - _"Stack Overflow is a question and answer site for professional and enthusiast programmers."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Stack_Overflow)

## Regular expressions (regex)

- [RegexOne](https://regexone.com) - _"Learn Regular Expressions with simple, interactive exercises."_
- [regex101](https://regex101.com) - _"Online regex tester, debugger with highlighting for PHP, PCRE, Python, Golang and JavaScript."_
- [Regexes - Execute Program](https://www.executeprogram.com) - _"Learn the common regex features. Boundaries, repetition, wildcards, character sets, character classes, and others."_

## SQL

- [SQL Zoo](https://sqlzoo.net) - _"Learn SQL using: SQL Server, Oracle, MySQL, DB2, and PostgreSQL."_

## TypeScript

- [TypeScript - Execute Program](https://www.executeprogram.com) - _"Static types and the TypeScript language from the ground up, whether you've used static types or not. Basic JavaScript knowledge required."_

# Startups

- [Notes Essays-Peter Thiel's CS183: Startup-Stanford, Spring 2012](http://blakemasters.com/peter-thiels-cs183-startup) - There is a book available from those notes: [Zero to One: Notes on Startups, or How to Build the Future](https://amzn.to/2I6AlDJ).

# Technology

- [Version Museum](https://www.versionmuseum.com) - _"Version Museum showcases the visual history of popular websites, operating systems, applications, and games that have shaped our lives. Much like walking through a real-life museum, this site focuses on the design changes of historic versions of technology, rather than just the written history behind it."_

# Typing faster

- [10FastFingers](https://10fastfingers.com) - _"Test & Improve your Typing Speed with our free Typing Games."_
- [Typing.io](https://typing.io) - _"Typing.io is a typing tutor/trainer for programmers. Typing.io's lessons are based on open source code, allow you to practice typing the key sequences that appear in real code."_

# Variety

- [Awesome lists about all kinds of interesting topics](https://github.com/sindresorhus/awesome#readme) :sunglasses:
- [Free for developers](https://free-for.dev) - _"This is a list of software (SaaS, PaaS, IaaS, etc.) and other offerings that have free tiers for developers."_

# Web

## Buying a domain name

- [BlueHost](https://www.bluehost.com/)
- [BuyDomains.com](https://www.buydomains.com/)
- [Domain.com](https://www.domain.com/)
- [DreamHost](https://www.dreamhost.com/)
- [GoDaddy](https://godaddy.com/domains)
- [HostGator](https://www.hostgator.com/)
- [Name.com](https://www.name.com/)
- [NameCheap](https://www.namecheap.com/)

## Cloud Computing

- [AWS](https://aws.amazon.com) - _"Amazon Web Services is a subsidiary of Amazon that provides on-demand cloud computing platforms to individuals, companies and governments, on a metered pay-as-you-go basis."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Amazon_Web_Services))
- [Digital Ocean](https://www.digitalocean.com) - _"DigitalOcean provides developers cloud services that help to deploy and scale applications that run simultaneously on multiple computers."_ ([from Wikipedia](https://en.wikipedia.org/wiki/DigitalOcean))
- [Google Cloud Platform](https://cloud.google.com) - _"Google Cloud Platform, offered by Google, is a suite of cloud computing services that runs on the same infrastructure that Google uses internally for its end-user products, such as Google Search and YouTube."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Google_Cloud_Platform))
- [Linode](https://www.linode.com) - _"Instantly deploy an SSD cloud server running with your choice of Linux distro, resources, and node location."_
- [Rackspace Cloud](https://www.rackspace.com/cloud) - _"The Rackspace Cloud is a set of cloud computing products and services billed on a utility computing basis from the US-based company Rackspace. Offerings include web application hosting or platform as a service ("Cloud Sites"), Cloud Storage ("Cloud Files"), virtual private server ("Cloud Servers"), load balancers, databases, backup, and monitoring."_ ([from Wikipedia](https://en.wikipedia.org/wiki/Rackspace_Cloud))

## Information on websites

- [SecurityTrails - DNS Trail](https://securitytrails.com/dns-trails) - Review the history of a domain name.

## Website annotation

- [Bounce](https://www.bounceapp.com) - _"A little app from ZURB that lets people add feedback to any interface and toss that back and forth with other people."_

## Website testing

- [CodePen](https://codepen.io) - _"CodePen is an online community for testing and showcasing user-created HTML, CSS and JavaScript code snippets. It functions as an online code editor and open-source learning environment, where developers can create code snippets, creatively named "pens", and test them._" ([from Wikipedia](https://en.wikipedia.org/wiki/CodePen))
- [JSFiddle](https://jsfiddle.net) - _"JSFiddle is an online community for testing and showcasing user-created and collaborational HTML, CSS and JavaScript code snippets, known as 'fiddles'. It allows for simulated AJAX calls."_ ([from Wikipedia](https://en.wikipedia.org/wiki/JSFiddle))

# Web development

## Learning

- [Intro to Web Dev v2](https://btholt.github.io/intro-to-web-dev-v2/).

## Tools

- [Color Hunt](https://colorhunt.co) - _"Color Hunt is a free and open platform for color inspiration with thousands of trendy hand-picked color palettes."_
- [Coolors](https://coolors.co) - _"The super fast color schemes generator! Create, save and share perfect palettes in seconds!"_
- [HTML Color Codes](https://htmlcolorcodes.com) - _"Get HTML color codes, Hex color codes, RGB and HSL values with our color picker, color chart and HTML color names."_
- [Real Favicon Generator](https://realfavicongenerator.net) - _"Favicon Generator. For real."_
