[Go back to the main page](../README.md)

# YouTube

- [YouTube](#youtube)
- [Artificial intelligence](#artificial-intelligence)
  - [Deep learning](#deep-learning)
  - [General learning](#general-learning)
  - [Machine learning](#machine-learning)
  - [Research](#research)
  - [Robotics](#robotics)
- [Computer science](#computer-science)
  - [Algorithms](#algorithms)
    - [`mergeSort` algorithm](#mergesort-algorithm)
    - [`quickSort` algorithm](#quicksort-algorithm)
  - [Compilers](#compilers)
  - [Computational complexity & P vs NP](#computational-complexity--p-vs-np)
  - [Data structures](#data-structures)
  - [Introduction](#introduction)
  - [Mixed topics](#mixed-topics)
- [Cryptocurrencies](#cryptocurrencies)
  - [Bitcoin](#bitcoin)
- [Engineering](#engineering)
- [Git / GitHub](#git--github)
- [Graphic design](#graphic-design)
  - [3D creation](#3d-creation)
  - [Raster graphics (JPEG, PNG, GIF, TIFF, BMP, PSD, PSB, etc.)](#raster-graphics-jpeg-png-gif-tiff-bmp-psd-psb-etc)
  - [Vector graphics, 2D (SVG, CGM, AI, CDR, ODG, XPS, DXF, etc.)](#vector-graphics-2d-svg-cgm-ai-cdr-odg-xps-dxf-etc)
- [Mathematics](#mathematics)
  - [Beginner-oriented](#beginner-oriented)
  - [Calculus](#calculus)
    - [Derivatives](#derivatives)
  - [Complex analysis](#complex-analysis)
  - [Differential equations](#differential-equations)
  - [Discrete mathematics](#discrete-mathematics)
- [Encryption](#encryption)
- [General topics](#general-topics)
  - [Linear algebra](#linear-algebra)
  - [Modular arithmetic](#modular-arithmetic)
  - [Numerical analysis](#numerical-analysis)
  - [Probability & statistics](#probability--statistics)
  - [Real analysis](#real-analysis)
  - [Regression Analysis](#regression-analysis)
  - [Topology](#topology)
  - [Trigonometry](#trigonometry)
- [Programming](#programming)
  - [Android](#android)
  - [C](#c)
  - [C&#35;](#c-1)
  - [C&#43;&#43;](#c-2)
  - [JavaScript](#javascript)
  - [PHP](#php)
  - [Python](#python)
  - [SQL](#sql)
    - [PostgreSQL](#postgresql)
  - [Web development](#web-development)
    - [CSS](#css)
- [Software engineering](#software-engineering)
- [Study skills](#study-skills)
- [Virtual reality](#virtual-reality)

**Note:**

- When software is used, [open source software](https://en.wikipedia.org/wiki/Open-source_software) is denoted with a :star:.

# Artificial intelligence

- [IIT Madras - Artificial Intelligence](https://www.youtube.com/playlist?list=PLbMVogVj5nJQu5qwm-HmJgjmeGhsErvXD) (playlist) - NPTEL
- [Lex Fridman](https://www.youtube.com/lexfridman) - Podcast, deep learning, self-driving cars, research.
- [MIT 6.034 Artificial intelligence](https://www.youtube.com/watch?v=TjZBTDzGeGg&list=PLUl4u3cNGP63gFHB6xb-kVBiQHYe_4hSi) (playlist) - MIT OpenCourseWare

## Deep learning

- [Deep Learning Oxford course](https://www.youtube.com/playlist?list=PLcmaziH9sW6PHBhsM_qgf52Ay6EVY8cWT) (playlist) -
  Dan Colman

## General learning

- [Siraj Raval](https://www.youtube.com/channel/UCWN3xxRkmTPmbKwht9FuE5A/) (channel) - _"I'm on a warpath to inspire and educate developers to build Artificial Intelligence. Games, music, chatbots, art, I'll teach you how to make it all yourself."_

## Machine learning

- [Machine Learning Course - CS 156](https://www.youtube.com/playlist?list=PLD63A284B7615313A) (playlist) - caltech
- [Neural Networks for Machine Learning - Geoffrey Hinton 2016](https://www.youtube.com/playlist?list=PLoRl3Ht4JOcdU872GhiYWf6jwrk_SNhz9) (playlist) - Colin McDonnell

## Research

- [Two Minute Papers](https://www.youtube.com/user/keeroyz/) (channel) - _"Awesome research for everyone."_

## Robotics

- [Introduction to Robotics](https://www.youtube.com/view_play_list?p=65CC0384A1798ADF&search_query=Artificial+Intelligence++Introduction+to+Robotics) (playlist) - Stanford

# Computer science

- [CrashCourse Computer Science](https://www.youtube.com/watch?v=tpIctyqH29Q&list=PL8dPuuaLjXtNlUrzyH5r6jN9ulIgZBpdo) (playlist) - CrashCourse
- [Computerphile](https://www.youtube.com/user/Computerphile/) (channel) - _"Videos all about computers and computer stuff. Sister channel of Numberphile."_
- [UC Berkeley CS10 Beauty and Joy of Computing Fa10 (1080p HD)](https://www.youtube.com/playlist?list=PLECBD29A17AAF6EF9) (playlist) - Dan Garcia

## Algorithms

- [Algorithm Design and Analysis](https://www.youtube.com/playlist?list=PL6EF0274BD849A7D5) (playlist) - UC Davis
- [Algorithmic Lower Bounds: Fun with Hardness Proofs](https://www.youtube.com/playlist?list=PLUl4u3cNGP63d33STUUBfZUpzFCVR5-PV) (playlist) - MIT OpenCourseWare - _"[...] summarizing the prerequisite complexity theory and featuring two examples of hardness proofs in games."_
- [Algorithms Course - Graph Theory Tutorial from a Google Engineer](https://www.youtube.com/watch?v=09_LlHjoEiY) - freeCodeCamp.org
- [Algorithms for Big Data](https://www.youtube.com/playlist?list=PL2SOU6wwxB0v1kQTpqpuu5kEJo2i-iUyf) (playlist) - Harvard University
- [Introduction to algorithms](https://www.youtube.com/watch?v=HtSuA80QTyo&list=PLUl4u3cNGP61Oq3tWYp6V_F-5jb5L2iHb) (playlist) - MIT OpenCourseWare

### `mergeSort` algorithm

- [2.7.2. Merge Sort Algorithm](https://www.youtube.com/watch?v=mB5HXBb_HY8) - Abdul Bari
- [Algorithm lecture 8 -- Merge sort algorithm, analysis and problems](https://www.youtube.com/watch?v=sfmaf4QpVTw) - Gate Lectures by Ravindrababu Ravula

### `quickSort` algorithm

- [Algorithms lecture 9 -- Quick sort algorithm](https://www.youtube.com/watch?v=3DV8GO9g7B4) - Gate Lectures by Ravindrababu Ravula
- [2.8.1 QuickSort Algorithm](https://www.youtube.com/watch?v=7h1s2SojIRw) - Abdul Bari

## Compilers

- [IIT Kanpur – Compiler Design](https://www.youtube.com/playlist?list=PLbMVogVj5nJTmKzaSlCpGgi7qxgcRRs8h) (playlist) - NPTEL

## Computational complexity & P vs NP

- [Computational Complexity](https://www.youtube.com/watch?v=moPtwq_cVH8) - MIT OpenCourseWare
- [P vs. NP and the Computational Complexity Zoo](https://www.youtube.com/watch?v=YX40hbAHx3s) - hackerdashery

## Data structures

- [Advanced data structures](https://www.youtube.com/watch?v=T0yzrZL1py0&list=PLUl4u3cNGP61hsJNdULdudlRL493b-XZf) (playlist) - MIT OpenCourseWare

## Introduction

- [Introduction to Computer Science and Programming, Spring 2011](https://www.youtube.com/watch?list=PLB2BE3D6CA77BB8F7&v=bX3jvD7XFPs) (playlist) - MIT OpenCourseWare

## Mixed topics

- [CS50 Beyond 2019](https://www.youtube.com/playlist?list=PLhQjrBD2T381Q6R1jRxgXknYO7VuTYPBI) (playlist) - CS50. About HTML, CSS, Git, GitHub, Python, Flask, Object-Oriented Programming, AI, JavaScript, ORMs, APIs, React, security, scalability.
- [CS50 2018](https://www.youtube.com/watch?v=5azaK2cBKGw&list=PLhQjrBD2T382eX9-tF75Wa4lmlC7sxNDH) (playlist) - CS50 (Harvard's Introductory Computer Science Course). About C, arrays, memory, data structures, HTTP, HTML, CSS, Python, Web programming, SQL.

# Cryptocurrencies

## Bitcoin

- [Bitcoin and Cryptocurrency Technologies Online Course](https://www.youtube.com/playlist?list=PLqn29N3j3wMgdsN42AABVkc8KbjFtd_GI) (playlist) - Matteo Scappini

# Engineering

- [CrashCourse Engineering](https://www.youtube.com/watch?v=ToC8rFFp88Y&list=PL8dPuuaLjXtO4A_tL6DLZRotxEb114cMR) (playlist) - CrashCourse

# Git / GitHub

- [CS50 Beyond 2019](https://www.youtube.com/watch?v=eulnSXkhE7I) - CS50
- [Git & GitHub Crash Course For Beginners](https://www.youtube.com/watch?v=SWYqp7iY_Tc) - Traversy Media
- [Git Tutorial for Beginners: Command-Line Fundamentals](https://www.youtube.com/watch?v=HVsySz-h9r4&list=PL-osiE80TeTuRUfjRe54Eea17-YfnOOAx) (playlist) - Corey Schafer
- [GitHub Basics Tutorial - How to Use GitHub](https://www.youtube.com/watch?v=x0EYpi38Yp4) - freeCodeCamp.org

# Graphic design

## 3D creation

- :star: [Blender Guru Tutorials](https://www.youtube.com/user/AndrewPPrice/playlists) (playlists) - Blender Guru

## Raster graphics (JPEG, PNG, GIF, TIFF, BMP, PSD, PSB, etc.)

- :heavy_dollar_sign: [Photoshop Tutorials](https://www.youtube.com/user/NewWorldOps) (channel) - Photoshop Tutorials
- :star: [Tutorials with GIMP](https://www.youtube.com/channel/UCEQXp_fcqwPcqrzNtWJ1w9w) (channel) - Logos By Nick

## Vector graphics, 2D (SVG, CGM, AI, CDR, ODG, XPS, DXF, etc.)

- :heavy_dollar_sign: [Logo design in Adobe Illustrator](https://www.youtube.com/channel/UCF6WjcZeVqy3MLBpp86eOyw/) (channel) - Mohamed Achraf
- :star: [Tutorials with Inkscape](https://www.youtube.com/channel/UCEQXp_fcqwPcqrzNtWJ1w9w) (channel) - Logos By Nick

# Mathematics

- [Computer Science - Riemann Hypothesis and its Applications](https://www.youtube.com/playlist?list=PLbMVogVj5nJRaBWHpgPX04ndIF2rloGUC) (playlist) - NPTEL
- [Mathematics for Computer Science (2010)](https://www.youtube.com/watch?v=L3LMbpZIKhQ&list=PLB7540DEDD482705B) (playlist) - MIT OpenCourseWare
- [Mathematics for Computer Science (2015)](https://www.youtube.com/watch?v=wIq4CssPoO0&list=PLUl4u3cNGP60UlabZBeeqOuoLuj_KNphQ) (playlist) - MIT OpenCourseWare

## Beginner-oriented

- [Eddie Woo](https://www.youtube.com/user/misterwootube/) (channel) - Covers topics ranging from quadratic equations, graphing, functions, factorization, probability, trigonometry, series on finances, calculus, geometry, series & sequences, etc.

## Calculus

- Beginner
  - [Essence of calculus](https://www.youtube.com/watch?v=WUvTyaaNkzM&list=PLZHQObOWTQDMsr9K-rj53DwVRMYO3t5Yr) (playlist) - 3Blue1Brown
- One step beyond
  - [Highlights of Calculus](https://www.youtube.com/watch?v=X9t-u87df3o&list=PLBE9407EA64E2C318) (playlist) - MIT OpenCourseWare
- More advanced
  - [Calculus Blue - All about Calculus](https://www.youtube.com/channel/UC5N5pRddyicAX1QJyJjIIdg/playlists) (**big** playlists) - Prof Ghrist Math
  - [Calculus Single Variable](https://www.youtube.com/watch?v=nqDVJFlahpU&list=PLKc2XOQp0dMwj9zAXD5LlWpriIXIrGaNb) (playlist) - Penn Online Learning
  - [MIT Calculus Revisited: Calculus of Complex Variables](https://www.youtube.com/watch?v=BOx8LRyr8mU&list=PLD971E94905A70448) (playlist) - MIT OpenCourseWare
  - [MIT Calculus Revisited: Multivariable Calculus](https://www.youtube.com/watch?v=wsOoClvZmic&list=PL1C22D4DED943EF7B) (playlist) - MIT OpenCourseWare
  - [MIT Calculus Revisited: Single Variable Calculus](https://www.youtube.com/watch?v=MFRWDuduuSw&list=PL3B08AE665AB9002A) (playlist) - MIT OpenCourseWare
  - [Open Ed: Leingang, Calculus I](https://www.youtube.com/watch?v=PBUtJM-zAls&list=PL2D50EE0B1DC5453E) (playlist) - New York University
  - [Vector Calculus @ UNSW Sydney. Dr Chris Tisdell](https://www.youtube.com/watch?v=22oMQY_zQ34&list=PL283CA2107AD503A3) (playlist) - UNSWelearning

### Derivatives

- [Chain rule: example with trigonometric function](https://www.youtube.com/watch?v=aeQA5d3gZTI) - MIT OpenCourseWare
- [Chains f(g(x)) and the Chain Rule | MIT Highlights of Calculus](https://www.youtube.com/watch?v=yQrKXo89nHA) - MIT OpenCourseWare
- [The Chain Rule for differentiation of composite functions](https://www.youtube.com/watch?v=KKaRHdZ-Qus) - ExamSolutions

## Complex analysis

- [Complex Analysis - Part 1](https://www.youtube.com/playlist?list=PLbMVogVj5nJTLfYTwvct_SlLaxv1b50Vk) (playlist) - NPTEL
- [Complex Analysis - Part 2](https://www.youtube.com/playlist?list=PLbMVogVj5nJTSPDysVOzVPd0N1AHYqUhH) (playlist) - NPTEL

## Differential equations

- [Differential equations (2006)](https://www.youtube.com/watch?v=XDhJ8lVGbl8&list=PLEC88901EBADDD980) (playlist) - MIT OpenCourseWare
- [Differential equations (2011)](https://www.youtube.com/watch?v=76WdBlGpxVw&list=PL64BDFBDA2AF24F7E) (playlist) - MIT OpenCourseWare
- [Differential equations (2016)](https://www.youtube.com/watch?v=ZvL88xqYSak&list=PLUl4u3cNGP63oTpyxCMLKt_JmB0WtSZfG) (playlist) - MIT OpenCourseWare

## Discrete mathematics

- **Algorithms**
  - [Algorithms: Graph Search, DFS and BFS](https://www.youtube.com/watch?v=zaBhtODEL0w) - HackerRank
  - [Breadth-First Search (BFS) algorithm](https://www.youtube.com/watch?v=s-CYnVz-uh4) - MIT OpenCourseWare
  - [Depth-First Search (DFS), Topological Sort](https://www.youtube.com/watch?v=AfSk24UTFS8) - MIT OpenCourseWare
  - [Graph Traversals - BFS & DFS -Breadth First Search and Depth First Search](https://www.youtube.com/watch?v=pcKY4hjDrxk) - Abdul Bari
  - [Maximum Matching Algorithm](https://www.youtube.com/watch?v=gbasc4F-7hk) - HEGARTYMATHS
  - **Dijkstra's algorithm**
    - [Dijkstra's Shortest Path Algorithm | Graph Theory](https://www.youtube.com/watch?v=pSqmAO-m7Lk) - WilliamFiset
    - [Graph Data Structure 4. Dijkstra’s Shortest Path Algorithm](https://www.youtube.com/watch?v=pVfj6mxhdMw) - Computer Science
    - [Dijkstra's algorithm in 3 minutes — Review and example](https://www.youtube.com/watch?v=_lHSawdgXpI) - Michael Sambol
  - **Hopcroft–Karp algorithm**
    - [Hopcroft karp Algorithm explanation](https://www.youtube.com/watch?v=OhtWajIAU-M) - Holly Baker
    - [Hopcroft-Karp Algorithm](https://www.youtube.com/watch?v=0GNYjXUPTFM) - Samuel Russell
    - [Hopcroft–Karp algorithm](https://www.youtube.com/watch?v=lM5eIpF0xjA) - Joromy Bou Khalil
  - **Kruskal’s algorithm**
    - [Kruskal's algorithm in 2 minutes — Review and example](https://www.youtube.com/watch?v=71UQH7Pr9kU) - Michael Sambol
    - [Kruskal’s Algorithm for Minimum Spanning Tree](https://www.youtube.com/watch?v=3rrNH_AizMA) - GeeksforGeeks
  - **Prim's algorithm**
    - [Prim's algorithm in 2 minutes — Review and example](https://www.youtube.com/watch?v=cplfcGZmX7I) - Michael Sambol
- [Computer Sc - Discrete Mathematical Structures](https://www.youtube.com/view_play_list?p=0862D1A947252D20) (playlist) - Kamala Krithivasan
- [Discrete Math 1: Sets, propositional logic, factorials, permutations, combinations, proofs, mathematical induction, injective/surjective/bijective functions, inverse functions, algorithms](https://www.youtube.com/watch?v=tyDKR4FG3Yw&list=PLDDGPdw7e6Ag1EIznZ-m-qXu4XX3A0cIz) (playlist) - TheTrevTutor
- [Discrete Math 2: Permutations, combinations, probability, graph theory, trees, Dijkstra's Algorithm](https://www.youtube.com/watch?v=DBugSTeX1zw&list=PLDDGPdw7e6Aj0amDsYInT_8p6xTSTGEi2) (playlist) - TheTrevTutor
- [Discrete Math I](https://www.youtube.com/watch?v=OApHaIMKMJE&list=PLl-gb0E4MII0L5lz8uQ8j5aSFQQHoAzXx) (playlist) - Kimberly Brehm
- [Discrete mathematics](https://www.youtube.com/watch?v=2juspgYR7as&list=PLsFENPUZBqioyqffh3YZ2pKUg4uZFQJUY) (playlist) - GATEBOOK Video Lectures
- Recurrence relations: see lectures 14-15 of [Mathematics for Computer Science (2010)](https://www.youtube.com/watch?v=L3LMbpZIKhQ&list=PLB7540DEDD482705B) (playlist) - MIT OpenCourseWare
- [Sets, sequences, functions, summations, matrices, algorithms](https://www.youtube.com/watch?v=ZMhoRLGNR5Y&list=PLl-gb0E4MII0HmmhGXBIFGppSSqqy_mV-) (playlist) - Kimberly Brehm
- [Strong Induction Examples](https://www.youtube.com/watch?v=6O1s3_GsSHo) - Michael Barrus
- [The Karnaugh Map - Rules of Simplification](https://www.youtube.com/watch?v=PA0kBrpHLM4) - Jonnie Palmer
- [Transitive closure](https://www.youtube.com/watch?v=OO8Jfs9uZnc) - GVSUmath

# Encryption

- [Lecture 12: The RSA Cryptosystem and Efficient Exponentiation](https://www.youtube.com/watch?v=QSlWzKNbKrU) - Christof Paar
- [RSA algorithm](https://www.youtube.com/watch?v=Py06YA4dfKE) - from CS50's videos.

# General topics

- [Numberphile](https://www.youtube.com/user/numberphile/) (channel) - _"Videos about numbers - it's that simple."_

## Linear algebra

- Beginner
  - [Essence of linear algebra](https://www.youtube.com/watch?v=fNk_zzaMoSs&list=PLZHQObOWTQDPD3MizzM2xVFitgF8hE_ab) (playlist) - 3Blue1Brown
- More advanced
  - [A first course in Linear Algebra - N J Wildberger](https://www.youtube.com/course?list=EC44B6B54CBF6A72DF) (playlist) - UNSWelearning
  - [IIT Madras - Linear Algebra](https://www.youtube.com/playlist?list=PLbMVogVj5nJQ2vsW_hmyvVfO4GYWaaPp7) (playlist) - NPTEL
  - [MIT 18.06 Linear Algebra (2005)](https://www.youtube.com/watch?v=ZK3O402wf1c&list=PLE7DDD91010BC51F8) (playlist) - MIT OpenCourseWare
  - [MIT 18.06SC Linear Algebra (2011)](https://www.youtube.com/watch?v=hNDFwVVKVk0&list=PL221E2BBF13BECF6C) (playlist) - MIT OpenCourseWare

## Modular arithmetic

- [Lecture 2: Modular Arithmetic and Historical Ciphers](https://www.youtube.com/watch?v=W1SY6qKZrUk) - Christof Paar
- [Modular Arithmetic and Algorithms](https://www.youtube.com/watch?v=akfFEj7oTn0&list=PLjyyswMG9g9A0bI2SLnIiWANzSKrEuVYK) (playlist) - Samuel Chukwuemeka

## Numerical analysis

- [IIT Bombay – Elementary Numerical Analysis](https://www.youtube.com/playlist?list=PLbMVogVj5nJTtsC5V9n452YKc4mJAhrmm) (playlist) - NPTEL

## Probability & statistics

- [CrashCourse Statistics](https://www.youtube.com/watch?v=zouPoc49xbk&list=PL8dPuuaLjXtNM_Y-bUAhblSAdWRnmBUcr) (playlist) - CrashCourse
- [Introduction to probability](https://www.youtube.com/watch?v=1uW3qMFA9Ho&list=PLUl4u3cNGP60hI9ATjSFgLZpbNJ7myAg6) (playlist) - MIT OpenCourseWare
- [MIT 6.041SC Probabilistic Systems Analysis and Applied Probability (2010)](https://www.youtube.com/watch?v=j9WZyLZCBzs&list=PLUl4u3cNGP60A3XMwZ5sep719_nh95qOe) (playlist) - MIT OpenCourseWare
- [Probabilistic Systems Analysis and Applied Probability (2011)](https://www.youtube.com/watch?v=j9WZyLZCBzs&list=PLUl4u3cNGP61MdtwGTqZA0MreSaDybji8) (playlist) - MIT OpenCourseWare
- [Probability for Math Science: UCLA Math 3C](https://www.youtube.com/playlist?list=PL5BE09709EECF36AA) (playlist) - UCLACourses
- [Statistical Methods for Scientists and Engineers](https://www.youtube.com/playlist?list=PLbMVogVj5nJTwfajxAvmxttpDktlmMDp_) (playlist) - NPTEL
- [Statistics 110: Probability](https://www.youtube.com/watch?v=KbB0FjPg0mw&t=0s&list=PL2SOU6wwxB0uwwH80KTQ6ht66KWxbzTIo) (playlist) - Harvard University

## Real analysis

- [Real Analysis: Lectures by Professor Francis Su](https://www.youtube.com/playlist?list=PL0E754696F72137EC) (playlist) - Francis Su
- [Real Analysis](https://www.youtube.com/playlist?list=PLbMVogVj5nJSxFihV-ec4A3z_FOGPRCo-) (playlist) - NPTEL

## Regression Analysis

- [IIT Madras – Regression analysis](https://www.youtube.com/playlist?list=PLbMVogVj5nJSpj5sl-8tdKARg1lw2wEa-) (playlist) - NPTEL

## Topology

- [Algebraic Topology: a beginner's course - N J Wildberger](https://www.youtube.com/course?list=EC41FDABC6AA085E78) (playlist) - UNSWelearning
- [IIT Madras – Topology](https://www.youtube.com/playlist?list=PLbMVogVj5nJRR7zYZifYopb52zjoScx1d) (playlist) - NPTEL

## Trigonometry

- [Rational Trigonometry--- N J Wildberger](https://www.youtube.com/watch?v=GGj399xIssQ&list=PLD6BAC8FA4287A3DD) (playlist) - njwildberger

# Programming

## Android

- [CSSE490: Android Development (Winter 10-11)](https://www.youtube.com/playlist?list=PLBK7yyieyrAYdpaF5Vh1th9EoM49VLFEs) (playlist) - Rose-Hulman Online

## C

- Beginner
  - [C Programming Tutorial for Beginners](https://www.youtube.com/watch?v=KJgsSFOSQv0) [3h46m] - freeCodeCamp.org

## C&#35;

- [Create a C# Application from Start to Finish - Complete Course](https://www.youtube.com/watch?v=wfWxdh-_k_4) [24h00m] - Literally a course you can take in 24 hours... If you don't sleep. - freeCodeCamp.org

## C&#43;&#43;

- Beginner
  - [C++ Object Oriented Programming Video Tutorial](https://www.youtube.com/watch?v=xnh7ip5gpzc&list=PLfVsf4Bjg79DLA5K3GLbIwf3baNVFO2Lq)
  - [C++ Tutorial for Beginners - Full Course](https://www.youtube.com/watch?v=vLnPwxZdW4Y) [4h01m] - freeCodeCamp.org

## JavaScript

- Beginner

  - [JavaScript Crash Course For Beginners](https://www.youtube.com/watch?v=hdI2bqOjy3c) [1h40m] - Traversy Media
  - [JavaScript ES6 Tutorial - JavaScript from Basic to Advanced - Build Real World Applications Part 1](https://www.youtube.com/watch?v=wbJWUWJWlaY) [7h09m] - Code Geek
  - [JavaScript ES6 Tutorial - JavaScript from Basic to Advanced - Build Real World Applications Part 2](https://www.youtube.com/watch?v=t8P6FELv71A) [8h51m] - Code Geek
  - [JavaScript Tutorial for Beginners: Learn JavaScript Basics in 1 Hour](https://www.youtube.com/watch?v=W6NZfCO5SIk) [48m16s] - Programming with Mosh
  - [Learn JavaScript - Full Course for Beginners](https://www.youtube.com/watch?v=PkZNo7MFNFg) [3h26m] - freeCodeCamp.org
  - [p5.js – The Coding Train](https://www.youtube.com/user/shiffman/playlists) (playlists) - Channel from Daniel Shiffman, a board member of `p5.js`.

- More advanced
  - [ECMAScript 6 / ES6 New Features](https://www.youtube.com/watch?v=ZJZfIw3P8No&list=PL6gx4Cwl9DGBhgcpA8eTYYWg7im72LgLt) (playlist) - thenewboston
  - [Node.js Crash Course](https://www.youtube.com/watch?v=fBNz5xF-Kx4) [1h30m] - Traversy Media

## PHP

- [PHP Programming Language - Full Course](https://www.youtube.com/watch?v=OK_JCtrrv-c) [4h37m] - freeCodeCamp.org

## Python

- Beginner

  - [Introduction to Computer Science and Programming in Python](https://www.youtube.com/watch?v=ytpJdnlu9ug&list=PLUl4u3cNGP63WbdFxL8giv4yhgdMGaZNA) (playlist) - MIT OpenCourseWare
  - [Introduction to Python 3 Programming Tutorial](https://www.youtube.com/watch?v=eXBD2bB9-RA&list=PLQVvvaa0QuDeAams7fkdcwOGBpGdHpXln) (playlist) - sentdex
  - [Python Programming Tutorials Computer Science](https://www.youtube.com/watch?v=bY6m6_IIN94&list=PLi01XoE8jYohWFPpC17Z-wWhPOSuh8Er-) (playlist) - Socratica
  - [Python Tutorial for Absolute Beginners](https://www.youtube.com/watch?v=Z1Yd7upQsXY&list=PLBZBJbE_rGRWeh5mIBhD-hhDwSEDxogDg) (playlist) - CS Dojo
  - [Python Tutorials](https://www.youtube.com/watch?v=YYXdXT2l-Gg&list=PL-osiE80TeTt2d9bfVyTiXJA-UTHn6WwU) (playlist) - Corey Schafer
  - [Learn Python - Full Course for Beginners](https://www.youtube.com/watch?v=rfscVS0vtbw) [4h27m] - freeCodeCamp.org
  - [Python Tutorial for Beginners - Full Python Programming Course](https://www.youtube.com/watch?v=_uQrJ0TkZlc) [6h14m] - Programming with Mosh

- More advanced
  - Machine learning & deep learning
    - [sentdex](https://www.youtube.com/user/sentdex/) (channel)
  - Web development with Python
    - [Corey Schafer](https://www.youtube.com/channel/UCCezIgC97PvUuR4_gbFUs5g) (channel)

## SQL

- Beginner
  - [SQL - Full course for beginners](https://www.youtube.com/watch?v=HXV3zeQKqGY) [4h20m] - freeCodeCamp.org
  - [SQL Computer Science](https://www.youtube.com/watch?v=nWyyDHhTxYU&list=PLi01XoE8jYojRqM4qGBF1U90Ee1Ecb5tt) (playlist) - Socratica

### PostgreSQL

- Beginner
  - [Learn PostgreSQL - Full Course for Beginners](https://www.youtube.com/watch?v=qw--VYLpxG4) [4h19m] - freeCodeCamp.org

## Web development

- [Web Development Tutorial For Beginners](https://www.youtube.com/watch?v=gQojMIhELvM&list=PLoYCgNOIyGABDU532eesybur5HPBVfC1G) (playlist) - LearnCode.academy
- [Learn HTML/CSS](https://www.youtube.com/watch?v=iHZWS61Vyxk&list=PLMvLDJ7usmZDSg1z0X--3qz38IHjdieXR) (playlist) - Neil Rowe

### CSS

- [Bootstrap Grid - CSS Grids Series](https://www.youtube.com/watch?v=Dwzw3hzYcNU&list=PLqGj3iMvMa4IPwMW-sSXn1Q_pVu5tUMCw) (playlist) - DevTips

# Software engineering

- [Engineer Man](https://www.youtube.com/channel/UCrUL8K81R4VBzm-KOYwrcxQ) (channel) - _"I make fun and informative software engineering videos for a globally diverse audience on topics like JavaScript, Python, C, and Linux._"

# Study skills

- [CrashCourse Study Skills](https://www.youtube.com/playlist?list=PL8dPuuaLjXtNcAJRf3bE1IJU6nMfHj86W) (playlist) - CrashCourse

# Virtual reality

- [CS - Virtual Reality](https://www.youtube.com/playlist?list=PLbMVogVj5nJSyt80VRXYC-YrAvQuUb6dh) (playlist) - NPTEL
