/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeUPT;

public class TDSPatch {
    static final int S_NORMAL_PATCH = 0;
    static final int S_SIMPLE_PATCH = 1;
    int typeId;
    OracleType owner;
    long position;
    int uptCode;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Fri_Sep_29_09:42:25_PDT_2006";

    public TDSPatch(int n, OracleType oracleType, long l, int n2) throws SQLException {
        this.typeId = n;
        this.owner = oracleType;
        this.position = l;
        this.uptCode = n2;
    }

    int getType() throws SQLException {
        return this.typeId;
    }

    OracleNamedType getOwner() throws SQLException {
        return (OracleNamedType)this.owner;
    }

    long getPosition() throws SQLException {
        return this.position;
    }

    byte getUptTypeCode() throws SQLException {
        return (byte)this.uptCode;
    }

    void apply(OracleType oracleType) throws SQLException {
        this.apply(oracleType, -1);
    }

    void apply(OracleType oracleType, int n) throws SQLException {
        if (this.typeId == 0) {
            OracleTypeUPT oracleTypeUPT = (OracleTypeUPT)this.owner;
            oracleTypeUPT.realType = (OracleTypeADT)oracleType;
            if (oracleType instanceof OracleNamedType) {
                OracleNamedType oracleNamedType = (OracleNamedType)oracleType;
                oracleNamedType.setParent(oracleTypeUPT.getParent());
                oracleNamedType.setOrder(oracleTypeUPT.getOrder());
            }
        } else if (this.typeId == 1) {
            OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)this.owner;
            oracleTypeCOLLECTION.opcode = n;
            oracleTypeCOLLECTION.elementType = oracleType;
            if (oracleType instanceof OracleNamedType) {
                OracleNamedType oracleNamedType = (OracleNamedType)oracleType;
                oracleNamedType.setParent(oracleTypeCOLLECTION);
                oracleNamedType.setOrder(1);
            }
        } else {
            DatabaseError.throwSqlException(1);
        }
    }
}

