/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Counts;
import fit.FitProtocol;
import fit.Fixture;
import fit.FixtureListener;
import fit.Parse;
import fit.exception.FitParseException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import util.CommandLine;
import util.FileUtil;
import util.StreamReader;

public class FitServer {
    public String input;
    public Fixture fixture = new Fixture();
    public FixtureListener fixtureListener = new TablePrintingFixtureListener();
    private Counts counts = new Counts();
    private OutputStream socketOutput;
    private StreamReader socketReader;
    private boolean verbose = false;
    private String host;
    private int port;
    private int socketToken;
    private Socket socket;
    private boolean noExit;
    private boolean sentinel;

    public FitServer(String host, int port, boolean verbose) {
        this.host = host;
        this.port = port;
        this.verbose = verbose;
    }

    public FitServer() {
    }

    public static void main(String[] argv) throws Exception {
        FitServer fitServer = new FitServer();
        fitServer.run(argv);
        if (!fitServer.noExit) {
            System.exit(fitServer.exitCode());
        }
    }

    public void run(String[] argv) throws Exception {
        this.args(argv);
        File sentinelFile = null;
        if (this.sentinel) {
            String sentinelName = FitServer.sentinelName(this.port);
            sentinelFile = new File(sentinelName);
            sentinelFile.createNewFile();
        }
        this.establishConnection();
        this.validateConnection();
        this.process();
        this.closeConnection();
        if (this.sentinel) {
            FileUtil.deleteFile(sentinelFile);
        }
        this.exit();
    }

    public static String sentinelName(int thePort) {
        return String.format("fitserverSentinel%d", thePort);
    }

    public void closeConnection() throws IOException {
        this.socket.close();
    }

    public void process() {
        this.fixture.listener = this.fixtureListener;
        try {
            int size = 1;
            while ((size = FitProtocol.readSize(this.socketReader)) != 0) {
                try {
                    this.print("processing document of size: " + size + "\n");
                    String document = FitProtocol.readDocument(this.socketReader, size);
                    Parse tables = new Parse(document);
                    this.newFixture().doTables(tables);
                    this.print("\tresults: " + this.fixture.counts() + "\n");
                    this.counts.tally(this.fixture.counts);
                }
                catch (FitParseException e) {
                    this.exception(e);
                }
            }
            this.print("completion signal recieved\n");
        }
        catch (Exception e) {
            this.exception(e);
        }
    }

    public String readDocument() throws Exception {
        int size = FitProtocol.readSize(this.socketReader);
        return FitProtocol.readDocument(this.socketReader, size);
    }

    protected Fixture newFixture() {
        this.fixture = new Fixture();
        this.fixture.listener = this.fixtureListener;
        return this.fixture;
    }

    public void args(String[] argv) {
        CommandLine commandLine = new CommandLine("[-v][-x][-s] host port socketToken");
        if (commandLine.parse(argv)) {
            this.host = commandLine.getArgument("host");
            this.port = Integer.parseInt(commandLine.getArgument("port"));
            this.socketToken = Integer.parseInt(commandLine.getArgument("socketToken"));
            this.verbose = commandLine.hasOption("v");
            this.noExit = commandLine.hasOption("x");
            this.sentinel = commandLine.hasOption("s");
        } else {
            this.usage();
        }
    }

    private void usage() {
        System.out.println("usage: java fit.FitServer [-v] host port socketTicket");
        System.out.println("\t-v\tverbose");
        System.exit(-1);
    }

    protected void exception(Exception e) {
        this.print("Exception occurred!\n");
        this.print("\t" + e.getMessage() + "\n");
        Parse tables = new Parse("span", "Exception occurred: ", null, null);
        this.fixture.exception(tables, e);
        ++this.counts.exceptions;
        this.fixture.listener.tableFinished(tables);
        this.fixture.listener.tablesFinished(this.counts);
    }

    public void exit() throws Exception {
        this.print("exiting\n");
        this.print("\tend results: " + this.counts.toString() + "\n");
    }

    public int exitCode() {
        return this.counts.wrong + this.counts.exceptions;
    }

    public void establishConnection() throws Exception {
        this.establishConnection(this.makeHttpRequest());
    }

    public void establishConnection(String httpRequest) throws Exception {
        this.socket = new Socket(this.host, this.port);
        this.socketOutput = this.socket.getOutputStream();
        this.socketReader = new StreamReader(this.socket.getInputStream());
        byte[] bytes = httpRequest.getBytes("UTF-8");
        this.socketOutput.write(bytes);
        this.socketOutput.flush();
        this.print("http request sent\n");
    }

    private String makeHttpRequest() {
        return "GET /?responder=socketCatcher&ticket=" + this.socketToken + " HTTP/1.1\r\n\r\n";
    }

    public void validateConnection() throws Exception {
        this.print("validating connection...");
        int statusSize = FitProtocol.readSize(this.socketReader);
        if (statusSize == 0) {
            this.print("...ok\n");
        } else {
            String errorMessage = FitProtocol.readDocument(this.socketReader, statusSize);
            this.print("...failed because: " + errorMessage + "\n");
            System.out.println("An error occurred while connecting to client.");
            System.out.println(errorMessage);
            System.exit(-1);
        }
    }

    public Counts getCounts() {
        return this.counts;
    }

    private void print(String message) {
        if (this.verbose) {
            System.out.print(message);
        }
    }

    public static byte[] readTable(Parse table) throws Exception {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)byteBuffer, "UTF-8");
        PrintWriter writer = new PrintWriter(streamWriter);
        Parse more = table.more;
        table.more = null;
        if (table.trailer == null) {
            table.trailer = "";
        }
        table.print(writer);
        table.more = more;
        writer.close();
        return byteBuffer.toByteArray();
    }

    public void writeCounts(Counts count) throws IOException {
        FitProtocol.writeCounts(this.counts, this.socketOutput);
    }

    class TablePrintingFixtureListener
    implements FixtureListener {
        TablePrintingFixtureListener() {
        }

        public void tableFinished(Parse table) {
            try {
                byte[] bytes = FitServer.readTable(table);
                if (bytes.length > 0) {
                    FitProtocol.writeData(bytes, FitServer.this.socketOutput);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void tablesFinished(Counts count) {
            try {
                FitProtocol.writeCounts(count, FitServer.this.socketOutput);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

