/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Counts;
import fit.FitProtocol;
import fit.Fixture;
import fit.FixtureListener;
import fit.Parse;
import fit.exception.FitParseException;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import util.StreamReader;

public abstract class FitServerBridge {
    public String input;
    public Fixture fixture = new Fixture();
    public FixtureListener fixtureListener = new TablePrintingFixtureListener();
    private Counts counts = new Counts();
    protected OutputStream socketOutput;
    private StreamReader socketReader;
    private boolean verbose = false;
    private String host;
    private int port;
    private int socketToken;
    private Socket socket;
    protected int numberOfPages = 0;
    protected boolean showAllReports = false;
    private boolean exit = true;
    protected boolean sentinel;
    public static String FITNESSE_URL = "";

    public FitServerBridge(String host, int port, boolean verbose) {
        this.setFitNesseUrl(host, port);
        this.verbose = verbose;
    }

    public FitServerBridge() {
    }

    public boolean isExit() {
        return this.exit;
    }

    private void setFitNesseUrl(String host, int port) {
        this.host = host;
        this.port = port;
        FITNESSE_URL = "http://" + host + ":" + port + "/";
    }

    protected String fitNesseUrl() {
        return this.host + ":" + this.port;
    }

    public void run(String[] argv) throws Exception {
        this.args(argv);
        this.establishConnection();
        this.validateConnection();
        this.process();
        this.closeConnection();
        this.exit();
    }

    public void closeConnection() throws IOException {
        this.socket.close();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process() {
        this.fixture.listener = this.fixtureListener;
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                this.print("FitServerBridge: Reading size...");
                size = FitProtocol.readSize(this.socketReader);
                this.print("FitServerBridge: Size is " + size);
                if (size == 0) {
                    this.print("FitServerBridge: Completion signal received");
                    return;
                }
                try {
                    this.print("FitServerBridge: Processing document of size: " + size);
                    document = FitProtocol.readDocument(this.socketReader, size);
                    this.doTables(document);
                    this.print("\tresults: " + this.fixture.counts() + "\n");
                    this.counts.tally(this.fixture.counts);
                    ++this.numberOfPages;
                }
                catch (FitParseException e) {
                    this.exception(e);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.exception(e);
        }
        ** GOTO lbl-1000
    }

    public abstract void doTables(String var1);

    public String readDocument() throws Exception {
        int size = FitProtocol.readSize(this.socketReader);
        return FitProtocol.readDocument(this.socketReader, size);
    }

    public void args(String[] argv) {
        this.printArgs(argv);
        int i = this.gatherOptions(argv);
        String hostName = argv[i++];
        int portNo = Integer.parseInt(argv[i++]);
        this.setFitNesseUrl(hostName, portNo);
        this.socketToken = Integer.parseInt(argv[i++]);
    }

    private int gatherOptions(String[] argv) {
        int i = 0;
        while (argv[i].startsWith("-")) {
            String arg = argv[i];
            if ("-v".equals(arg)) {
                this.verbose = true;
            } else if ("-x".equals(arg)) {
                this.exit = false;
            } else if ("-s".equals(arg)) {
                this.sentinel = true;
            } else {
                this.usage();
            }
            ++i;
        }
        return i;
    }

    private void printArgs(String[] argv) {
        String result = "Arguments: ";
        for (String s : argv) {
            result = result + s + " ";
        }
        this.print(result);
    }

    protected void usage() {
        System.out.println("usage: java fit.FitServer [-v] host port socketTicket");
        System.out.println("\t-v\tverbose");
        System.exit(-1);
    }

    protected void exception(Exception e) {
        this.printExceptionDetails(e);
        Parse tables = new Parse("span", "Exception occurred: ", null, null);
        this.fixture.exception(tables, e);
        ++this.counts.exceptions;
        this.fixture.listener.tableFinished(tables);
        this.fixture.listener.tablesFinished(this.counts);
    }

    public void printExceptionDetails(Exception e) {
        this.print("FitServerBridge: Exception: " + e.getMessage());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(out));
        this.print(out.toString() + "\n");
    }

    public void exit() throws Exception {
        this.print("FitServerBridge: exiting");
        this.print("FitServerBridge: end results: " + this.counts.toString());
    }

    public int exitCode() {
        return this.counts.wrong + this.counts.exceptions;
    }

    public void establishConnection() throws Exception {
        this.establishConnection(this.makeHttpRequest());
    }

    public void establishConnection(String httpRequest) throws Exception {
        this.print("FitServerBridge: Connecting to " + this.host + " : " + this.port);
        this.socket = new Socket(this.host, this.port);
        this.print("FitServerBridge: Connected");
        this.socketOutput = this.socket.getOutputStream();
        this.socketReader = new StreamReader(this.socket.getInputStream());
        byte[] bytes = httpRequest.getBytes("UTF-8");
        this.socketOutput.write(bytes);
        this.socketOutput.flush();
        this.print("http request sent");
    }

    private String makeHttpRequest() {
        return "GET /?responder=socketCatcher&ticket=" + this.socketToken + " HTTP/1.1\r\n\r\n";
    }

    public void validateConnection() throws Exception {
        this.print("FitServerBridge: Validating connection...");
        int statusSize = FitProtocol.readSize(this.socketReader);
        if (statusSize == 0) {
            this.print("FitServerBridge: ...ok");
        } else {
            String errorMessage = FitProtocol.readDocument(this.socketReader, statusSize);
            this.print("...failed because: " + errorMessage + "\n");
            System.out.println("An error occured while connecting to client.");
            System.out.println(errorMessage);
            System.exit(-1);
        }
    }

    public Counts getCounts() {
        return this.counts;
    }

    public void print(String message) {
        if (this.verbose) {
            System.out.println(message);
            try {
                FileWriter fileWriter = new FileWriter("running.txt", true);
                fileWriter.write(message + "\n");
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static byte[] readTable(Parse table) throws Exception {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)byteBuffer, "UTF-8");
        PrintWriter writer = new PrintWriter(streamWriter);
        Parse more = table.more;
        table.more = null;
        if (table.trailer == null) {
            table.trailer = "";
        }
        table.print(writer);
        table.more = more;
        writer.close();
        return byteBuffer.toByteArray();
    }

    public void writeCounts(Counts count) throws IOException {
        FitProtocol.writeCounts(this.counts, this.socketOutput);
    }

    public void showAllReports() {
        this.showAllReports = true;
    }

    public static void setFitNesseUrl(String url) {
        FITNESSE_URL = url;
    }

    class TablePrintingFixtureListener
    implements FixtureListener {
        TablePrintingFixtureListener() {
        }

        public void tableFinished(Parse table) {
            try {
                byte[] bytes = FitServerBridge.readTable(table);
                if (bytes.length > 0) {
                    FitProtocol.writeData(bytes, FitServerBridge.this.socketOutput);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void tablesFinished(Counts count) {
            try {
                FitProtocol.writeCounts(count, FitServerBridge.this.socketOutput);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

