/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import fit.Parse;
import fitlibrary.exception.classes.ConstructorNotVisible;
import fitlibrary.exception.classes.NoNullaryConstructor;
import fitlibrary.exception.classes.UnknownClassException;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.utility.ClassUtility;
import fitlibrary.utility.TestResults;

public class FixtureBridge
extends Fixture {
    public Object firstObject(Parse tables, TestResults results) {
        if (tables != null) {
            return this.getFixture(new Table(tables.at(0)), results);
        }
        return null;
    }

    public Object getFixture(Table table, TestResults results) {
        Cell headingCell = table.row(0).cell(0);
        try {
            String className = headingCell.text().replaceAll(" ", "");
            try {
                Fixture fixture = FixtureBridge.loadFixture(className);
                fixture.counts = this.counts;
                fixture.summary = this.summary;
                fixture.args = this.getArgsForTable(table.row(0));
                return fixture;
            }
            catch (Exception e) {
                try {
                    return ClassUtility.newInstance(className);
                }
                catch (NoSuchMethodException ex) {
                    throw new NoNullaryConstructor(className);
                }
                catch (ClassNotFoundException ex) {
                    if (ex.getCause() != null) {
                        throw new UnknownClassException(className + ": " + ex.getCause().getLocalizedMessage());
                    }
                    throw new UnknownClassException(className);
                }
                catch (InstantiationException ex) {
                    throw new NoNullaryConstructor(className);
                }
                catch (IllegalAccessException ex) {
                    throw new ConstructorNotVisible(className);
                }
            }
        }
        catch (Throwable e) {
            headingCell.error(results, e);
            return null;
        }
    }

    String[] getArgsForTable(Row row) {
        String[] arguments = new String[row.size() - 1];
        for (int i = 1; i < row.size(); ++i) {
            arguments[i - 1] = row.text(i, null);
        }
        return arguments;
    }
}

