/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.exception.FitParseException;
import java.io.PrintWriter;

public class Parse {
    public String leader;
    public String tag;
    public String body;
    public String end;
    public String trailer;
    public Parse more;
    public Parse parts;
    public static String[] tags = new String[]{"table", "tr", "td"};

    public Parse(String tag, String body, Parse parts, Parse more) {
        this.leader = "\n";
        this.tag = "<" + tag + ">";
        this.body = body;
        this.end = "</" + tag + ">";
        this.trailer = "";
        this.parts = parts;
        this.more = more;
    }

    public Parse(String text) throws FitParseException {
        this(text, tags, 0, 0);
    }

    public Parse(String text, String[] tags) throws FitParseException {
        this(text, tags, 0, 0);
    }

    public Parse(String text, String[] tags, int level, int offset) throws FitParseException {
        String lc = text.toLowerCase();
        int startTag = lc.indexOf("<" + tags[level]);
        int endTag = lc.indexOf(">", startTag) + 1;
        int startEnd = Parse.findMatchingEndTag(lc, endTag, tags[level], offset);
        int endEnd = lc.indexOf(">", startEnd) + 1;
        int startMore = lc.indexOf("<" + tags[level], endEnd);
        if (startTag < 0 || endTag < 0 || startEnd < 0 || endEnd < 0) {
            throw new FitParseException("Can't find tag: " + tags[level], offset);
        }
        this.leader = text.substring(0, startTag);
        this.tag = text.substring(startTag, endTag);
        this.body = text.substring(endTag, startEnd);
        this.end = text.substring(startEnd, endEnd);
        this.trailer = text.substring(endEnd);
        if (level + 1 < tags.length) {
            this.parts = new Parse(this.body, tags, level + 1, offset + endTag);
            this.body = null;
        } else {
            int index = this.body.indexOf("<" + tags[0]);
            if (index >= 0) {
                this.parts = new Parse(this.body, tags, 0, offset + endTag);
                this.body = "";
            }
        }
        if (startMore >= 0) {
            this.more = new Parse(this.trailer, tags, level, offset + endEnd);
            this.trailer = null;
        }
    }

    protected static int findMatchingEndTag(String lc, int matchFromHere, String tag, int offset) throws FitParseException {
        int fromHere = matchFromHere;
        int count = 1;
        int startEnd = 0;
        while (count > 0) {
            int embeddedTag = lc.indexOf("<" + tag, fromHere);
            int embeddedTagEnd = lc.indexOf("</" + tag, fromHere);
            if (embeddedTag < 0 && embeddedTagEnd < 0) {
                throw new FitParseException("Can't find tag: " + tag, offset);
            }
            if (embeddedTag < 0) {
                embeddedTag = Integer.MAX_VALUE;
            }
            if (embeddedTagEnd < 0) {
                embeddedTagEnd = Integer.MAX_VALUE;
            }
            if (embeddedTag < embeddedTagEnd) {
                ++count;
                startEnd = embeddedTag;
                fromHere = lc.indexOf(">", embeddedTag) + 1;
                continue;
            }
            if (embeddedTagEnd >= embeddedTag) continue;
            --count;
            startEnd = embeddedTagEnd;
            fromHere = lc.indexOf(">", embeddedTagEnd) + 1;
        }
        return startEnd;
    }

    public int size() {
        return this.more == null ? 1 : this.more.size() + 1;
    }

    public Parse last() {
        return this.more == null ? this : this.more.last();
    }

    public Parse leaf() {
        return this.parts == null ? this : this.parts.leaf();
    }

    public Parse at(int i) {
        return i == 0 || this.more == null ? this : this.more.at(i - 1);
    }

    public Parse at(int i, int j) {
        return this.at((int)i).parts.at(j);
    }

    public Parse at(int i, int j, int k) {
        return this.at((int)i, (int)j).parts.at(k);
    }

    public String text() {
        return Parse.unescape(Parse.unformat(this.body)).trim();
    }

    public static String unformat(String s) {
        int j;
        int i = 0;
        while ((i = s.indexOf(60, i)) >= 0 && (j = s.indexOf(62, i + 1)) > 0) {
            s = s.substring(0, i) + s.substring(j + 1);
        }
        return s;
    }

    public static String unescape(String s) {
        StringBuilder sb = new StringBuilder(s);
        int i = -1;
        while ((i = sb.indexOf("&", i + 1)) >= 0) {
            int j = sb.indexOf(";", i + 1);
            if (j <= 0) continue;
            String from = sb.substring(i + 1, j).toLowerCase();
            String to = null;
            to = Parse.replacement(from);
            if (to == null) continue;
            sb.replace(i, j + 1, to);
        }
        return sb.toString();
    }

    public static String replacement(String from) {
        if (from.equals("lt")) {
            return "<";
        }
        if (from.equals("gt")) {
            return ">";
        }
        if (from.equals("amp")) {
            return "&";
        }
        if (from.equals("nbsp")) {
            return " ";
        }
        return null;
    }

    public void addToTag(String text) {
        int last = this.tag.length() - 1;
        this.tag = this.tag.substring(0, last) + text + ">";
    }

    public void addToBody(String text) {
        this.body = this.body + text;
    }

    public void print(PrintWriter out) {
        out.print(this.leader);
        out.print(this.tag);
        if (this.parts != null) {
            this.parts.print(out);
        } else {
            out.print(this.body);
        }
        out.print(this.end);
        if (this.more != null) {
            this.more.print(out);
        } else {
            out.print(this.trailer);
        }
    }
}

