/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator;

import fit.Fixture;
import fit.Parse;
import fit.decorator.exceptions.InvalidInputException;
import fit.decorator.util.Table;
import java.util.ArrayList;

public abstract class FixtureDecorator
extends Fixture {
    static final String ENCAPSULATED_FIXTURE_NAME = "EncapsulatedFixtureName";

    public void doTable(Parse table) {
        if (table.parts.more == null) {
            return;
        }
        this.validateDecoratorInput(table);
        Parse actualHeader = table.parts.more.parts;
        String encapsulatedFixtureName = actualHeader.text();
        this.summary.put(ENCAPSULATED_FIXTURE_NAME, encapsulatedFixtureName);
        Fixture fixture = this.loadFixture(actualHeader, encapsulatedFixtureName);
        if (fixture != null) {
            this.execute(fixture, table);
            this.summary.putAll(fixture.summary);
            this.counts.tally(fixture.counts);
        }
    }

    protected abstract void setupDecorator(String[] var1) throws InvalidInputException;

    protected abstract void updateColumnsBasedOnResults(Parse var1);

    protected void run(Fixture fixture, Parse table) {
        fixture.doTable(table);
    }

    private void execute(Fixture fixture, Parse table) {
        Table t = new Table(table);
        Parse firstRow = t.stripFirstRow();
        this.run(fixture, table);
        t.insertAsFirstRow(firstRow);
        this.updateColumnsBasedOnResults(table);
    }

    private Fixture loadFixture(Parse actualHeader, String encapsulatedFixtureName) {
        Fixture fixture = null;
        try {
            fixture = FixtureDecorator.loadFixture(encapsulatedFixtureName);
        }
        catch (Throwable e) {
            this.exception(actualHeader, e);
        }
        return fixture;
    }

    private void validateDecoratorInput(Parse table) {
        this.setAlternativeArgs(table);
        try {
            this.setupDecorator(this.args);
        }
        catch (InvalidInputException e) {
            this.exception(table.parts, e);
        }
    }

    void setAlternativeArgs(Parse table) {
        ArrayList<String> argumentList = new ArrayList<String>();
        Parse columns = table.parts.parts;
        int size = columns.size();
        for (int i = 0; i < size / 2; ++i) {
            String columnValue = columns.at(i * 2 + 1).text();
            columnValue = this.escapeExpectedAndActualString(columnValue);
            argumentList.add(columnValue);
        }
        this.args = argumentList.toArray(new String[0]);
    }

    private String escapeExpectedAndActualString(String columnValue) {
        int index = columnValue.indexOf("actual");
        if (index == -1) {
            index = columnValue.length();
        }
        return columnValue.substring(0, index);
    }
}

