/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator.performance;

import fit.Fixture;
import fit.Parse;
import fit.decorator.exceptions.InvalidInputException;
import fit.decorator.performance.TimeBasedFixtureDecorator;
import fit.decorator.util.Timer;

public class MaxTime
extends TimeBasedFixtureDecorator {
    public static final String MAX_TIME = "maxTime";
    protected long maxTime;

    public MaxTime() {
    }

    MaxTime(Timer stopWatch) {
        super(stopWatch);
    }

    protected void run(Fixture fixture, Parse table) {
        super.run(fixture, table);
        this.summary.put("actualTimeTaken", new Long(this.elapsedTime));
    }

    protected void setupDecorator(String[] arguments) throws InvalidInputException {
        if (arguments.length != 1) {
            throw new InvalidInputException("Max Time must be specified");
        }
        this.maxTime = Long.parseLong(arguments[0]);
        this.summary.put(MAX_TIME, new Long(this.maxTime));
    }

    protected void updateColumnsBasedOnResults(Parse table) {
        this.updateColumns(table.parts.parts.more, this.elapsedTime, this.maxTime, true);
    }
}

