/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.FixtureBridge;
import fit.Parse;
import fitlibrary.dynamicVariable.DynamicVariables;
import fitlibrary.parser.lookup.ParseDelegation;
import fitlibrary.runtime.RuntimeContext;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.TestResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FitLibraryFixture
extends FixtureBridge
implements Evaluator {
    private Traverse traverse;
    private TypedObject typedObjectUnderTest = Traverse.asTypedObject(null);

    protected void registerParseDelegate(Class<?> type, Class<?> parseDelegate) {
        ParseDelegation.registerParseDelegate(type, parseDelegate);
    }

    protected void registerParseDelegate(Class<?> type, Object parseDelegate) {
        ParseDelegation.registerParseDelegate(type, parseDelegate);
    }

    protected void registerSuperParseDelegate(Class<?> type, Object superParseDelegate) {
        ParseDelegation.registerSuperParseDelegate(type, superParseDelegate);
    }

    public void setSystemUnderTest(Object sut) {
        this.typedObjectUnderTest = Traverse.asTypedObject(sut);
    }

    @Override
    public Object getSystemUnderTest() {
        return this.typedObjectUnderTest.getSubject();
    }

    @Override
    public TypedObject getTypedSystemUnderTest() {
        return this.typedObjectUnderTest;
    }

    @Override
    public void setOuterContext(Evaluator outerContext) {
        this.traverse().setOuterContext(outerContext);
    }

    @Override
    public Evaluator getNextOuterContext() {
        return this.traverse().getNextOuterContext();
    }

    @Override
    public Object getOutermostContext() {
        return this.traverse().getOutermostContext();
    }

    public final Traverse traverse() {
        return this.traverse;
    }

    protected void setTraverse(Traverse traverse) {
        this.traverse = traverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTable(Parse parseTable) {
        Table table = new Table(parseTable);
        TestResults testResults = this.createTestResults();
        try {
            this.setUp(table, testResults);
            this.interpretAfterFirstRow(table, testResults);
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
        finally {
            this.tearDown(table, testResults);
        }
    }

    public void doWithin(Table table, Evaluator evaluator, TestResults testResults) {
        this.setOuterContext(evaluator);
        this.counts = testResults.getCounts();
        this.interpretAfterFirstRow(table, testResults);
    }

    public boolean doEmbeddedTablePasses(Table table, Evaluator evaluator, TestResults testResults) {
        return this.traverse().doesInnerTablePass(table, evaluator, testResults);
    }

    public TestResults createTestResults() {
        return TestResults.create(this.counts);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        this.traverse().setUp(table, testResults);
        Object result = this.traverse().interpretAfterFirstRow(table, testResults);
        this.traverse().tearDown(table, testResults);
        return result;
    }

    @Override
    public RuntimeContext runtime() {
        return this.traverse().runtime();
    }

    public DynamicVariables getDynamicVariables() {
        return this.runtime().dynamicVariables();
    }

    @Override
    public void setRuntimeContext(RuntimeContext propertyValues) {
        this.traverse().setRuntimeContext(propertyValues);
    }

    @Override
    public void setDynamicVariable(String key, Object value) {
        this.traverse().setDynamicVariable(key, value);
    }

    @Override
    public void setUp() throws Exception {
        this.traverse().setUp();
    }

    @Override
    public void setUp(Table firstTable, TestResults testResults) {
        this.traverse().setUp(firstTable, testResults);
    }

    @Override
    public void tearDown(Table firstTable, TestResults testResults) {
        this.traverse().tearDown(firstTable, testResults);
    }

    @Override
    public void tearDown() throws Exception {
        this.traverse().tearDown();
    }
}

