/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fitlibrary.DoFixture;
import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.global.PlugBoard;
import fitlibrary.table.Row;
import fitlibrary.traverse.workflow.DoEvaluator;
import fitlibrary.utility.ClassUtility;
import fitlibrary.utility.TestResults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectFixture
extends DoFixture {
    private Map<String, DoEvaluator> nametoFixture = new HashMap<String, DoEvaluator>();

    public void addAs(String doFixtureClassName, String name) {
        try {
            Object instance = ClassUtility.newInstance(doFixtureClassName);
            if (!(instance instanceof DoEvaluator)) {
                throw new FitLibraryException("Class must be a DoFixture or a DoTraverse");
            }
            DoEvaluator doEval = (DoEvaluator)instance;
            doEval.setRuntimeContext(this.runtime());
            doEval.setUp();
            this.add(doEval, name);
        }
        catch (FitLibraryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FitLibraryException(e);
        }
    }

    public void select(String name) {
        DoEvaluator fixture = this.nametoFixture.get(name);
        if (fixture == null) {
            throw new FitLibraryException("Unknown name");
        }
        this.setSystemUnderTest(fixture);
    }

    public void addNamedFixture(Row row, TestResults testResults) throws Exception {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("addNamedFixture");
        }
        Object result = this.findMethodFromRow(row, 2, less).invokeForSpecial(row.rowFrom(3), testResults, true, row.cell(0));
        if (result instanceof DoEvaluator) {
            this.add((DoEvaluator)result, row.text(1, this));
        } else {
            row.cell(0).failHtml(testResults, "Action did not return a DoFixture/DoTraverse");
        }
    }

    private CalledMethodTarget findMethodFromRow(Row row, int from, int less) throws Exception {
        return this.findMethodByActionName(row.rowFrom(from), row.size() - less);
    }

    private CalledMethodTarget findMethodByActionName(Row row, int allArgs) throws Exception {
        return PlugBoard.lookupTarget.findMethodInEverySecondCell(this, row, allArgs);
    }

    protected void add(DoEvaluator eval, String name) {
        this.nametoFixture.put(name, eval);
    }

    @Override
    public void tearDown() {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (String key : this.nametoFixture.keySet()) {
            try {
                DoEvaluator eval = this.nametoFixture.get(key);
                eval.tearDown();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            throw new FitLibraryException("tearDown errors: " + errors);
        }
    }

    @Override
    public List<String> methodsThatAreVisible() {
        ArrayList<String> list = new ArrayList<String>(super.methodsThatAreVisible());
        list.add("addAs/2");
        list.add("select/1");
        list.add("tearDown/0");
        return list;
    }
}

