/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.batch.fitnesseIn;

import fitlibrary.batch.fitnesseIn.ParallelFitNesseRepository;
import fitlibrary.batch.trinidad.InMemoryTestImpl;
import fitlibrary.batch.trinidad.TestDescriptor;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinedActionLoader
implements Runnable {
    private final String name;
    private final Queue<TestDescriptor> queue;
    private final WikiPage root;
    private final File topFile;

    public DefinedActionLoader(String name, Queue<TestDescriptor> queue, WikiPage root, File topFile) {
        this.name = name;
        this.queue = queue;
        this.root = root;
        this.topFile = topFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            List<String> pages = this.getPageNames();
            PageCrawler crawler = this.root.getPageCrawler();
            crawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
            for (String pageName : pages) {
                String fullPageName = this.name + "." + pageName;
                WikiPagePath path = PathParser.parse(fullPageName);
                WikiPage page = crawler.getPage(this.root, path);
                String html = page.getData().getHtml();
                if (!html.contains("<table")) continue;
                this.queue.add(new InMemoryTestImpl(pageName, html));
            }
        }
        catch (Exception e) {
            this.queue.add(new InMemoryTestImpl("Exception", "error reading suite " + this.name + ": " + e));
            e.printStackTrace();
        }
        finally {
            this.queue.add(ParallelFitNesseRepository.TEST_SENTINEL);
        }
    }

    private List<String> getPageNames() {
        ArrayList<String> pages = new ArrayList<String>();
        this.traverseFolder(this.topFile, this.topFile.getAbsolutePath().length(), pages);
        Collections.sort(pages);
        return pages;
    }

    private void traverseFolder(File file, int prefixLength, List<String> pagesToAccumulate) {
        File[] files;
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.traverseFolder(f, prefixLength, pagesToAccumulate);
                continue;
            }
            if (!f.getName().equals("content.txt")) continue;
            pagesToAccumulate.add(this.pageName(file, prefixLength));
        }
    }

    private String pageName(File file, int prefixLength) {
        String resultingName = file.getAbsolutePath().substring(prefixLength);
        if ("".equals(resultingName)) {
            return resultingName;
        }
        return resultingName.substring(1).replaceAll("\\\\", ".");
    }
}

