/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.batch.fitnesseIn;

import fitlibrary.batch.fitnesseIn.ParallelFitNesseRepository;
import fitlibrary.batch.trinidad.InMemoryTestImpl;
import fitlibrary.batch.trinidad.TestDescriptor;
import fitnesse.FitNesseContext;
import fitnesse.responders.run.SuiteContentsFinder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteLoader
implements Runnable {
    private final String name;
    private final Queue<TestDescriptor> queue;
    private final FitNesseContext context;

    public SuiteLoader(String name, Queue<TestDescriptor> queue, FitNesseContext context) {
        this.name = name;
        this.queue = queue;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            WikiPagePath path = PathParser.parse(this.name);
            PageCrawler crawler = this.context.root.getPageCrawler();
            crawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
            WikiPage suiteRoot = crawler.getPage(this.context.root, path);
            if (!suiteRoot.getData().hasAttribute("Suite")) {
                throw new IllegalArgumentException("page " + this.name + " is not a suite");
            }
            WikiPage root = crawler.getPage(this.context.root, PathParser.parse("."));
            List<WikiPage> pages = new SuiteContentsFinder(suiteRoot, null, root).makePageList();
            for (WikiPage page : pages) {
                if (!this.selects(page)) continue;
                String testName = crawler.getFullPath(page).toString();
                String content = ParallelFitNesseRepository.formatWikiPage(testName, page, null, null, this.context);
                this.queue.add(new InMemoryTestImpl(testName, content));
            }
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            printWriter.close();
            this.queue.add(new InMemoryTestImpl("Exception", "error reading suite " + this.name + ": " + e + "\n" + writer.toString()));
        }
        finally {
            this.queue.add(ParallelFitNesseRepository.TEST_SENTINEL);
        }
    }

    private boolean selects(WikiPage page) throws Exception {
        return page.getData().hasAttribute("Test") || this.isSuiteSetUpOrTearDown(page.getName());
    }

    private boolean isSuiteSetUpOrTearDown(String pageName) throws Exception {
        return pageName.equals("SuiteSetUp") || pageName.equals("SuiteTearDown") || pageName.endsWith(".SuiteSetUp") || pageName.endsWith(".SuiteTearDown");
    }
}

