/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.batch.resultsOut;

import fit.Counts;
import fitlibrary.batch.resultsOut.SuiteResult;
import fitlibrary.batch.trinidad.TestResult;
import fitlibrary.batch.trinidad.TestResultRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FolderTestResultRepository
implements TestResultRepository {
    private final String outputPath;
    private final PrintStream err;
    private final boolean showPasses;

    public FolderTestResultRepository(String outputPath, String suiteName, PrintStream err, boolean showPasses) {
        this.outputPath = FolderTestResultRepository.selectFolderName(outputPath + "/" + suiteName + "/" + FolderTestResultRepository.formattedDateTime());
        new File(this.outputPath).mkdirs();
        this.err = err;
        this.showPasses = showPasses;
        new File(outputPath).mkdirs();
    }

    private static String formattedDateTime() {
        return new SimpleDateFormat("yyyy-MM-dd_HH-mm").format(new Date());
    }

    private static String selectFolderName(String fileName) {
        if (new File(fileName).exists()) {
            for (int i = 1; i < 10000; ++i) {
                String logFileName = fileName + "-" + i;
                if (new File(logFileName).exists()) continue;
                return logFileName;
            }
        }
        return fileName;
    }

    public void recordTestResult(TestResult tr) throws IOException {
        Counts counts = tr.getCounts();
        this.err.println(tr.getName() + " right=" + counts.right + ", wrong=" + counts.wrong + ", ignores=" + counts.ignores + ", exceptions= " + counts.exceptions);
        if (this.showPasses || tr instanceof SuiteResult || counts.wrong + counts.exceptions > 0) {
            String finalPath = new File(this.outputPath, tr.getName() + ".html").getAbsolutePath();
            FileWriter fw = new FileWriter(finalPath);
            String content = tr.getContent();
            content = content.replace("img src=\"/files/images/", "img src=\"");
            fw.write(content);
            fw.close();
        }
    }

    public void addFile(File f, String relativeFilePath) throws IOException {
        this.copy(f, new File(this.outputPath, relativeFilePath));
    }

    private void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

