/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.batch.resultsOut;

import fitlibrary.batch.resultsOut.ParallelSuiteResult;
import fitlibrary.batch.resultsOut.ParallelTestResultRepository;
import fitlibrary.batch.trinidad.TestResult;
import fitlibrary.batch.trinidad.TestResultRepository;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;

public class ParallelFolderTestResultRepository
implements ParallelTestResultRepository {
    static final TestResult SENTINEL = new ParallelSuiteResult("FINISH", false);
    final TestResultRepository testResultRepository;
    final BlockingQueue<TestResult> queue = new LinkedBlockingQueue<TestResult>();
    final CountDownLatch endGate = new CountDownLatch(1);

    public ParallelFolderTestResultRepository(final TestResultRepository testResultRepository, Executor executor) {
        this.testResultRepository = testResultRepository;
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    TestResult result;
                    while ((result = ParallelFolderTestResultRepository.this.queue.take()) != SENTINEL) {
                        testResultRepository.recordTestResult(result);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    ParallelFolderTestResultRepository.this.endGate.countDown();
                }
            }
        });
    }

    public void addFile(File f, String relativeFilePath) throws IOException {
        this.testResultRepository.addFile(f, relativeFilePath);
    }

    public void recordTestResult(TestResult result) throws IOException {
        try {
            this.queue.put(result);
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void closeAndWaitForCompletion() throws InterruptedException {
        this.queue.add(SENTINEL);
        this.endGate.await();
    }
}

