/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.batch.resultsOut;

import fit.Counts;
import fitlibrary.batch.resultsOut.SuiteResult;
import fitlibrary.batch.trinidad.TestResult;
import java.util.Date;

public class ParallelSuiteResult
implements SuiteResult {
    private String name;
    private Counts counts = new Counts();
    private StringBuffer content;
    private boolean showPasses;

    public ParallelSuiteResult(String name, boolean showPasses) {
        this.name = name;
        this.showPasses = showPasses;
        this.content = new StringBuffer("<head><title>").append(name).append("</title><link rel='stylesheet' type='text/css' href='fitnesse.css' media='screen'/><link rel='stylesheet' type='text/css' href='fitnesse_print.css' media='print'/></head><body><h2>").append(name).append("</h2><p>" + new Date()).append("<table><tr><td>Name</td><td>Right</td><td>Wrong</td><td>Exceptions</td></tr>");
    }

    public String getContent() {
        this.appendRow(this, this.counts);
        return this.content + "</table></body></html>";
    }

    public Counts getCounts() {
        return this.counts;
    }

    public String getName() {
        return this.name;
    }

    public void append(TestResult result) {
        Counts resultCounts = result.getCounts();
        this.counts.tally(resultCounts);
        this.appendRow(result, resultCounts);
    }

    private void appendRow(TestResult result, Counts resultCounts) {
        this.content.append("<tr class='").append(this.getCssClass(resultCounts)).append("'><td>");
        this.appendNameOrLink(result);
        this.content.append("</td><td>").append(resultCounts.right).append("</td><td>").append(resultCounts.wrong).append("</td><td>").append(resultCounts.exceptions).append("</td></tr>");
    }

    private void appendNameOrLink(TestResult result) {
        if (this.showPasses || result.getCounts().exceptions + result.getCounts().wrong > 0) {
            this.content.append("<a href='").append(result.getName()).append(".html'>").append(result.getName()).append("</a>");
        } else {
            this.content.append(result.getName());
        }
    }

    private String getCssClass(Counts c) {
        if (c.exceptions > 0) {
            return "error";
        }
        if (c.wrong > 0) {
            return "fail";
        }
        if (c.right > 0) {
            return "pass";
        }
        return "plain";
    }
}

