/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.closure;

import fitlibrary.closure.Closure;
import fitlibrary.closure.MethodTarget;
import fitlibrary.collection.CollectionTraverse;
import fitlibrary.diff.Diff_match_patch;
import fitlibrary.dynamicVariable.RecordDynamicVariables;
import fitlibrary.exception.AbandonException;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.FitLibraryShowException;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.parse.NoValueProvidedException;
import fitlibrary.parser.Parser;
import fitlibrary.parser.collection.ArrayParser;
import fitlibrary.parser.collection.ListParser;
import fitlibrary.parser.collection.MapParser;
import fitlibrary.parser.collection.SetParser;
import fitlibrary.parser.lookup.GetterParser;
import fitlibrary.parser.lookup.ParseDelegation;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.TestResults;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalledMethodTarget
implements MethodTarget {
    private final Closure closure;
    private final Evaluator evaluator;
    private Parser[] parameterParsers;
    protected ResultParser resultParser = null;
    private final Object[] args;
    private String repeatString = null;
    private String exceptionString = null;
    private boolean everySecond = false;

    public CalledMethodTarget(Closure method, Evaluator evaluator) {
        this.closure = method;
        this.evaluator = evaluator;
        this.args = new Object[this.getParameterTypes().length];
        this.parameterParsers = this.closure.parameterParsers(evaluator);
        this.resultParser = this.closure.resultParser(evaluator);
    }

    public CalledMethodTarget(Evaluator evaluator) {
        this.evaluator = evaluator;
        this.parameterParsers = new Parser[0];
        this.args = new Object[0];
        this.closure = null;
        this.resultParser = null;
    }

    public boolean isValid() {
        return this.closure != null;
    }

    private Class<?> getReturnType() {
        return this.closure.getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return this.closure.getParameterTypes();
    }

    public Object invoke(Object[] arguments) throws Exception {
        return this.closure.invoke(arguments);
    }

    public TypedObject invokeTyped(Object[] arguments) throws Exception {
        return this.closure.invokeTyped(arguments);
    }

    public Object invoke(Cell cell, TestResults testResults) throws Exception {
        this.collectCell(cell, 0, cell.text(this.evaluator), testResults, true);
        return this.invoke(this.args);
    }

    public TypedObject invokeTyped(Row row, TestResults testResults, boolean catchParseError) throws Exception {
        try {
            if (this.everySecond) {
                this.collectCells(row, 2, testResults, catchParseError);
            } else {
                this.collectCells(row, 1, testResults, catchParseError);
            }
        }
        catch (AbandonException e) {
            throw new IgnoredException(e);
        }
        catch (Exception e) {
            throw new IgnoredException(e);
        }
        try {
            return this.invokeTyped(this.args);
        }
        catch (AbandonException e) {
            throw new IgnoredException();
        }
    }

    public Object invoke(Row row, TestResults testResults, boolean catchParseError) throws Exception {
        try {
            if (this.everySecond) {
                this.collectCells(row, 2, testResults, catchParseError);
            } else {
                this.collectCells(row, 1, testResults, catchParseError);
            }
        }
        catch (Exception e) {
            throw new IgnoredException(e);
        }
        return this.invoke(this.args);
    }

    public Object invokeForSpecial(Row row, TestResults testResults, boolean catchParseError, Cell operatorCell) throws Exception {
        try {
            if (this.everySecond) {
                this.collectCells(row, 2, testResults, catchParseError);
            } else {
                this.collectCells(row, 1, testResults, catchParseError);
            }
        }
        catch (Exception e) {
            throw new IgnoredException(e);
        }
        try {
            return this.invoke(this.args);
        }
        catch (InvocationTargetException e) {
            Throwable embedded = e.getTargetException();
            if (embedded instanceof FitLibraryShowException) {
                operatorCell.error(testResults);
            }
            throw e;
        }
    }

    private void collectCells(Row row, int step, TestResults testResults, boolean catchParseError) throws Exception {
        for (int argNo = 0; argNo < this.args.length; ++argNo) {
            Cell cell = row.cell(argNo * step);
            this.collectCell(cell, argNo, cell.text(this.evaluator), testResults, catchParseError);
        }
    }

    private void collectCell(Cell cell, int argNo, String text, TestResults testResults, boolean catchParseError) throws Exception {
        try {
            if (!text.equals(this.repeatString)) {
                this.args[argNo] = this.parameterParsers[argNo].parseTyped(cell, testResults).getSubject();
            }
        }
        catch (Exception e) {
            if (catchParseError) {
                cell.error(testResults, e);
                throw new IgnoredException();
            }
            throw e;
        }
    }

    public void invokeAndCheck(Row row, Cell expectedCell, TestResults testResults, boolean handleSubtype) {
        boolean exceptionExpected = this.exceptionIsExpected(expectedCell);
        try {
            Object result = this.invoke(row, testResults, true);
            if (exceptionExpected) {
                expectedCell.fail(testResults);
            } else {
                this.checkResult(expectedCell, result, true, handleSubtype, testResults);
            }
        }
        catch (IgnoredException ex) {
        }
        catch (Exception e) {
            expectedCell.exceptionMayBeExpected(exceptionExpected, e, testResults);
        }
    }

    public void invokeAndCheckForSpecial(Row row, Cell expectedCell, TestResults testResults, Row fullRow, Cell specialCell) {
        boolean exceptionExpected = this.exceptionIsExpected(expectedCell);
        try {
            Object result = this.invoke(row, testResults, true);
            if (RecordDynamicVariables.recording() && expectedCell.unresolved(this.evaluator)) {
                String text = expectedCell.text();
                String key = text.substring(2, text.length() - 1);
                this.evaluator.setDynamicVariable(key, result.toString());
                RecordDynamicVariables.record(key, result.toString());
                expectedCell.pass(testResults, result.toString());
                return;
            }
            if (exceptionExpected) {
                expectedCell.fail(testResults);
            } else {
                this.checkResult(expectedCell, result, true, false, testResults);
            }
        }
        catch (IgnoredException e) {
        }
        catch (InvocationTargetException e) {
            Throwable embedded = e.getTargetException();
            if (embedded instanceof FitLibraryShowException) {
                specialCell.error(testResults);
                fullRow.error(testResults, e);
            } else {
                expectedCell.exceptionMayBeExpected(exceptionExpected, e, testResults);
            }
        }
        catch (Exception e) {
            expectedCell.exceptionMayBeExpected(exceptionExpected, e, testResults);
        }
    }

    private boolean exceptionIsExpected(Cell expectedCell) {
        return this.exceptionString != null && this.exceptionString.equals(expectedCell.text(this.evaluator));
    }

    @Override
    public String getResult() throws Exception {
        return this.resultParser.show(this.invoke());
    }

    @Override
    public boolean invokeAndCheckCell(Cell expectedCell, boolean matchedAlready, TestResults testResults) {
        try {
            return this.checkResult(expectedCell, this.invoke(), matchedAlready, false, testResults);
        }
        catch (Exception e) {
            expectedCell.error(testResults, e);
            return false;
        }
    }

    public Object invoke() throws Exception {
        return this.closure.invoke();
    }

    @Override
    public boolean matches(Cell expectedCell, TestResults testResults) {
        try {
            return this.resultParser.matches(expectedCell, this.invoke(), testResults);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean checkResult(Cell expectedCell, Object result, boolean showWrongs, boolean handleSubtype, TestResults testResults) {
        ResultParser valueParser = this.resultParser;
        if (handleSubtype && this.closure != null) {
            valueParser = this.closure.specialisedResultParser(this.resultParser, result, this.evaluator);
        }
        try {
            if (valueParser == null) {
                throw new NoValueProvidedException();
            }
            if (valueParser.isShowAsHtml()) {
                if (valueParser.matches(expectedCell, result, testResults)) {
                    expectedCell.pass(testResults);
                    return true;
                }
                expectedCell.wrongHtml(testResults, valueParser.show(result));
                return false;
            }
            if (valueParser.matches(expectedCell, result, testResults)) {
                expectedCell.passIfNotEmbedded(testResults);
                return true;
            }
            if (showWrongs && (result == null || !expectedCell.hasEmbeddedTable())) {
                if (result instanceof String) {
                    expectedCell.failWithStringEquals(testResults, valueParser.show(result), this.evaluator);
                } else {
                    expectedCell.fail(testResults, valueParser.show(result), this.evaluator);
                }
            }
            return false;
        }
        catch (Exception e) {
            expectedCell.error(testResults, e);
            return false;
        }
    }

    public static String matching(String expected, String actual) {
        LinkedList<Diff_match_patch.Diff> diffs = new Diff_match_patch().diff_main(expected, actual, true);
        StringBuilder s = new StringBuilder();
        for (Diff_match_patch.Diff diff : diffs) {
            switch (diff.operation) {
                case DELETE: {
                    s.append("<strike>" + diff.text + "</strike>");
                    break;
                }
                case EQUAL: {
                    s.append(diff.text);
                    break;
                }
                case INSERT: {
                    s.append("<b>" + diff.text + "</b>");
                }
            }
        }
        return s.toString();
    }

    public void notResult(Cell expectedCell, Object result, TestResults testResults) {
        try {
            if (this.resultParser == null) {
                throw new NoValueProvidedException();
            }
            if (!this.resultParser.matches(expectedCell, result, testResults)) {
                expectedCell.passIfNotEmbedded(testResults);
            } else if (!expectedCell.hasEmbeddedTable()) {
                expectedCell.fail(testResults);
            }
        }
        catch (Exception e) {
            expectedCell.error(testResults, e);
        }
    }

    public void compare(Cell expectedCell, Comparable actual, TestResults testResults, DoTraverse.Comparison compare) {
        block7: {
            try {
                if (this.resultParser == null) {
                    throw new NoValueProvidedException();
                }
                Object expected = this.resultParser.parseTyped(expectedCell, testResults).getSubject();
                if (expected instanceof Comparable) {
                    if (compare.compares(actual, (Comparable)expected)) {
                        expectedCell.passIfNotEmbedded(testResults);
                    } else if (!expectedCell.hasEmbeddedTable()) {
                        expectedCell.fail(testResults, "" + actual);
                    }
                    break block7;
                }
                throw new FitLibraryException("Unable to compare, as expected value is not Comparable");
            }
            catch (Exception e) {
                expectedCell.error(testResults, e);
            }
        }
    }

    public Object getResult(Cell expectedCell, TestResults testResults) {
        try {
            return this.resultParser.parseTyped(expectedCell, testResults).getSubject();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void color(Row row, boolean right, TestResults testResults) throws Exception {
        if (!this.everySecond && row.cellExists(0)) {
            row.cell(0).passOrFail(testResults, right);
        } else {
            for (int i = 0; i < row.size(); i += 2) {
                row.cell(i).passOrFail(testResults, right);
            }
        }
    }

    public void setRepeatAndExceptionString(String repeatString, String exceptionString) {
        this.repeatString = repeatString;
        this.exceptionString = exceptionString;
    }

    public void setEverySecond(boolean everySecond) {
        this.everySecond = everySecond;
    }

    private Object wrapObjectWithTraverse(TypedObject typedResult) {
        Object result = typedResult.getSubject();
        if (result == null) {
            return null;
        }
        if (this.isPrimitiveReturnType()) {
            return result;
        }
        if (result instanceof String || result instanceof StringBuffer) {
            return result;
        }
        if (result instanceof Evaluator) {
            Evaluator resultEvaluator = (Evaluator)result;
            if (resultEvaluator != this.evaluator && resultEvaluator.getNextOuterContext() == null) {
                return this.withOuter(resultEvaluator);
            }
            return result;
        }
        if (Traverse.getAlienTraverseHandler().isAlienTraverse(result)) {
            return result;
        }
        Class<?> returnType = result.getClass();
        if (MapParser.applicableType(returnType) || ArrayParser.applicableType(returnType)) {
            return this.withOuter(typedResult.traverse(this.evaluator));
        }
        if (SetParser.applicableType(returnType) || ListParser.applicableType(returnType)) {
            CollectionTraverse traverse = (CollectionTraverse)typedResult.traverse(this.evaluator);
            traverse.setActualCollection(result);
            return this.withOuter(traverse);
        }
        if (ParseDelegation.hasParseMethod(returnType)) {
            return result;
        }
        return this.withOuter(new DoTraverse(typedResult));
    }

    private Object withOuter(Evaluator inner) {
        inner.setOuterContext(this.evaluator);
        return inner;
    }

    private boolean isPrimitiveReturnType() {
        Class<?> returnType = this.getReturnType();
        return returnType.isPrimitive() || returnType == Boolean.class || returnType.isInstance(Number.class) || returnType == Character.class;
    }

    public Object invokeAndWrap(Row row, TestResults testResults) throws Exception {
        return this.wrapObjectWithTraverse(this.invokeTyped(row, testResults, true));
    }

    public String getResultString(Object result) throws Exception {
        if (this.getReturnType() == String.class) {
            return (String)result;
        }
        return this.resultParser.show(result);
    }

    public String toString() {
        return "MethodTarget[" + this.closure + "]";
    }

    public Parser getResultParser() {
        return this.resultParser;
    }

    public void setResultParser(GetterParser resultAdapter) {
        this.resultParser = resultAdapter;
    }

    public Parser[] getParameterParsers() {
        return this.parameterParsers;
    }

    public void setParameterParsers(Parser[] parameterAdapters) {
        this.parameterParsers = parameterAdapters;
    }

    @Override
    public void setTypedSubject(TypedObject typedObject) {
        this.closure.setTypedSubject(typedObject);
    }

    public boolean returnsVoid() {
        return this.getReturnType() == Void.TYPE;
    }

    public boolean returnsBoolean() {
        return this.getReturnType() == Boolean.TYPE;
    }
}

