/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.closure;

import fitlibrary.closure.MethodTarget;
import fitlibrary.global.PlugBoard;
import fitlibrary.table.Cell;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.TestResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMethodTarget
implements MethodTarget {
    private Class<?> componentType;
    private Evaluator evaluator;
    private Class<?> actualType;

    public ClassMethodTarget(Class<?> componentType, Evaluator evaluator, TypedObject typedObject) {
        this.componentType = componentType;
        this.evaluator = evaluator;
        this.actualType = typedObject.getClassType();
    }

    @Override
    public void setTypedSubject(TypedObject typedObject) {
    }

    @Override
    public String getResult() throws Exception {
        return this.actualType.getName();
    }

    @Override
    public boolean matches(Cell expectedCell, TestResults testResults) {
        try {
            Class<?> expectedType = PlugBoard.lookupTarget.findClassFromFactoryMethod(this.evaluator, this.componentType, expectedCell.text(this.evaluator));
            return this.actualType == expectedType;
        }
        catch (Exception e) {
            expectedCell.error(testResults, e);
            return false;
        }
    }

    @Override
    public boolean invokeAndCheckCell(Cell expectedCell, boolean matchedAlready, TestResults testResults) {
        try {
            if (this.matches(expectedCell, testResults)) {
                if (matchedAlready) {
                    expectedCell.pass(testResults);
                }
                return true;
            }
            if (matchedAlready) {
                expectedCell.fail(testResults, this.getResult(), this.evaluator);
            }
        }
        catch (Exception e) {
            expectedCell.error(testResults, e);
        }
        return false;
    }

    public String getMethodClass() {
        return "ClassMethodTarget";
    }
}

