/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.closure;

import fitlibrary.closure.Closure;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.TypedObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldClosure
implements Closure {
    private Field field;
    private TypedObject typedObject;

    public FieldClosure(TypedObject typedObject, Field field) {
        this.typedObject = typedObject;
        this.field = field;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return new Class[0];
    }

    @Override
    public Class<?> getReturnType() {
        return this.field.getType();
    }

    @Override
    public Object invoke() throws IllegalAccessException, InvocationTargetException {
        return this.field.get(this.typedObject.getSubject());
    }

    @Override
    public Object invoke(Object[] arguments) throws IllegalAccessException, InvocationTargetException {
        return this.invoke();
    }

    @Override
    public TypedObject invokeTyped(Object[] arguments) throws IllegalAccessException, InvocationTargetException {
        return this.typedObject.asReturnTypedObject(this.invoke(), this.field);
    }

    @Override
    public Parser[] parameterParsers(Evaluator evaluator) {
        return new Parser[0];
    }

    @Override
    public ResultParser resultParser(Evaluator evaluator) {
        return this.typedObject.resultParser(evaluator, this.field);
    }

    @Override
    public ResultParser specialisedResultParser(ResultParser resultParser, Object result, Evaluator evaluator) {
        if (result == null || result.getClass() == this.field.getType()) {
            return resultParser;
        }
        return this.typedObject.resultParser(evaluator, this.field, result.getClass());
    }

    @Override
    public void setTypedSubject(TypedObject typedObject) {
        this.typedObject = typedObject;
    }

    public String toString() {
        return "FieldClosure[" + this.typedObject + "," + this.field + "]";
    }
}

