/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.closure;

import fitlibrary.closure.Closure;
import fitlibrary.exception.method.WrongTypeForMethodException;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.TypedObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodClosure
implements Closure {
    private TypedObject typedObject;
    private Method method;

    public MethodClosure(TypedObject typedObject, Method method) {
        if (typedObject == null || typedObject.getSubject() == null || method == null) {
            throw new RuntimeException("MethodClosure requires non-null args");
        }
        this.typedObject = typedObject;
        this.method = method;
    }

    @Override
    public TypedObject invokeTyped(Object[] args) throws IllegalAccessException, InvocationTargetException {
        return this.typedObject.asReturnTypedObject(this.invoke(args), this.method);
    }

    @Override
    public Object invoke() throws IllegalAccessException, InvocationTargetException {
        return this.invoke(new Object[0]);
    }

    @Override
    public Object invoke(Object[] args) throws IllegalAccessException, InvocationTargetException {
        try {
            return this.method.invoke(this.typedObject.getSubject(), args);
        }
        catch (IllegalArgumentException e) {
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            String expectedType = "(";
            for (int i = 0; i < parameterTypes.length; ++i) {
                expectedType = expectedType + parameterTypes[i].getName() + ", ";
            }
            expectedType = expectedType.substring(0, expectedType.length() - 2);
            expectedType = expectedType + ")";
            String actualType = "(";
            for (int i = 0; i < args.length; ++i) {
                actualType = args[i] == null ? actualType + "null, " : actualType + args[i].getClass().getName() + ", ";
            }
            if (args.length > 0) {
                actualType = actualType.substring(0, actualType.length() - 2);
            }
            actualType = actualType + ")";
            throw new WrongTypeForMethodException(this.method, expectedType, actualType);
        }
    }

    public void setSubject(Object subject) {
        this.typedObject = Traverse.asTypedObject(subject);
    }

    @Override
    public void setTypedSubject(TypedObject typedObject) {
        this.typedObject = typedObject;
    }

    public String toString() {
        return "MethodClosure[" + this.typedObject + "," + this.method + "]";
    }

    @Override
    public ResultParser resultParser(Evaluator evaluator) {
        return this.typedObject.resultParser(evaluator, this.method);
    }

    @Override
    public Parser[] parameterParsers(Evaluator evaluator) {
        return this.typedObject.parameterParsers(evaluator, this.method);
    }

    @Override
    public ResultParser specialisedResultParser(ResultParser resultParser, Object result, Evaluator evaluator) {
        if (result == null || result.getClass() == this.method.getReturnType()) {
            return resultParser;
        }
        return this.typedObject.resultParser(evaluator, this.method, result.getClass());
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }
}

