/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.exception.method.VoidMethodException;
import fitlibrary.exception.table.RowWrongWidthException;
import fitlibrary.global.PlugBoard;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibrary.utility.ExtendedCamelCase;
import fitlibrary.utility.TestResults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionSetUpTraverse
extends DoTraverse {
    protected CalledMethodTarget target;
    protected int argCount = -1;
    protected boolean boundOK = false;
    protected Collection<Object> collection = new ArrayList<Object>();
    protected boolean embedded = false;

    public CollectionSetUpTraverse() {
    }

    public CollectionSetUpTraverse(Collection<Object> collection) {
        this.collection = collection;
    }

    public CollectionSetUpTraverse(Object sut, Collection<Object> collection, boolean embedded) {
        super(sut);
        this.collection = collection;
        this.embedded = embedded;
    }

    public CollectionSetUpTraverse(Object sut) {
        super(sut);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        this.bindFirstRowToTarget(table.row(1), testResults, this);
        for (int i = 2; i < table.size(); ++i) {
            this.processRow(table.row(i), testResults);
        }
        return this.collection;
    }

    @Override
    public Object interpretInFlow(Table table, TestResults testResults) {
        this.setUp(table, testResults);
        try {
            this.interpretAfterFirstRow(table, testResults);
        }
        catch (Exception e) {
            int rowNo = 0;
            if (this.embedded) {
                rowNo = 1;
            }
            table.row(rowNo).error(testResults, e);
        }
        this.tearDown(table, testResults);
        return this.collection;
    }

    public void bindFirstRowToTarget(Row row, TestResults testResults, Evaluator evaluator) {
        try {
            this.argCount = row.size();
            this.target = CollectionSetUpTraverse.findMethodTarget(row, evaluator, this.embedded);
            this.boundOK = true;
        }
        catch (Exception e) {
            row.error(testResults, e);
        }
    }

    private static CalledMethodTarget findMethodTarget(Row row, Evaluator evaluator, boolean embedded) {
        ArrayList<String> arguments = new ArrayList<String>();
        String argNames = CollectionSetUpTraverse.buildArguments(row, arguments, evaluator);
        String methodName = ExtendedCamelCase.camel(argNames);
        CalledMethodTarget findMethod = PlugBoard.lookupTarget.findMethod(methodName, arguments, "ResultType", evaluator);
        if (findMethod.returnsVoid() && embedded) {
            throw new VoidMethodException(methodName, "SetUpTraverse");
        }
        return findMethod;
    }

    private static String buildArguments(Row row, List<String> arguments, Evaluator evaluator) {
        String argNames = "";
        for (int i = 0; i < row.size(); ++i) {
            String name = row.text(i, evaluator);
            argNames = argNames + " " + name;
            arguments.add(ExtendedCamelCase.camel(name));
        }
        return argNames;
    }

    public void processRow(Row row, TestResults testResults) {
        if (!this.boundOK) {
            row.ignore(testResults);
            return;
        }
        if (row.size() != this.argCount) {
            row.error(testResults, new RowWrongWidthException(this.argCount));
            return;
        }
        try {
            this.invokeMethod(row, testResults);
        }
        catch (Exception e) {
            row.error(testResults, e);
        }
    }

    public Object invokeMethod(Row row, TestResults testResults) throws Exception {
        Object result = this.target().invoke(row, testResults, true);
        this.collection.add(result);
        return result;
    }

    public CalledMethodTarget target() {
        return this.target;
    }

    public Collection<Object> getCollection() {
        return this.collection;
    }

    public static boolean hasObjectFactoryMethodFor(Table table, Evaluator evaluator) {
        try {
            CollectionSetUpTraverse.findMethodTarget(table.row(0), evaluator, false);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

