/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection.array;

import fitlibrary.exception.table.RowWrongWidthException;
import fitlibrary.parser.Parser;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.TestResults;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraySetUpTraverse
extends Traverse {
    private Parser valueAdapter;
    private Object array;
    private Class<?> componentType;

    public ArraySetUpTraverse(Class<?> componentType, Parser valueAdapter) {
        this.componentType = componentType;
        this.valueAdapter = valueAdapter;
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        this.array = Array.newInstance(this.componentType, table.size());
        for (int rowNo = 0; rowNo < table.size(); ++rowNo) {
            Row row = table.row(rowNo);
            try {
                if (row.size() != 1) {
                    throw new RowWrongWidthException(1);
                }
                Cell cell = row.cell(0);
                Array.set(this.array, rowNo, this.valueAdapter.parseTyped(cell, testResults).getSubject());
                continue;
            }
            catch (Exception e) {
                row.error(testResults, e);
            }
        }
        return this.array;
    }

    public Object getResults() {
        return this.array;
    }
}

