/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection.map;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.parser.Parser;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.TestResults;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfMapsTraverse
extends Traverse {
    private final List<Map<String, Object>> maps;

    public ListOfMapsTraverse(List<Map<String, Object>> maps) {
        this.maps = maps;
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        Row labelRow = table.row(1);
        for (int r = 2; r < table.size(); ++r) {
            Row row = table.row(r);
            try {
                if (row.size() != labelRow.size()) {
                    row.error(testResults, new FitLibraryException("Row is wrong length"));
                    break;
                }
                int mapNo = r - 2;
                if (mapNo >= this.maps.size()) {
                    throw new FitLibraryException("Extra");
                }
                Map<String, Object> map = this.maps.get(mapNo);
                this.processRow(labelRow, row, map, testResults);
                continue;
            }
            catch (Exception e) {
                row.error(testResults, e);
            }
        }
        return null;
    }

    private void processRow(Row labelRow, Row row, Map<String, Object> map, TestResults testResults) {
        for (int c = 0; c < labelRow.size(); ++c) {
            Cell cell = row.cell(c);
            try {
                String key = labelRow.text(c, this);
                Object value = map.get(key);
                if (value != null) {
                    Parser parser = ListOfMapsTraverse.asTyped(value).parser(this);
                    Object actual = parser.parseTyped(cell, testResults).getSubject();
                    if (parser.matches(cell, value, testResults)) {
                        cell.pass(testResults);
                        continue;
                    }
                    cell.fail(testResults, parser.show(actual));
                    continue;
                }
                if ("".equals(cell.text(this))) {
                    cell.pass(testResults);
                    continue;
                }
                cell.fail(testResults, "");
                continue;
            }
            catch (Exception e) {
                cell.error(testResults, e);
            }
        }
    }
}

