/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection.map;

import fitlibrary.exception.table.RowWrongWidthException;
import fitlibrary.parser.Parser;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.Typed;
import fitlibrary.utility.TestResults;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSetUpTraverse
extends Traverse {
    private Map<Object, Object> theMap = new HashMap<Object, Object>();
    protected Parser keyParser;
    protected Parser valueParser;

    protected MapSetUpTraverse() {
    }

    public MapSetUpTraverse(Typed keyTyped, Typed valueTyped) {
        this.keyParser = keyTyped.parser(this);
        this.valueParser = valueTyped.parser(this);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        try {
            for (int rowNo = 1; rowNo < table.size(); ++rowNo) {
                this.processRow(table.row(rowNo), testResults);
            }
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
        return this.theMap;
    }

    protected void processRow(Row row, TestResults testResults) throws Exception {
        try {
            if (row.size() != 2) {
                throw new RowWrongWidthException(2);
            }
            this.theMap.put(this.keyParser.parseTyped(row.cell(0), testResults).getSubject(), this.valueParser.parseTyped(row.cell(1), testResults).getSubject());
        }
        catch (Exception e) {
            row.error(testResults, e);
        }
    }

    public Map<Object, Object> getResults() {
        return this.theMap;
    }
}

