/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.debug;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class GrabPage {
    private static final String openDiv = "<div";
    private static final String closeDiv = "</div>";
    private String host;

    public GrabPage(String host) {
        this.host = host;
    }

    public String grabPage(String page) throws IOException {
        String s = this.grabBarePage(page);
        s = GrabPage.removeDivClasses("hidden", s);
        s = GrabPage.removeDivClasses("sidebar", s);
        s = GrabPage.removeDivClasses("nav_break", s);
        s = GrabPage.removeDivClasses("header", s);
        s = GrabPage.removeDivClasses("collapse_rim", s);
        s = GrabPage.removeDivStyles("float", s);
        s = GrabPage.removeA("/files", s);
        s = GrabPage.removeA("?searchForm", s);
        s = GrabPage.removeA("javascript:", s);
        s = this.removeSpan("meta", s);
        s = this.removeFooter(s);
        s = this.changePageUrls(s);
        return s;
    }

    public String changePageUrls(String sInitial) {
        int open;
        String s = sInitial;
        String openALink = "<a href=\"";
        String endQuote = "\">";
        String endALink = "</a>";
        int searchFrom = 0;
        while ((open = s.indexOf(openALink, searchFrom)) >= 0) {
            int startOfUrl = open + openALink.length();
            int endOfUrl = s.indexOf(endQuote, startOfUrl);
            String url = s.substring(startOfUrl, endOfUrl);
            int endOfALink = s.indexOf(endALink, endOfUrl + endQuote.length());
            String link = s.substring(endOfUrl + endQuote.length(), endOfALink);
            s = s.substring(0, startOfUrl) + url + endQuote + link + s.substring(endOfALink);
            searchFrom = endOfUrl + url.length() - url.length() + link.length() - link.length();
        }
        return s;
    }

    public String grabBarePage(String page) throws MalformedURLException, IOException {
        int in;
        URL url = new URL(this.extendedName(page));
        BufferedInputStream reader = new BufferedInputStream(url.openStream());
        String s = "";
        while ((in = reader.read()) >= 0) {
            s = s + (char)in;
        }
        reader.close();
        return s;
    }

    private String extendedName(String pageName) {
        if (this.host.endsWith("/")) {
            return this.host + pageName;
        }
        return this.host + "." + pageName;
    }

    private String removeFooter(String s) {
        String openTag = "<hr>(<a href=\"FitLib";
        String closeTag = ".RecentChanges</a>)";
        int open = s.indexOf(openTag);
        if (open < 0) {
            return s;
        }
        int end = s.indexOf(closeTag, open + openTag.length());
        if (end < 0) {
            return s;
        }
        return s.substring(0, open) + s.substring(end + closeTag.length());
    }

    public static String removeA(String link, String s) {
        return GrabPage.removeTag(s, "<a href=\"" + link, "</a>");
    }

    private String removeSpan(String type, String s) {
        return GrabPage.removeTag(s, "<span class=\"" + type, "</span>");
    }

    private static String removeTag(String sInitial, String openTag, String endTag) {
        int open;
        String s = sInitial;
        while ((open = s.indexOf(openTag)) >= 0) {
            int end = s.indexOf(endTag, open);
            s = s.substring(0, open) + s.substring(end + endTag.length());
        }
        return s;
    }

    private static String removeDivClasses(String type, String s) {
        return GrabPage.removeDiv("class", type, s);
    }

    private static String removeDivStyles(String type, String s) {
        return GrabPage.removeDiv("style", type, s);
    }

    private static String removeDiv(String attribute, String type, String sInitial) {
        int open;
        String s = sInitial;
        String openTag = "<div " + attribute + "=\"" + type;
        while ((open = s.indexOf(openTag)) >= 0) {
            int afterClose = GrabPage.afterMatchedDiv(s, open + openTag.length());
            s = s.substring(0, open) + s.substring(afterClose);
        }
        return s;
    }

    private static int afterMatchedDiv(String s, int startInitial) {
        int start = startInitial;
        while (true) {
            int nextOpen = s.indexOf(openDiv, start);
            int nextClose = s.indexOf(closeDiv, start);
            if (nextClose >= 0 && (nextOpen < 0 || nextClose < nextOpen)) {
                return nextClose + closeDiv.length();
            }
            if (nextOpen < 0) {
                return -1;
            }
            start = GrabPage.afterMatchedDiv(s, nextOpen + openDiv.length());
        }
    }

    public String toString() {
        return "GrabPage[" + this.host + "]";
    }
}

