/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedAction;

import fit.Parse;
import fitlibrary.definedAction.DefineActionsOnPageSlowly;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.utility.FileIO;
import fitlibrary.utility.SimpleWikiTranslator;
import fitlibrary.utility.TestResults;
import java.io.File;
import java.util.List;

public class DefineActionsOnPage
extends DefineActionsOnPageSlowly {
    public DefineActionsOnPage(String topPageName) {
        super(topPageName);
    }

    public Object interpretAfterFirstRow(Table tableWithPageName, TestResults testResults) {
        try {
            this.processPagesAsFiles(this.topPageName.substring(1));
        }
        catch (Exception e) {
            tableWithPageName.error(testResults, (Throwable)e);
        }
        return null;
    }

    private void processPagesAsFiles(String pageName) throws Exception {
        String fullPageName = "FitNesseRoot/" + pageName.replaceAll("\\.", "/");
        File diry = new File(this.fitNesseDiry(), fullPageName);
        List<File> files = FileIO.filesWithSuffix(diry, "txt");
        for (File file : files) {
            String wiki = FileIO.read(file);
            String html = SimpleWikiTranslator.translate(wiki);
            String fileName = file.getAbsolutePath().replaceAll("/", ".").replaceAll("\\\\", ".");
            if (!html.contains("<table")) continue;
            this.parseDefinitions(new Tables(new Parse(html)), this.determineClassName("", fileName), file.getAbsolutePath());
        }
    }
}

