/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedAction;

import fit.Parse;
import fitlibrary.DefineAction;
import fitlibrary.batch.fitnesseIn.ParallelFitNesseRepository;
import fitlibrary.batch.trinidad.TestDescriptor;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.ParseUtility;
import fitlibrary.utility.TestResults;
import java.io.File;
import java.util.concurrent.BlockingQueue;

public class DefineActionsOnPageSlowly
extends Traverse {
    protected String topPageName;
    private static String FITNESSE_DIRY = ".";

    public static void setFitNesseDiry(String diry) {
        FITNESSE_DIRY = diry;
    }

    public DefineActionsOnPageSlowly(String topPageName) {
        this.topPageName = topPageName;
    }

    public Object interpretAfterFirstRow(Table tableWithPageName, TestResults testResults) {
        try {
            this.processPages(this.topPageName.substring(1));
        }
        catch (Exception e) {
            tableWithPageName.error(testResults, (Throwable)e);
        }
        return null;
    }

    private void processPages(String pageName) throws Exception {
        TestDescriptor test;
        ParallelFitNesseRepository parallelFitNesseRepository = new ParallelFitNesseRepository(FITNESSE_DIRY);
        BlockingQueue<TestDescriptor> queue = parallelFitNesseRepository.getDefinedActions(pageName);
        while (!ParallelFitNesseRepository.isSentinel(test = queue.take())) {
            String html = ParseUtility.tabulize(test.getContent());
            if (!html.contains("<table")) continue;
            this.parseDefinitions(new Tables(new Parse(html)), this.determineClassName(pageName, test.getName()), test.getName());
        }
    }

    protected String determineClassName(String prefix, String pageName) {
        int nextDotPos;
        int classPos;
        String fullPageName = prefix + "." + pageName;
        if ("".equals(pageName)) {
            fullPageName = prefix;
        }
        if ((classPos = fullPageName.lastIndexOf(".Class")) >= 0 && (nextDotPos = fullPageName.indexOf(".", classPos + 1)) >= 0) {
            return fullPageName.substring(classPos + 6, nextDotPos);
        }
        return "";
    }

    protected void parseDefinitions(Tables tables, String className, String absoluteFileName) {
        Tables innerTables = tables;
        for (int i = 0; i < tables.size(); ++i) {
            Table nextTable = tables.table(i);
            if (i > 0 && this.isHR(nextTable.parse.leader)) {
                Table lastTableInDefinition = tables.table(i - 1);
                Parse more = lastTableInDefinition.parse.more;
                String trailer = lastTableInDefinition.parse.trailer;
                lastTableInDefinition.parse.more = null;
                lastTableInDefinition.parse.trailer = "";
                this.defineAction(innerTables, className, absoluteFileName);
                lastTableInDefinition.parse.more = more;
                lastTableInDefinition.parse.trailer = trailer;
                innerTables = new Tables(nextTable);
                continue;
            }
            if (!this.isHR(nextTable.parse.trailer) && i != tables.size() - 1) continue;
            this.defineAction(innerTables, className, absoluteFileName);
        }
    }

    private void defineAction(Tables innerTables, String className, String absoluteFileName) {
        Table defineActionTable = this.createDefineActionTable(innerTables);
        DefineAction defineAction = new DefineAction(className, absoluteFileName);
        defineAction.interpret(defineActionTable, new TestResults());
    }

    private Table createDefineActionTable(Tables innerTables) {
        Table defineActionTable = new Table();
        Row row = new Row();
        row.addCell("DefineAction");
        defineActionTable.addRow(row);
        row = new Row();
        row.addCell(new Cell(innerTables));
        defineActionTable.addRow(row);
        return defineActionTable;
    }

    private boolean isHR(String leader) {
        return leader != null && (leader.contains("<hr>") || leader.contains("<hr/>"));
    }

    protected File fitNesseDiry() {
        return new File(FITNESSE_DIRY);
    }
}

