/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedAction;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.ParseUtility;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinedActionTraverse
extends Traverse {
    private Tables body;

    public DefinedActionTraverse() {
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        Row header = table.row(1);
        HashSet<String> parameterNames = new HashSet<String>();
        for (int c = 0; c < header.size(); ++c) {
            Cell parameterCell = header.cell(c);
            String parameterName = parameterCell.text(this);
            if (parameterNames.contains(parameterName)) {
                parameterCell.error(testResults, new FitLibraryException("Duplicate parameter names"));
            }
            parameterNames.add(parameterName);
        }
        return null;
    }

    protected DefinedActionTraverse(Table defTable, int parameterCount) {
        Row header = defTable.row(1);
        if (header.size() != parameterCount) {
            throw new FitLibraryException("Mismatch in number of parameters to template");
        }
        HashMap<String, Object> mapToRef = new HashMap<String, Object>();
        for (int c = 0; c < header.size(); ++c) {
            mapToRef.put(header.text(c, this), DefinedActionTraverse.paramRef(c));
        }
        this.body = new Tables(ParseUtility.copyParse(defTable.row(2).cell(0).innerTables().parse()));
        this.macroReplace(this.body, mapToRef);
    }

    public Tables call(List<Object> parameters, TestResults results) {
        Tables copy = new Tables(ParseUtility.copyParse(this.body.parse()));
        this.substitute(parameters, copy);
        this.executeInstantiatedAction(results, copy);
        return copy;
    }

    protected void executeInstantiatedAction(TestResults results, Tables copy) {
        new BatchFitLibrary(new TableListener(results)).doTables(copy);
    }

    private void substitute(List<Object> parameters, Tables copy) {
        HashMap<String, Object> mapFromRef = new HashMap<String, Object>();
        for (int i = 0; i < parameters.size(); ++i) {
            mapFromRef.put(DefinedActionTraverse.paramRef(i), parameters.get(i));
        }
        this.macroReplace(copy, mapFromRef);
    }

    private void macroReplace(Tables tables, Map<String, Object> mapToRef) {
        ArrayList<String> reverseSortOrder = new ArrayList<String>(mapToRef.keySet());
        Collections.sort(reverseSortOrder, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg1.compareTo(arg0);
            }
        });
        for (int t = 0; t < tables.size(); ++t) {
            Table table = tables.table(t);
            for (int r = 0; r < table.size(); ++r) {
                Row row = table.row(r);
                for (int c = 0; c < row.size(); ++c) {
                    Cell cell = row.cell(c);
                    String text = cell.text(this);
                    for (String key : reverseSortOrder) {
                        if (!text.contains(key)) continue;
                        Object value = mapToRef.get(key);
                        if (value instanceof Table) {
                            cell.setInnerTables(new Tables((Table)value));
                            continue;
                        }
                        text = text.replaceAll(key, (String)value);
                        cell.setText(text);
                    }
                }
            }
        }
    }

    private static String paramRef(int c) {
        return "%__%" + c + "%__%";
    }
}

