/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedAction;

import fitlibrary.definedAction.DefinedAction;
import fitlibrary.definedAction.DefinedActionsRepository;
import fitlibrary.definedAction.DefinedMultiAction;
import fitlibrary.definedAction.MultiParameterSubstitution;
import fitlibrary.definedAction.ParameterSubstitution;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.global.TemporaryPlugBoardForRuntime;
import fitlibrary.runtime.RuntimeContext;
import fitlibrary.table.Row;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.caller.ValidCall;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinedActionsRepositoryStandard
implements DefinedActionsRepository {
    private Map<DefinedAction, ParameterSubstitution> definedActionMapForPlainText = new ConcurrentHashMap<DefinedAction, ParameterSubstitution>();
    private Map<String, Map<DefinedAction, ParameterSubstitution>> classMapForPlainText = new ConcurrentHashMap<String, Map<DefinedAction, ParameterSubstitution>>();
    private Map<DefinedAction, ParameterSubstitution> definedActionMapForCamel = new ConcurrentHashMap<DefinedAction, ParameterSubstitution>();
    private Map<String, Map<DefinedAction, ParameterSubstitution>> classMapForCamel = new ConcurrentHashMap<String, Map<DefinedAction, ParameterSubstitution>>();
    private Map<DefinedMultiAction, MultiParameterSubstitution> definedMultiActionMap = new ConcurrentHashMap<DefinedMultiAction, MultiParameterSubstitution>();
    private Map<String, Map<DefinedMultiAction, MultiParameterSubstitution>> classMultiActionMap = new ConcurrentHashMap<String, Map<DefinedMultiAction, MultiParameterSubstitution>>();

    @Override
    public void define(Row parametersRow, String wikiClassName, ParameterSubstitution parameterSubstitution, Evaluator evaluator, String absoluteFileName) {
        this.defineCamel(parametersRow, wikiClassName, parameterSubstitution, evaluator, absoluteFileName);
        this.definePlain(parametersRow, wikiClassName, parameterSubstitution, evaluator, absoluteFileName);
    }

    @Override
    public ParameterSubstitution lookupByCamel(String name, int argCount) {
        return this.definedActionMapForCamel.get(new DefinedAction(name, argCount));
    }

    @Override
    public ParameterSubstitution lookupByClassByCamel(String className, String name, int argCount, RuntimeContext variables) {
        ParameterSubstitution macroSubstitution;
        DefinedAction macro = new DefinedAction(name, argCount);
        Map<DefinedAction, ParameterSubstitution> map = this.classMapForCamel.get(className);
        if (map != null && (macroSubstitution = map.get(macro)) != null) {
            return macroSubstitution;
        }
        String superClass = variables.dynamicVariables().getAsString(className + ".super");
        if (superClass != null && !"".equals(superClass)) {
            return TemporaryPlugBoardForRuntime.definedActionsRepository().lookupByClassByCamel(superClass, name, argCount, variables);
        }
        return this.definedActionMapForCamel.get(macro);
    }

    @Override
    public void findPlainTextCall(String textCall, List<ValidCall> results) {
        for (DefinedAction action : this.definedActionMapForPlainText.keySet()) {
            action.findCall(textCall, results);
        }
    }

    @Override
    public void defineMultiDefinedAction(String name, ArrayList<String> formalParameters, Tables body, String absoluteFileName) {
        this.definedMultiActionMap.put(new DefinedMultiAction(name), new MultiParameterSubstitution(formalParameters, body, absoluteFileName));
    }

    @Override
    public MultiParameterSubstitution lookupMulti(String name) {
        return this.definedMultiActionMap.get(new DefinedMultiAction(name));
    }

    @Override
    public void clear() {
        this.definedActionMapForPlainText.clear();
        this.classMapForPlainText.clear();
        this.definedActionMapForCamel.clear();
        this.classMapForCamel.clear();
        this.definedMultiActionMap.clear();
        this.classMultiActionMap.clear();
    }

    protected void definePlain(Row parametersRow, String wikiClassName, ParameterSubstitution parameterSubstitution, Evaluator evaluator, String absoluteFileName) {
        String name = parametersRow.methodNameForPlain(evaluator);
        DefinedAction definedAction = new DefinedAction(name, parametersRow.argumentCount());
        Map<DefinedAction, ParameterSubstitution> map = this.getClassMapForPlain(wikiClassName);
        if (map.get(definedAction) != null) {
            throw new FitLibraryException("Duplicate defined action: " + name + " defined in " + absoluteFileName + " but already defined in " + map.get(definedAction).getAbsoluteFileName());
        }
        map.put(definedAction, parameterSubstitution);
    }

    protected void defineCamel(Row parametersRow, String wikiClassName, ParameterSubstitution parameterSubstitution, Evaluator evaluator, String absoluteFileName) {
        String name = parametersRow.methodNameForCamel(evaluator);
        DefinedAction definedAction = new DefinedAction(name, parametersRow.argumentCount());
        Map<DefinedAction, ParameterSubstitution> map = this.getClassMapForCamel(wikiClassName);
        if (map.get(definedAction) != null) {
            throw new FitLibraryException("Duplicate defined action: " + name + "/" + parametersRow.argumentCount() + " defined in " + absoluteFileName + " but already defined in " + map.get(definedAction).getAbsoluteFileName());
        }
        map.put(definedAction, parameterSubstitution);
    }

    protected Map<DefinedAction, ParameterSubstitution> getClassMapForPlain(String wikiClassName) {
        Map<DefinedAction, ParameterSubstitution> currentMap = this.definedActionMapForPlainText;
        if (this.wikiClassBased(wikiClassName) && (currentMap = this.classMapForPlainText.get(wikiClassName)) == null) {
            currentMap = new ConcurrentHashMap<DefinedAction, ParameterSubstitution>();
            this.classMapForPlainText.put(wikiClassName, currentMap);
        }
        return currentMap;
    }

    protected Map<DefinedAction, ParameterSubstitution> getClassMapForCamel(String wikiClassName) {
        Map<DefinedAction, ParameterSubstitution> currentMap = this.definedActionMapForCamel;
        if (this.wikiClassBased(wikiClassName) && (currentMap = this.classMapForCamel.get(wikiClassName)) == null) {
            currentMap = new ConcurrentHashMap<DefinedAction, ParameterSubstitution>();
            this.classMapForCamel.put(wikiClassName, currentMap);
        }
        return currentMap;
    }

    protected boolean wikiClassBased(String wikiClassName) {
        return !"".equals(wikiClassName);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Plain Text:\n");
        for (DefinedAction action : this.definedActionMapForPlainText.keySet()) {
            s.append(action.toString());
            s.append("\n");
        }
        s.append("\n\nCamel:\n");
        for (DefinedAction action : this.definedActionMapForCamel.keySet()) {
            s.append(action.toString());
            s.append("\n");
        }
        return s.toString();
    }
}

