/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedAction;

import fitlibrary.dynamicVariable.DynamicVariables;
import fitlibrary.dynamicVariable.LocalDynamicVariables;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.table.Row;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Evaluator;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiParameterSubstitution {
    private List<String> formalParameters;
    private Tables tables;
    private String absoluteFileName;

    public MultiParameterSubstitution(List<String> formalParameters, Tables tables, String absoluteFileName) {
        this.formalParameters = formalParameters;
        this.tables = tables;
        this.absoluteFileName = absoluteFileName;
    }

    public void createMappingsForCall(List<String> actuals, LocalDynamicVariables vars) {
        if (actuals.size() != this.formalParameters.size()) {
            throw new RuntimeException("Formals and actuals don't match");
        }
        for (int i = 0; i < actuals.size(); ++i) {
            vars.putParameter(this.formalParameters.get(i), actuals.get(i));
        }
    }

    public Tables getCopyOfBody() {
        return this.tables.deepCopy();
    }

    public String getAbsoluteFileName() {
        return this.absoluteFileName;
    }

    public void verifyParameters(Row row, Evaluator evaluator) {
        if (row.size() != this.formalParameters.size()) {
            throw new FitLibraryException("Expected " + this.formalParameters.size() + " parameters but there were " + row.size());
        }
        HashSet<String> set = new HashSet<String>();
        for (int c = 0; c < row.size(); ++c) {
            String actualName = row.text(c, evaluator);
            if (!this.formalParameters.contains(actualName)) {
                throw new FitLibraryException("Unknown parameter: '" + actualName + "'");
            }
            if (set.contains(actualName)) {
                throw new FitLibraryException("Duplicate parameter: '" + actualName + "'");
            }
            set.add(actualName);
        }
    }

    public void bind(Row parameterRow, Row row, DynamicVariables dynamicVariables, Evaluator evaluator) {
        if (row.size() != this.formalParameters.size()) {
            throw new FitLibraryException("Expected " + this.formalParameters.size() + " parameters but there were " + row.size());
        }
        for (int c = 0; c < row.size(); ++c) {
            String parameter = parameterRow.text(c, evaluator);
            String actual = row.text(c, evaluator);
            dynamicVariables.putParameter(parameter, actual);
        }
    }
}

