/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedAction;

import fit.exception.FitFailureException;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Evaluator;
import fitlibrary.utility.StringUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSubstitution {
    private Tables tables;
    private String absoluteFileName;

    public String getAbsoluteFileName() {
        return this.absoluteFileName;
    }

    public ParameterSubstitution(List<String> formalParameters, Tables tables, Evaluator evaluator, String absoluteFileName) {
        this.tables = tables;
        this.absoluteFileName = absoluteFileName;
        HashMap<String, Object> mapToRef = new HashMap<String, Object>();
        for (int c = 0; c < formalParameters.size(); ++c) {
            String formal = formalParameters.get(c);
            if (mapToRef.get(formal) != null) {
                throw new FitFailureException("Duplicated parameter: " + formal);
            }
            mapToRef.put(formal, ParameterSubstitution.paramRef(c));
        }
        ParameterSubstitution.macroReplace(tables, mapToRef, evaluator);
    }

    public Tables substitute(List<Object> actualParameters, Evaluator evaluator) {
        Tables copy = this.tables.deepCopy();
        HashMap<String, Object> mapFromRef = new HashMap<String, Object>();
        for (int i = 0; i < actualParameters.size(); ++i) {
            mapFromRef.put(ParameterSubstitution.paramRef(i), actualParameters.get(i));
        }
        ParameterSubstitution.macroReplace(copy, mapFromRef, evaluator);
        return copy;
    }

    private static void macroReplace(Tables tables, Map<String, Object> mapToRef, Evaluator evaluator) {
        ArrayList<String> reverseSortOrder = new ArrayList<String>(mapToRef.keySet());
        Collections.sort(reverseSortOrder, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg1.compareTo(arg0);
            }
        });
        for (String key : reverseSortOrder) {
            ParameterSubstitution.macroReplaceTables(tables, key, mapToRef.get(key), evaluator);
        }
    }

    private static void macroReplaceTables(Tables tables, String key, Object value, Evaluator evaluator) {
        for (int t = 0; t < tables.size(); ++t) {
            Table table = tables.table(t);
            for (int r = 0; r < table.size(); ++r) {
                Row row = table.row(r);
                for (int c = 0; c < row.size(); ++c) {
                    ParameterSubstitution.macroReplaceCell(row.cell(c), key, value, evaluator);
                }
            }
        }
    }

    private static void macroReplaceCell(Cell cell, String key, Object value, Evaluator evaluator) {
        if (cell.hasEmbeddedTable()) {
            ParameterSubstitution.macroReplaceTables(cell.getEmbeddedTables(), key, value, evaluator);
        }
        String text = cell.fullText();
        if (value instanceof String) {
            String update = StringUtility.replaceString(text, key, (String)value);
            if (!update.equals(text)) {
                cell.setText(update);
            }
        } else {
            Tables valueTables = (Tables)value;
            int at = text.indexOf(key);
            if (at < 0) {
                return;
            }
            Tables addedTables = valueTables.deepCopy();
            if (cell.hasEmbeddedTable()) {
                cell.getEmbeddedTables().parse.last().more = addedTables.parse;
            } else {
                cell.setInnerTables(addedTables);
            }
            cell.getEmbeddedTables().parse.leader = text.substring(0, at);
            cell.getEmbeddedTables().parse.last().trailer = text.substring(at + key.length());
        }
    }

    private static String paramRef(int c) {
        return "%__%" + c + "%__%";
    }

    public String toString() {
        return "MacroSubstitution[" + this.tables.toString() + "]";
    }
}

