/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.differences;

import fitlibrary.differences.LocalFile;
import fitlibrary.utility.StringUtility;
import java.io.File;

public class FitNesseGlobalFile
implements LocalFile {
    protected static final String FITNESSE_ROOT = "FitNesseRoot";
    private String fileName;
    private boolean absolute = false;

    public FitNesseGlobalFile(File file) {
        String path = file.getPath();
        if (path.startsWith(FITNESSE_ROOT)) {
            this.fileName = path.substring(FITNESSE_ROOT.length());
            this.fileName = StringUtility.replaceString(this.fileName, "\\", "/");
        } else {
            this.fileName = file.getAbsolutePath();
            this.absolute = true;
        }
    }

    public LocalFile withSuffix(String s) {
        throw new RuntimeException("Not implemented");
    }

    public File getFile() {
        throw new RuntimeException("Not implemented");
    }

    public void mkdirs() {
        throw new RuntimeException("Not implemented");
    }

    public String htmlImageLink() {
        throw new RuntimeException("Not implemented");
    }

    public String htmlLink() {
        if (this.absolute) {
            return "<a href=\"file://" + this.fileName + "\">" + this.fileName + "</a>";
        }
        String name = this.fileName;
        int last = this.fileName.lastIndexOf("/");
        if (last >= 0) {
            name = name.substring(last + 1);
        }
        return "<a href=\"http://localhost" + this.fileName + "\">" + name + "</a>";
    }
}

