/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.differences;

import fitlibrary.differences.LocalFile;
import fitlibrary.log.Logging;
import fitlibrary.utility.StringUtility;
import java.io.File;

public class FolderRunnerLocalFile
implements LocalFile {
    protected File file;
    private static File CONTEXT = new File(".");

    public FolderRunnerLocalFile(File file) {
        this.file = file;
    }

    public FolderRunnerLocalFile(String localFileNameInitial) {
        String localFileName = localFileNameInitial;
        if (!localFileName.startsWith("files/") && !localFileName.startsWith("files\\")) {
            localFileName = "files/" + localFileName;
        }
        Logging.log(this, "FolderRunnerLocalFile(): " + localFileName);
        this.file = new File(CONTEXT, localFileName);
    }

    public LocalFile withSuffix(String suffix) {
        String name = this.file.getPath();
        int last = name.lastIndexOf(".");
        if (last >= 0) {
            name = name.substring(0, last + 1) + suffix;
        }
        Logging.log(this, "withSuffix(): " + name);
        return new FolderRunnerLocalFile(name);
    }

    public File getFile() {
        Logging.log(this, "getFile(): " + this.file.getAbsolutePath());
        return this.file;
    }

    public void mkdirs() {
        File diry = this.file.getParentFile();
        Logging.log(this, "mkdirs(): " + diry.getAbsolutePath());
        if (!diry.exists()) {
            diry.mkdirs();
        }
    }

    public String htmlImageLink() {
        return "<img src=\"file:///" + this.escape(this.file.getPath()) + "\">";
    }

    public String htmlLink() {
        return "<a href=\"file:///" + this.escape(this.file.getPath()) + "\">" + this.file.getName() + "</a>";
    }

    protected String escape(String path) {
        return StringUtility.replaceString(path, "\\", "/").replaceAll(" ", "%20");
    }

    public boolean equals(Object object) {
        if (!(object instanceof FolderRunnerLocalFile)) {
            return false;
        }
        String absolutePath = ((FolderRunnerLocalFile)object).file.getPath();
        String otherAbsolutePath = this.file.getPath();
        boolean equals = absolutePath.equals(otherAbsolutePath);
        Logging.log(this, "equals(): " + equals + " with: '" + absolutePath + "' and '" + otherAbsolutePath);
        return equals;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return "FolderRunnerLocalFile[" + this.file.getName() + "]";
    }

    public static void setContext(File context) {
        CONTEXT = context;
    }
}

