/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.dynamicVariable;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

public class RecordDynamicVariables {
    private static ThreadLocal<Recording> recordings = new ThreadLocal();

    public static void recordToFile(String fileName) {
        recordings.set(new Recording(fileName));
    }

    public static boolean recording() {
        return recordings.get() != null;
    }

    public static void record(String key, String value) {
        if (!value.contains("@{" + key + "}")) {
            recordings.get().record(key, value);
        }
    }

    public static void write() throws IOException {
        Recording recording = recordings.get();
        recordings.remove();
        recording.write();
    }

    static class Recording {
        private String fileName;
        private Properties props = new Properties();

        public Recording(String fileName) {
            this.fileName = fileName;
        }

        public void record(String key, String value) {
            this.props.setProperty(key, value);
        }

        public void write() throws IOException {
            if (this.fileName.equals("pleaseThrowAnExceptionOnThisFile")) {
                throw new IOException("Some file exception");
            }
            Properties original = new Properties();
            this.collectOriginalProperties(original);
            for (Object key : this.props.keySet()) {
                original.setProperty(key.toString(), this.props.getProperty(key.toString()));
            }
            FileOutputStream fileWriter = new FileOutputStream(new File(this.fileName));
            original.store(fileWriter, "Recorded on " + new Date());
            fileWriter.close();
        }

        private void collectOriginalProperties(Properties original) {
            try {
                FileInputStream fileReader = new FileInputStream(new File(this.fileName));
                original.load(fileReader);
                fileReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

